/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.util.system.OS;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\b\u0010\"\u001a\u00020\bH\u0002J\b\u0010#\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\bH\u0002J\n\u0010%\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010&\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010'\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0003R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/featureStatistics/fusCollectors/OsDataCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "OS_NAMES", "", "", "LOCALES", "SHELLS", "getSHELLS$annotations", "DISTROS", "getDISTROS$annotations", "OS_NAME", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "OS_LANG", "OS_TZ", "OS_SHELL", "DISTRO", "RELEASE", "UNDER_WSL", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "GLIBC", "OS_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "LINUX", "WINDOWS", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getOSName", "getLanguage", "getTimeZone", "getShell", "coerce", "value", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nOsDataCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OsDataCollector.kt\ncom/intellij/featureStatistics/fusCollectors/OsDataCollector\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n37#2,2:99\n1#3:101\n*S KotlinDebug\n*F\n+ 1 OsDataCollector.kt\ncom/intellij/featureStatistics/fusCollectors/OsDataCollector\n*L\n68#1:99,2\n*E\n"})
public final class OsDataCollector
extends ApplicationUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("system.os", 20, null, 4, null);
    @NotNull
    private final List<String> OS_NAMES;
    @NotNull
    private final List<String> LOCALES;
    @NotNull
    private final List<String> SHELLS;
    @NotNull
    private final List<String> DISTROS;
    @NotNull
    private final StringEventField OS_NAME;
    @NotNull
    private final StringEventField OS_LANG;
    @NotNull
    private final StringEventField OS_TZ;
    @NotNull
    private final StringEventField OS_SHELL;
    @NotNull
    private final StringEventField DISTRO;
    @NotNull
    private final StringEventField RELEASE;
    @NotNull
    private final BooleanEventField UNDER_WSL;
    @NotNull
    private final StringEventField GLIBC;
    @NotNull
    private final VarargEventId OS_EVENT;
    @NotNull
    private final VarargEventId LINUX;
    @NotNull
    private final EventId1<Long> WINDOWS;

    public OsDataCollector() {
        Object[] objectArray = new String[]{"Windows", "Mac", "Linux", "FreeBSD", "Other"};
        this.OS_NAMES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"am", "ar", "as", "az", "bn", "cs", "da", "de", "el", "en", "es", "fa", "fr", "gu", "ha", "hi", "hu", "ig", "in", "it", "ja", "kk", "kn", "ko", "ml", "mr", "my", "nb", "ne", "nl", "nn", "no", "or", "pa", "pl", "pt", "ro", "ru", "rw", "sd", "si", "so", "sv", "ta", "te", "th", "tr", "uk", "ur", "uz", "vi", "yo", "zh", "zu"};
        this.LOCALES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"sh", "ash", "bash", "csh", "dash", "fish", "ksh", "pwsh", "tcsh", "xonsh", "zsh", "nu", "other", "unknown"};
        this.SHELLS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"almalinux", "alpine", "amzn", "arch", "bunsenlabs", "centos", "chromeos", "debian", "deepin", "devuan", "elementary", "endeavouros", "fedora", "galliumos", "garuda", "gentoo", "kali", "linuxmint", "mageia", "manjaro", "neon", "nixos", "ol", "opensuse-leap", "opensuse-tumbleweed", "parrot", "pop", "pureos", "raspbian", "rhel", "rocky", "rosa", "sabayon", "slackware", "solus", "ubuntu", "void", "zorin", "other", "unknown"};
        this.DISTROS = CollectionsKt.listOf((Object[])objectArray);
        this.OS_NAME = EventFields.String((String)"name", this.OS_NAMES);
        this.OS_LANG = EventFields.String((String)"locale", this.LOCALES);
        this.OS_TZ = EventFields.StringValidatedByRegexpReference$default((String)"time_zone", (String)"time_zone", null, (int)4, null);
        this.OS_SHELL = EventFields.String((String)"shell", this.SHELLS);
        this.DISTRO = EventFields.String((String)"distro", this.DISTROS);
        this.RELEASE = EventFields.StringValidatedByRegexpReference$default((String)"release", (String)"version", null, (int)4, null);
        this.UNDER_WSL = EventFields.Boolean((String)"wsl");
        this.GLIBC = EventFields.StringValidatedByRegexpReference$default((String)"glibc", (String)"version", null, (int)4, null);
        objectArray = new EventField[]{this.OS_NAME, EventFields.Version, this.OS_LANG, this.OS_TZ, this.OS_SHELL};
        this.OS_EVENT = this.GROUP.registerVarargEvent("os.name", (EventField[])objectArray);
        objectArray = new EventField[]{this.DISTRO, this.RELEASE, this.UNDER_WSL, this.GLIBC};
        this.LINUX = this.GROUP.registerVarargEvent("linux", (EventField[])objectArray);
        this.WINDOWS = this.GROUP.registerEvent("windows", (EventField)EventFields.Long$default((String)"build", null, (int)2, null));
    }

    private static /* synthetic */ void getSHELLS$annotations() {
    }

    private static /* synthetic */ void getDISTROS$annotations() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        String tz = this.getTimeZone();
        Object object = new MetricEvent[1];
        EventPair[] eventPairArray = new EventPair[]{this.OS_NAME.with((Object)this.getOSName()), EventFields.Version.with((Object)OS.CURRENT.version()), this.OS_LANG.with((Object)this.getLanguage()), this.OS_TZ.with((Object)tz), this.OS_SHELL.with((Object)this.getShell())};
        object[0] = this.OS_EVENT.metric(eventPairArray);
        Set metrics = SetsKt.mutableSetOf((Object[])object);
        if (OS.CURRENT == OS.Linux) {
            OS.OsInfo osInfo = OS.CURRENT.getOsInfo();
            Intrinsics.checkNotNull((Object)osInfo, (String)"null cannot be cast to non-null type com.intellij.util.system.OS.LinuxInfo");
            OS.LinuxInfo osInfo2 = (OS.LinuxInfo)osInfo;
            Object object2 = new EventPair[]{this.DISTRO.with((Object)this.coerce(this.DISTROS, osInfo2.getDistro())), this.RELEASE.with((Object)osInfo2.getRelease()), this.UNDER_WSL.with((Object)osInfo2.isUnderWsl())};
            List linuxMetrics = CollectionsKt.mutableListOf((Object[])object2);
            String string = osInfo2.getGlibcVersion();
            if (string != null) {
                String it = string;
                boolean bl = false;
                linuxMetrics.add(this.GLIBC.with((Object)it));
            }
            object2 = metrics;
            Collection $this$toTypedArray$iv = linuxMetrics;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EventPair[] eventPairArray2 = thisCollection$iv.toArray(new EventPair[0]);
            object2.add(this.LINUX.metric(Arrays.copyOf(eventPairArray2, eventPairArray2.length)));
        } else if (OS.CURRENT == OS.Windows) {
            object = metrics;
            OS.OsInfo osInfo = OS.CURRENT.getOsInfo();
            Intrinsics.checkNotNull((Object)osInfo, (String)"null cannot be cast to non-null type com.intellij.util.system.OS.WindowsInfo");
            Long l = ((OS.WindowsInfo)osInfo).getBuildNumber();
            object.add(this.WINDOWS.metric((Object)(l != null ? l : -1L)));
        }
        return metrics;
    }

    private final String getOSName() {
        OS oS = OS.CURRENT;
        return switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> "Windows";
            case 2 -> "Mac";
            case 3 -> "Linux";
            case 4 -> "FreeBSD";
            case 5 -> "Other";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getLanguage() {
        String string = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        return string;
    }

    private final String getTimeZone() {
        String string = OffsetDateTime.now().getOffset().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getShell() {
        String string;
        if (OS.CURRENT == OS.Windows) {
            string = null;
        } else {
            Object object;
            Object object2 = this;
            List<String> list2 = this.SHELLS;
            OsDataCollector osDataCollector = this;
            try {
                String string2;
                OsDataCollector $this$getShell_u24lambda_u240 = object2;
                boolean bl = false;
                String string3 = System.getenv("SHELL");
                if (string3 != null) {
                    String it = string3;
                    boolean bl2 = false;
                    Path path = Path.of(it, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    string2 = PathsKt.getName((Path)path);
                } else {
                    string2 = null;
                }
                object = Result.constructor-impl(string2);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object3 = object;
            object2 = object3;
            string = osDataCollector.coerce(list2, (String)(Result.isFailure-impl((Object)object2) ? null : object2));
        }
        return string;
    }

    private final String coerce(List<String> $this$coerce, String value) {
        String string = value;
        return string == null ? "unknown" : ($this$coerce.contains(string) ? value : "other");
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.FreeBSD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Other.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

