/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.MainMenuDisplayMode;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.ExperimentalUI;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/actions/ChangeMainMenuModeAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "mode", "Lcom/intellij/ide/ui/MainMenuDisplayMode;", "<init>", "(Lcom/intellij/ide/ui/MainMenuDisplayMode;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.platform.ide.impl"})
public final class ChangeMainMenuModeAction
extends ToggleAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final MainMenuDisplayMode mode;

    public ChangeMainMenuModeAction(@NotNull MainMenuDisplayMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.mode = mode;
        this.getTemplatePresentation().setText(this.mode.getDescription());
        this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return UISettings.Companion.getInstance().getMainMenuDisplayMode() == this.mode;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        MainMenuDisplayMode currentDisplayMode;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!state2) {
            return;
        }
        boolean restartNeeded = false;
        UISettings uiSettings = UISettings.Companion.getInstance();
        if (SystemInfoRt.isUnix && !SystemInfoRt.isMac && ((currentDisplayMode = uiSettings.getMainMenuDisplayMode()) == MainMenuDisplayMode.SEPARATE_TOOLBAR || this.mode == MainMenuDisplayMode.SEPARATE_TOOLBAR)) {
            Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
            int result2 = Messages.showYesNoCancelDialog((String)IdeBundle.message((String)"dialog.message.restarted.to.apply.changes", (Object[])objectArray), (String)ActionsBundle.message((String)"action.ChangeMainMenu.restart.dialog.title", (Object[])new Object[0]), (String)IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0]), (String)IdeBundle.message((String)"ide.notnow.action", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            switch (result2) {
                case 0: {
                    restartNeeded = true;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        uiSettings.setMainMenuDisplayMode(this.mode);
        if (restartNeeded) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        } else {
            uiSettings.fireUISettingsChanged();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(ExperimentalUI.Companion.isNewUI() && !SystemInfo.isMac);
    }
}

