/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.ConsentSettingsBodyKt;
import com.intellij.ide.gdpr.localConsents.LocalConsentOptions;
import com.intellij.ide.gdpr.ui.consents.AiDataCollectionConsentUi;
import com.intellij.ide.gdpr.ui.consents.ConsentUi;
import com.intellij.ide.gdpr.ui.consents.DefaultConsentUi;
import com.intellij.ide.gdpr.ui.consents.TraceDataCollectionConsentUI;
import com.intellij.ide.gdpr.ui.consents.UsageStatisticsConsentUi;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConsentSettingsUi
extends JPanel
implements ConfigurableUi<List<Consent>> {
    private final Collection<ConsentStateSupplier> consentMapping = new ArrayList<ConsentStateSupplier>();
    private final boolean myPreferencesMode;
    private final boolean myIsJetBrainsVendor;

    public ConsentSettingsUi(boolean preferencesMode) {
        this(preferencesMode, ApplicationInfoImpl.getShadowInstance().isVendorJetBrains());
    }

    @ApiStatus.Internal
    public ConsentSettingsUi(boolean preferencesMode, boolean isJetBrainsVendor) {
        this.myPreferencesMode = preferencesMode;
        this.myIsJetBrainsVendor = isJetBrainsVendor;
        this.setLayout(new GridLayout(1, 1));
    }

    public void reset(@NotNull List<Consent> consents) {
        if (consents == null) {
            ConsentSettingsUi.$$$reportNull$$$0(0);
        }
        this.consentMapping.clear();
        this.removeAll();
        if (consents.isEmpty()) {
            this.add((Component)ConsentSettingsBodyKt.createNoOptionsConsentSettings(this.myPreferencesMode));
            return;
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)ConsentSettingsBodyKt.createConsentSettings(this.consentMapping, this.myPreferencesMode, this.myIsJetBrainsVendor, consents), 20, 30);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)scrollPane);
    }

    static int getParagraphSpace() {
        return JBUIScale.scale((int)10);
    }

    @NlsSafe
    private static String getParagraphTag() {
        return "<p style=\"margin-bottom:" + ConsentSettingsUi.getParagraphSpace() + "px;\">";
    }

    @NotNull
    static JEditorPane createSingleConsent(Consent consent) {
        JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
        viewer.setOpaque(false);
        viewer.setFocusable(false);
        UIUtil.doNotScrollToCaret((JTextComponent)viewer);
        viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                URL url;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((url = e.getURL()) != null) {
                    BrowserUtil.browse((URL)url);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/gdpr/ConsentSettingsUi$1", "hyperlinkActivated"));
            }
        });
        viewer.setText("<html><body>" + ConsentSettingsUi.replaceParagraphs(consent.getText()) + "</body></html>");
        StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
        styleSheet.addRule("body {margin-top:0;padding-top:0;}");
        styleSheet.addRule("h2, em {margin-top:" + JBUIScale.scaleFontSize((float)20.0f) + "pt;}");
        styleSheet.addRule("h1, h2, h3, p, h4, em {margin-bottom:0;padding-bottom:0;}");
        styleSheet.addRule("p, h1 {margin-top:0;padding-top:" + JBUIScale.scaleFontSize((float)6.0f) + "pt;}");
        styleSheet.addRule("li {margin-bottom:" + JBUIScale.scaleFontSize((float)6.0f) + "pt;}");
        styleSheet.addRule("h2 {margin-top:0;padding-top:" + JBUIScale.scaleFontSize((float)13.0f) + "pt;}");
        styleSheet.addRule("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}");
        styleSheet.addRule("a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}");
        styleSheet.addRule("a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}");
        viewer.setCaretPosition(0);
        JEditorPane jEditorPane = viewer;
        if (jEditorPane == null) {
            ConsentSettingsUi.$$$reportNull$$$0(1);
        }
        return jEditorPane;
    }

    @ApiStatus.Internal
    @NotNull
    public static ConsentUi getConsentUi(Consent consent) {
        if (ConsentOptions.condUsageStatsConsent().test(consent)) {
            return new UsageStatisticsConsentUi(consent);
        }
        if (ConsentOptions.condAiDataCollectionConsent().test(consent)) {
            return new AiDataCollectionConsentUi(consent);
        }
        if (LocalConsentOptions.condTraceDataCollectionComLocalConsent().test(consent) || LocalConsentOptions.condTraceDataCollectionNonComLocalConsent().test(consent)) {
            return new TraceDataCollectionConsentUI(consent);
        }
        return new DefaultConsentUi(consent);
    }

    @Contract(pure=true)
    private static String replaceParagraphs(String text2) {
        return ConsentSettingsUi.getParagraphTag() + StringUtil.replace((String)text2, (String)"\n", (String)("</p>" + ConsentSettingsUi.getParagraphTag())) + "</p>";
    }

    @NotNull
    private List<Consent> getState() {
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (ConsentStateSupplier supplier : this.consentMapping) {
            result2.add(supplier.consent.derive(supplier.getState()));
        }
        result2.sort(Comparator.comparing(ConsentBase::getId));
        ArrayList<Consent> arrayList = result2;
        if (arrayList == null) {
            ConsentSettingsUi.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isModified(@NotNull List<Consent> consents) {
        if (consents == null) {
            ConsentSettingsUi.$$$reportNull$$$0(3);
        }
        List<Consent> state2 = this.getState();
        if (consents.size() != state2.size()) {
            return true;
        }
        for (int i2 = 0; i2 < state2.size(); ++i2) {
            Consent consent2;
            Consent consent1 = state2.get(i2);
            if (!consent1.equals(consent2 = consents.get(i2))) {
                return true;
            }
            if (consent1.isAccepted() == consent2.isAccepted()) continue;
            return true;
        }
        return false;
    }

    public void apply(@NotNull List<Consent> consents) {
        if (consents == null) {
            ConsentSettingsUi.$$$reportNull$$$0(4);
        }
        consents.clear();
        consents.addAll(this.getState());
    }

    @NotNull
    public JComponent getComponent() {
        ConsentSettingsUi consentSettingsUi = this;
        if (consentSettingsUi == null) {
            ConsentSettingsUi.$$$reportNull$$$0(5);
        }
        return consentSettingsUi;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/ConsentSettingsUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/ConsentSettingsUi";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleConsent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }

    record ConsentStateSupplier(Consent consent, Supplier<Boolean> getter) {
        boolean getState() {
            return this.getter.get();
        }
    }
}

