/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginManagerConfigurablePanel;
import com.intellij.ide.plugins.newui.PluginsViewCustomizerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginManagerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider {
    public static final String ID = "preferences.pluginManager";
    public static final String SELECTION_TAB_KEY = "PluginConfigurable.selectionTab";
    public static final DataKey<Consumer<PluginInstallCallbackData>> PLUGIN_INSTALL_CALLBACK_DATA_KEY = DataKey.create((String)"PLUGIN_INSTALL_CALLBACK_DATA_KEY");
    public static final Color MAIN_BG_COLOR = JBColor.namedColor((String)"Plugins.background", (Color)JBColor.lazy(() -> JBColor.isBright() ? UIUtil.getListBackground() : new Color(0x313335)));
    public static final Color SEARCH_BG_COLOR = JBColor.namedColor((String)"Plugins.SearchField.background", (Color)MAIN_BG_COLOR);
    public static final Color SEARCH_FIELD_BORDER_COLOR = JBColor.namedColor((String)"Plugins.borderColor", (Color)JBColor.border());
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    private static final Logger LOG = Logger.getInstance(PluginManagerConfigurable.class);
    private PluginManagerConfigurablePanel myPanel;

    @Deprecated
    public PluginManagerConfigurable(@Nullable Project project2) {
        this();
    }

    public PluginManagerConfigurable() {
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return ID;
    }

    @NotNull
    public JComponent getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(0);
        }
        PluginManagerConfigurablePanel panel2 = this.createPanelIfNeeded();
        JComponent jComponent = panel2.getCenterComponent(controller);
        if (jComponent == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getTopComponent() {
        JComponent jComponent = this.getCenterComponent(Configurable.TopComponentController.EMPTY);
        if (jComponent == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    public JComponent createComponent() {
        PluginManagerConfigurablePanel panel2 = this.createPanelIfNeeded();
        try {
            PluginsViewCustomizerKt.getPluginsViewCustomizer().processConfigurable(this);
        }
        catch (Exception e) {
            LOG.error("Error while processing configurable", (Throwable)e);
        }
        JComponent jComponent = panel2.getComponent();
        if (jComponent == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    private PluginManagerConfigurablePanel createPanelIfNeeded() {
        return this.createPanelIfNeeded(null);
    }

    @NotNull
    private PluginManagerConfigurablePanel createPanelIfNeeded(@Nullable String searchQuery) {
        if (this.myPanel == null) {
            this.myPanel = new PluginManagerConfigurablePanel();
            this.myPanel.init(searchQuery);
        }
        PluginManagerConfigurablePanel pluginManagerConfigurablePanel = this.myPanel;
        if (pluginManagerConfigurablePanel == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(4);
        }
        return pluginManagerConfigurablePanel;
    }

    @NotNull
    public static <T extends Component> T setTinyFont(@NotNull T component2) {
        if (component2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(5);
        }
        Object object = SystemInfo.isMac ? RelativeFont.TINY.install(component2) : component2;
        if (object == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(6);
        }
        return object;
    }

    @Messages.YesNoResult
    public static int showRestartDialog() {
        return PluginManagerConfigurable.showRestartDialog(PluginManagerConfigurable.getUpdatesDialogTitle());
    }

    @Messages.YesNoResult
    public static int showRestartDialog(@NlsContexts.DialogTitle @NotNull String title2) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(7);
        }
        return PluginManagerConfigurable.showRestartDialog(title2, PluginManagerConfigurable::getUpdatesDialogMessage);
    }

    @Messages.YesNoResult
    public static int showRestartDialog(@NlsContexts.DialogTitle @NotNull String title2, @NotNull Function<? super String, @Nls String> message) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(8);
        }
        if (message == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(9);
        }
        String action2 = IdeBundle.message((String)(ApplicationManager.getApplication().isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0]);
        return Messages.showYesNoDialog((String)message.apply(action2), (String)title2, (String)action2, (String)IdeBundle.message((String)"ide.notnow.action", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
    }

    public static void shutdownOrRestartApp() {
        PluginManagerConfigurable.shutdownOrRestartApp(PluginManagerConfigurable.getUpdatesDialogTitle());
    }

    public static void shutdownOrRestartApp(@NlsContexts.DialogTitle @NotNull String title2) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(10);
        }
        PluginManagerConfigurable.shutdownOrRestartAppAfterInstall(title2, PluginManagerConfigurable::getUpdatesDialogMessage);
    }

    static void shutdownOrRestartAppAfterInstall(@NlsContexts.DialogTitle @NotNull String title2, @NotNull Function<? super String, @Nls String> message) {
        if (title2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(11);
        }
        if (message == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(12);
        }
        if (PluginManagerConfigurable.showRestartDialog(title2, message) == 0) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    @NlsContexts.DialogTitle
    @NotNull
    static String getUpdatesDialogTitle() {
        String string = IdeBundle.message((String)"updates.dialog.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        if (string == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsContexts.DialogMessage
    @NotNull
    static String getUpdatesDialogMessage(@Nls @NotNull String action2) {
        if (action2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(14);
        }
        String string = IdeBundle.message((String)"ide.restart.required.message", (Object[])new Object[]{action2, ApplicationNamesInfo.getInstance().getFullProductName()});
        if (string == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Deprecated(since="2020.2", forRemoval=true)
    public static void showPluginConfigurable(@Nullable Project project2, IdeaPluginDescriptor ... descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(16);
        }
        PluginManagerConfigurable.showPluginConfigurable(project2, ContainerUtil.map((Object[])descriptors2, PluginDescriptor::getPluginId));
    }

    public static void showPluginConfigurable(@Nullable Project project2, @NotNull Collection<PluginId> pluginIds) {
        if (pluginIds == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(17);
        }
        PluginManagerConfigurable configurable = new PluginManagerConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> configurable.select(pluginIds));
    }

    @ApiStatus.Internal
    public static void showSuggestedPlugins(@Nullable Project project2, @Nullable FUSEventSource source) {
        PluginManagerConfigurable configurable = new PluginManagerConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> {
            configurable.setInstallSource(source);
            configurable.openMarketplaceTab("/suggested");
        });
    }

    public static void showPluginConfigurable(@Nullable Component parent, @Nullable Project project2, @NotNull Collection<PluginId> pluginIds) {
        if (pluginIds == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(18);
        }
        if (parent != null) {
            PluginManagerConfigurable configurable = new PluginManagerConfigurable();
            ShowSettingsUtil.getInstance().editConfigurable(parent, (Configurable)configurable, () -> configurable.select(pluginIds));
        } else {
            PluginManagerConfigurable.showPluginConfigurable(project2, pluginIds);
        }
    }

    public static void showPluginConfigurableAndEnable(@Nullable Project project2, @NotNull Set<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(19);
        }
        PluginManagerConfigurable configurable = new PluginManagerConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> configurable.selectAndEnable(descriptors2));
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }

    public void cancel() {
        if (this.myPanel != null) {
            this.myPanel.cancel();
        }
    }

    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    public void scheduleApply() {
        if (this.myPanel != null) {
            this.myPanel.scheduleApply();
        }
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return this.createPanelIfNeeded(option2).enableSearch(option2);
    }

    @Nullable
    public Runnable enableSearch(String option2, boolean ignoreTagMarketplaceTab) {
        return this.createPanelIfNeeded(option2).enableSearch(option2, ignoreTagMarketplaceTab);
    }

    public boolean isMarketplaceTabShowing() {
        return this.myPanel != null && this.myPanel.isMarketplaceTabShowing();
    }

    public boolean isInstalledTabShowing() {
        return this.myPanel != null && this.myPanel.isInstalledTabShowing();
    }

    public void openMarketplaceTab(@NotNull String option2) {
        if (option2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(20);
        }
        this.createPanelIfNeeded(option2).openMarketplaceTab(option2);
    }

    public void openInstalledTab(@NotNull String option2) {
        if (option2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(21);
        }
        this.createPanelIfNeeded(option2).openInstalledTab(option2);
    }

    private void setInstallSource(@Nullable FUSEventSource source) {
        this.createPanelIfNeeded().setInstallSource(source);
    }

    private void selectAndEnable(@NotNull Set<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(22);
        }
        this.createPanelIfNeeded().selectAndEnable(descriptors2);
    }

    private void select(@NotNull Collection<PluginId> pluginIds) {
        if (pluginIds == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(23);
        }
        this.createPanelIfNeeded().select(pluginIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanelIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setTinyFont";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatesDialogTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatesDialogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTinyFont";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showRestartDialog";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shutdownOrRestartApp";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shutdownOrRestartAppAfterInstall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatesDialogMessage";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showPluginConfigurable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showPluginConfigurableAndEnable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "openMarketplaceTab";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "openInstalledTab";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "selectAndEnable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 13, 15 -> new IllegalStateException(string);
        };
    }
}

