/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.ide.plugins.marketplace.PluginReviewComment;
import com.intellij.ide.plugins.marketplace.utils.MarketplaceUrls;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ReviewCommentComponent
extends JPanel {
    private final String myPluginId;
    private final String myCommendId;
    private final JComponent myMoreButton;
    private EventHandler.SelectionType myState;
    private boolean myShowPopup;

    public ReviewCommentComponent(@NotNull PluginReviewComment comment2) {
        int rating;
        if (comment2 == null) {
            ReviewCommentComponent.$$$reportNull$$$0(0);
        }
        this.myPluginId = comment2.getPlugin().getLink();
        this.myCommendId = comment2.getId();
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBorder((Border)JBUI.Borders.empty((int)6, (int)16));
        NonOpaquePanel topWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        topWrapper.setBorder((Border)JBUI.Borders.emptyBottom((int)7));
        this.add((Component)topWrapper, "North");
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)12))));
        topWrapper.add((Component)topPanel, "West");
        JLabel name2 = new JLabel(comment2.getAuthor().getName());
        name2.setForeground(ListPluginComponent.GRAY_COLOR);
        topPanel.add(name2);
        long dateValue = comment2.getDate();
        if (dateValue > 0L) {
            JLabel date = new JLabel(DateFormatUtil.formatPrettyDate((long)dateValue));
            date.setForeground(ListPluginComponent.GRAY_COLOR);
            topPanel.add(date);
        }
        if ((rating = comment2.getRating()) > 0) {
            RatesPanel panel2 = new RatesPanel();
            topPanel.add(panel2);
            panel2.setRate(Integer.toString(rating));
        }
        this.myMoreButton = this.createMoreAction();
        Wrapper moreWrapper = new Wrapper(this.myMoreButton);
        moreWrapper.setPreferredSize(moreWrapper.getPreferredSize());
        this.myMoreButton.setVisible(false);
        topWrapper.add((Component)moreWrapper, "East");
        JEditorPane editorPane2 = PluginDetailsPageComponent.createDescriptionComponent(null);
        this.add(editorPane2);
        if (editorPane2.getCaret() != null) {
            editorPane2.setCaretPosition(0);
        }
        editorPane2.setText(XmlStringUtil.wrapInHtml((CharSequence)comment2.getComment()));
        this.setState(EventHandler.SelectionType.NONE);
    }

    @NotNull
    private JComponent createMoreAction() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.getTemplatePresentation().setPopupGroup(true);
        group2.getTemplatePresentation().setIcon(AllIcons.Actions.More);
        group2.getTemplatePresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
        group2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"plugins.review.action.copy.link.text", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String url = MarketplaceUrls.getPluginManagerUrl() + "/" + ReviewCommentComponent.this.myPluginId + "/reviews#review=" + URLUtil.encodeURIComponent((String)ReviewCommentComponent.this.myCommendId);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(url));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/ReviewCommentComponent$1", "actionPerformed"));
            }
        });
        return new ActionButton((AnAction)group2, null, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            @NotNull
            protected JBPopup createAndShowActionGroupPopup(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent event) {
                if (actionGroup == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                ReviewCommentComponent.this.myShowPopup = true;
                JBPopup popup2 = super.createAndShowActionGroupPopup(actionGroup, event);
                popup2.addListener(new JBPopupListener(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ReviewCommentComponent.this.myShowPopup = false;
                        ApplicationManager.getApplication().invokeLater(() -> ReviewCommentComponent.this.myMoreButton.setVisible(ReviewCommentComponent.this.myState == EventHandler.SelectionType.HOVER));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/newui/ReviewCommentComponent$2$1", "onClosed"));
                    }
                });
                JBPopup jBPopup = popup2;
                if (jBPopup == null) {
                    2.$$$reportNull$$$0(2);
                }
                return jBPopup;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionGroup";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/newui/ReviewCommentComponent$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/newui/ReviewCommentComponent$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAndShowActionGroupPopup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAndShowActionGroupPopup";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public EventHandler.SelectionType getState() {
        EventHandler.SelectionType selectionType = this.myState;
        if (selectionType == null) {
            ReviewCommentComponent.$$$reportNull$$$0(1);
        }
        return selectionType;
    }

    public void setState(@NotNull EventHandler.SelectionType state2) {
        if (state2 == null) {
            ReviewCommentComponent.$$$reportNull$$$0(2);
        }
        if (state2 == EventHandler.SelectionType.NONE) {
            this.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        } else if (state2 == EventHandler.SelectionType.HOVER) {
            this.setBackground(ListPluginComponent.HOVER_COLOR);
        }
        this.myState = state2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/ReviewCommentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/ReviewCommentComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

