/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.ide.troubleshooting.Resolution;
import com.intellij.ide.troubleshooting.Scaling;
import com.intellij.ide.troubleshooting.ScreenInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"screenInfo", "Lcom/intellij/ide/troubleshooting/ScreenInfo;", "device", "Ljava/awt/GraphicsDevice;", "scale", "", "value", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class DisplayInfoKt {
    private static final ScreenInfo screenInfo(GraphicsDevice device) {
        float scale = JBUIScale.sysScale((GraphicsConfiguration)device.getDefaultConfiguration());
        DisplayMode displayMode = device.getDisplayMode();
        float resolutionScale = SystemInfo.isMac ? scale : 1.0f;
        Resolution resolution = new Resolution(DisplayInfoKt.scale(displayMode.getWidth(), resolutionScale), DisplayInfoKt.scale(displayMode.getHeight(), resolutionScale));
        Scaling scaling = new Scaling(scale);
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets insets = ScreenUtil.getScreenInsets((GraphicsConfiguration)device.getDefaultConfiguration());
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getScreenInsets(...)");
        Insets insets2 = insets;
        Intrinsics.checkNotNull((Object)bounds);
        return new ScreenInfo(resolution, scaling, bounds, insets2);
    }

    public static final int scale(int value, float scale) {
        return MathKt.roundToInt((float)((float)value * scale));
    }

    public static final /* synthetic */ ScreenInfo access$screenInfo(GraphicsDevice device) {
        return DisplayInfoKt.screenInfo(device);
    }
}

