/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.Disposable;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f2\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0007J<\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f2\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0007J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/ui/GradientTextureCache;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "texture", "Ljava/awt/TexturePaint;", "colorStart", "", "colorEnd", "x", "y", "getHorizontalTexture", "graphics", "Ljava/awt/Graphics2D;", "width", "Ljava/awt/Color;", "getVerticalTexture", "height", "checkValues", "", "cacheValues", "", "paint", "dispose", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class GradientTextureCache
implements Disposable {
    @Nullable
    private TexturePaint texture;
    private int colorStart;
    private int colorEnd;
    private int x;
    private int y;

    @RequiresEdt
    @NotNull
    public final TexturePaint getHorizontalTexture(@NotNull Graphics2D graphics, int width, @NotNull Color colorStart, @NotNull Color colorEnd, int x, int y) {
        TexturePaint texturePaint;
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)colorStart, (String)"colorStart");
        Intrinsics.checkNotNullParameter((Object)colorEnd, (String)"colorEnd");
        int realWidth = (int)Math.floor(JBUIScale.sysScale((Graphics2D)graphics) * (float)width);
        TexturePaint texturePaint2 = this.texture;
        if (!(texturePaint2 != null && (bufferedImage = texturePaint2.getImage()) != null ? realWidth == bufferedImage.getWidth() : false) || this.checkValues(colorStart, colorEnd, x, y)) {
            TexturePaint it = texturePaint2 = AppUIUtil.INSTANCE.createHorizontalGradientTexture(graphics, colorStart, colorEnd, width, x, y);
            boolean bl = false;
            this.cacheValues(it, colorStart, colorEnd, x, y);
            texturePaint = texturePaint2;
        } else {
            TexturePaint texturePaint3 = this.texture;
            texturePaint = texturePaint3;
            Intrinsics.checkNotNull((Object)texturePaint3);
        }
        return texturePaint;
    }

    public static /* synthetic */ TexturePaint getHorizontalTexture$default(GradientTextureCache gradientTextureCache, Graphics2D graphics2D, int n, Color color, Color color2, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        return gradientTextureCache.getHorizontalTexture(graphics2D, n, color, color2, n2, n3);
    }

    @RequiresEdt
    @NotNull
    public final TexturePaint getVerticalTexture(@NotNull Graphics2D graphics, int height, @NotNull Color colorStart, @NotNull Color colorEnd, int x, int y) {
        TexturePaint texturePaint;
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)colorStart, (String)"colorStart");
        Intrinsics.checkNotNullParameter((Object)colorEnd, (String)"colorEnd");
        int realHeight = (int)Math.floor(JBUIScale.sysScale((Graphics2D)graphics) * (float)height);
        TexturePaint texturePaint2 = this.texture;
        if (!(texturePaint2 != null && (bufferedImage = texturePaint2.getImage()) != null ? realHeight == bufferedImage.getHeight() : false) || this.checkValues(colorStart, colorEnd, x, y)) {
            TexturePaint it = texturePaint2 = AppUIUtil.INSTANCE.createVerticalGradientTexture(graphics, colorStart, colorEnd, height, x, y);
            boolean bl = false;
            this.cacheValues(it, colorStart, colorEnd, x, y);
            texturePaint = texturePaint2;
        } else {
            TexturePaint texturePaint3 = this.texture;
            texturePaint = texturePaint3;
            Intrinsics.checkNotNull((Object)texturePaint3);
        }
        return texturePaint;
    }

    public static /* synthetic */ TexturePaint getVerticalTexture$default(GradientTextureCache gradientTextureCache, Graphics2D graphics2D, int n, Color color, Color color2, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        return gradientTextureCache.getVerticalTexture(graphics2D, n, color, color2, n2, n3);
    }

    private final boolean checkValues(Color colorStart, Color colorEnd, int x, int y) {
        return colorStart.getRGB() != this.colorStart || colorEnd.getRGB() != this.colorEnd || x != this.x || y != this.y;
    }

    private final void cacheValues(TexturePaint paint, Color colorStart, Color colorEnd, int x, int y) {
        this.texture = paint;
        this.colorStart = colorStart.getRGB();
        this.colorEnd = colorEnd.getRGB();
        this.x = x;
        this.y = y;
    }

    public void dispose() {
        this.texture = null;
    }
}

