/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.util.PropertiesComponent;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"FIRST_PROMOTION_DATE_PROPERTY", "", "getNewUiPromotionDaysCount", "", "intellij.platform.ide.impl"})
public final class NewUiUtilKt {
    @NotNull
    private static final String FIRST_PROMOTION_DATE_PROPERTY = "experimental.ui.first.promotion.localdate";

    public static final long getNewUiPromotionDaysCount() {
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
        String value = propertyComponent.getValue(FIRST_PROMOTION_DATE_PROPERTY);
        LocalDate now = LocalDate.now();
        if (value == null) {
            propertyComponent.setValue(FIRST_PROMOTION_DATE_PROPERTY, now.toString());
            return 0L;
        }
        try {
            LocalDate firstDate = LocalDate.parse(value);
            return ChronoUnit.DAYS.between(firstDate, now);
        }
        catch (DateTimeParseException e) {
            propertyComponent.setValue(FIRST_PROMOTION_DATE_PROPERTY, now.toString());
            return 0L;
        }
    }
}

