/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.LookAndFeelThemeAdapter;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoImpl;
import com.intellij.idea.AppMode;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\b\u0010\u0012\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0015"}, d2={"initBaseLaF", "", "defaults", "Ljavax/swing/UIDefaults;", "patchFileChooserStrings", "patchComboBox", "initInputMapDefaults", "installCutCopyPasteShortcuts", "inputMap", "Ljavax/swing/InputMap;", "useSimpleActionKeys", "", "toFont", "Ljava/awt/Font;", "key", "", "createRawDarculaTheme", "Lcom/intellij/ide/ui/UITheme;", "setEarlyUiLaF", "createBaseLaF", "Ljavax/swing/LookAndFeel;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLookAndFeelThemeAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookAndFeelThemeAdapter.kt\ncom/intellij/ide/ui/laf/LookAndFeelThemeAdapterKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,330:1\n13#2:331\n*S KotlinDebug\n*F\n+ 1 LookAndFeelThemeAdapter.kt\ncom/intellij/ide/ui/laf/LookAndFeelThemeAdapterKt\n*L\n327#1:331\n*E\n"})
public final class LookAndFeelThemeAdapterKt {
    public static final void initBaseLaF(@NotNull UIDefaults defaults) {
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        LookAndFeelThemeAdapterKt.initInputMapDefaults(defaults);
        LookAndFeelThemeAdapterKt.patchComboBox(defaults);
        UIDefaults.LazyValue folderIcon = LookAndFeelThemeAdapterKt::initBaseLaF$lambda$0;
        defaults.put("Tree.openIcon", folderIcon);
        defaults.put("Tree.closedIcon", folderIcon);
        defaults.put("Tree.leafIcon", LookAndFeelThemeAdapterKt::initBaseLaF$lambda$1);
        defaults.put("Tree.expandedIcon", LookAndFeelThemeAdapterKt::initBaseLaF$lambda$2);
        defaults.put("Tree.collapsedIcon", LookAndFeelThemeAdapterKt::initBaseLaF$lambda$3);
        Object[] objectArray = new Object[]{"ctrl C", "copy", "meta C", "copy", "ctrl V", "paste", "meta V", "paste", "ctrl X", "cut", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "meta A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"};
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(objectArray));
        defaults.remove("Spinner.arrowButtonBorder");
        defaults.put("Spinner.arrowButtonSize", new JBDimension(16, 5).asUIResource());
        if (ClientSystemInfo.Companion.isMac()) {
            objectArray = new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release", "meta ENTER", "press", "meta released ENTER", "release"};
            defaults.put("RootPane.defaultButtonWindowKeyBindings", objectArray);
        }
        defaults.put("EditorPane.font", LookAndFeelThemeAdapterKt.toFont(defaults, "TextField.font"));
        LookAndFeelThemeAdapterKt.patchFileChooserStrings(defaults);
        defaults.put("Balloon.error.textInsets", new JBInsets(3, 8, 3, 8).asUIResource());
    }

    private static final void patchFileChooserStrings(UIDefaults defaults) {
        String[] stringArray = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
        String[] fileChooserTextKeys = stringArray;
        if (!defaults.containsKey(fileChooserTextKeys[0])) {
            for (String key : fileChooserTextKeys) {
                defaults.put(key, arg_0 -> LookAndFeelThemeAdapterKt.patchFileChooserStrings$lambda$0(key, arg_0));
            }
        }
    }

    private static final void patchComboBox(UIDefaults defaults) {
        UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    public static final void initInputMapDefaults(@NotNull UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap treeInputMap;
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        InputMap inputMap = treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        InputMap textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap");
        if (textAreaInputMap != null) {
            LookAndFeelThemeAdapterKt.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            LookAndFeelThemeAdapterKt.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            LookAndFeelThemeAdapterKt.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            LookAndFeelThemeAdapterKt.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    private static final void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 64), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 64), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 128), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "cut-to-clipboard");
    }

    private static final Font toFont(UIDefaults defaults, Object key) {
        Object value = defaults.get(key);
        if (value instanceof Font) {
            return (Font)value;
        }
        if (value instanceof UIDefaults.ActiveValue && (value = ((UIDefaults.ActiveValue)value).createValue(defaults)) instanceof Font) {
            return (Font)value;
        }
        throw new UnsupportedOperationException("Unable to extract Font from \"" + key + "\"");
    }

    @NotNull
    public static final UITheme createRawDarculaTheme() {
        ClassLoader classLoader = LookAndFeelThemeAdapter.class.getClassLoader();
        String filename = "themes/darcula.theme.json";
        byte[] byArray = ResourceUtil.getResourceAsBytes((String)filename, (ClassLoader)classLoader, (boolean)true);
        if (byArray == null) {
            throw new RuntimeException("Can't load " + filename);
        }
        byte[] data2 = byArray;
        Intrinsics.checkNotNull((Object)classLoader);
        UITheme theme = UITheme.Companion.loadDeprecatedFromJson$intellij_platform_ide_impl(data2, "Darcula", classLoader);
        return theme;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static final void setEarlyUiLaF() {
        UITheme theme = LookAndFeelThemeAdapterKt.createRawDarculaTheme();
        LookAndFeelThemeAdapter laf = new LookAndFeelThemeAdapter(LookAndFeelThemeAdapterKt.createBaseLaF(), new UIThemeLookAndFeelInfoImpl(theme));
        UIManager.setLookAndFeel(laf);
    }

    @ApiStatus.Internal
    @NotNull
    public static final LookAndFeel createBaseLaF() {
        if (SystemInfoRt.isMac) {
            if (AppMode.isRemoteDevHost()) {
                return new IdeaLaf(null);
            }
            Class<?> aClass = ClassLoader.getPlatformClassLoader().loadClass("com.apple.laf.AquaLookAndFeel");
            return MethodHandles.lookup().findConstructor(aClass, MethodType.methodType(Void.TYPE)).invoke();
        }
        if (!SystemInfoRt.isLinux || GraphicsEnvironment.isHeadless()) {
            return new IdeaLaf(null);
        }
        try {
            Class<?> aClass = ClassLoader.getPlatformClassLoader().loadClass("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            LookAndFeel gtk = MethodHandles.privateLookupIn(aClass, MethodHandles.lookup()).findConstructor(aClass, MethodType.methodType(Void.TYPE)).invoke();
            if (gtk.isSupportedLookAndFeel()) {
                gtk.initialize();
                HashMap fontDefaults = new HashMap();
                UIDefaults gtkDefaults = gtk.getDefaults();
                for (Object key : gtkDefaults.keySet()) {
                    if (!StringsKt.endsWith$default((String)key.toString(), (String)".font", (boolean)false, (int)2, null)) continue;
                    fontDefaults.put(key, gtkDefaults.get(key));
                }
                return new IdeaLaf(fontDefaults.isEmpty() ? null : fontDefaults);
            }
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(IdeaLaf.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn((Throwable)e);
        }
        return new IdeaLaf(null);
    }

    private static final Object initBaseLaF$lambda$0(UIDefaults it) {
        return AllIcons.Nodes.Folder;
    }

    private static final Object initBaseLaF$lambda$1(UIDefaults it) {
        return AllIcons.FileTypes.Any_type;
    }

    private static final Object initBaseLaF$lambda$2(UIDefaults it) {
        return AllIcons.Toolbar.Expand;
    }

    private static final Object initBaseLaF$lambda$3(UIDefaults it) {
        return AllIcons.Actions.ArrowExpand;
    }

    private static final Object patchFileChooserStrings$lambda$0(String $key, UIDefaults it) {
        return IdeBundle.message((String)$key, (Object[])new Object[0]);
    }

    public static final /* synthetic */ Font access$toFont(UIDefaults defaults, Object key) {
        return LookAndFeelThemeAdapterKt.toFont(defaults, key);
    }
}

