/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ui.laf.darcula.ui.ToolbarComboWidgetUiSizes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.DefaultCutStrategy;
import com.intellij.openapi.wm.impl.TextCutStrategy;
import com.intellij.openapi.wm.impl.ToolbarComboWidget;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.BadLocationException;
import javax.swing.text.View;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

@ApiStatus.Internal
public final class ToolbarComboWidgetUI
extends ComponentUI
implements PropertyChangeListener {
    private static final Icon EXPAND_ICON = AllIcons.General.ChevronDown;
    private static final int SEPARATOR_WIDTH = 1;
    private static final int SEPARATOR_HEIGHT = 20;
    private static final int DEFAULT_MAX_WIDTH = 350;
    private final HoverAreaTracker hoverTracker = new HoverAreaTracker();
    private final ClickListener clickListener = new ToolbarComboWidgetClickListener();
    private TextCutStrategy textCutStrategy = new DefaultCutStrategy();
    private int maxWidth = UIManager.getInt("MainToolbar.Dropdown.maxWidth");
    private int separatorPosition = 0;

    public ToolbarComboWidgetUI() {
        if (this.maxWidth == 0) {
            this.maxWidth = 350;
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new ToolbarComboWidgetUI();
    }

    @Override
    public void installUI(JComponent c) {
        ToolbarComboWidget widget2 = (ToolbarComboWidget)c;
        ToolbarComboWidgetUI.setUIDefaults(widget2);
        widget2.addPropertyChangeListener(this);
        ToolbarComboWidgetUI.tryUpdateHtmlRenderer(widget2, widget2.getText());
        this.hoverTracker.installTo(widget2);
        this.clickListener.installOn((Component)widget2);
    }

    @Override
    public void uninstallUI(JComponent c) {
        ToolbarComboWidget widget2 = (ToolbarComboWidget)c;
        widget2.removePropertyChangeListener(this);
        ToolbarComboWidgetUI.tryUpdateHtmlRenderer(widget2, "");
        this.hoverTracker.uninstall();
        this.clickListener.uninstall((Component)widget2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ToolbarComboWidget widget2;
        if (Objects.equals(evt.getPropertyName(), "text") || Objects.equals(evt.getPropertyName(), "font")) {
            widget2 = (ToolbarComboWidget)evt.getSource();
            ToolbarComboWidgetUI.tryUpdateHtmlRenderer(widget2, widget2.getText());
        }
        if ("pressListenersCount".equals(evt.getPropertyName())) {
            widget2 = (ToolbarComboWidget)evt.getSource();
            Insets insets = ToolbarComboWidgetUI.isSeparatorShown(widget2) ? JBUI.CurrentTheme.MainToolbar.SplitDropdown.borderInsets() : JBUI.CurrentTheme.MainToolbar.Dropdown.borderInsets();
            JBEmptyBorder border = JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
            widget2.setBorder((Border)border);
        }
    }

    private static void tryUpdateHtmlRenderer(ToolbarComboWidget widget2, String text2) {
        if (widget2.getFont() == null && BasicHTML.isHTMLString(text2)) {
            return;
        }
        BasicHTML.updateRenderer(widget2, text2);
    }

    private static void setUIDefaults(ToolbarComboWidget c) {
        c.setForeground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.foreground", (Color)JBColor.foreground()));
        c.setBackground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.background", (Color)JBColor.background()));
        c.setHoverBackground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.hoverBackground", (Color)JBColor.background()));
        c.setTransparentHoverBackground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.transparentHoverBackground", (Color)c.getHoverBackground()));
        Insets insets = JBUI.CurrentTheme.MainToolbar.Dropdown.borderInsets();
        EmptyBorder border = new EmptyBorder(insets);
        c.setBorder(border);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        ToolbarComboWidget combo2 = (ToolbarComboWidget)c;
        this.paintBackground(g, combo2);
        List<Icon> leftIcons = combo2.getLeftIcons();
        List<Icon> rightIcons = combo2.getRightIcons();
        Rectangle innerArea = SwingUtilities.calculateInnerArea(c, null);
        Graphics2D g2 = (Graphics2D)g.create(innerArea.x, innerArea.y, innerArea.width, innerArea.height);
        Rectangle paintRect = new Rectangle(0, 0, innerArea.width, innerArea.height);
        int maxTextWidth = ToolbarComboWidgetUI.calcMaxTextWidth(combo2, paintRect);
        try {
            String text2;
            GraphicsUtil.setupAAPainting((Graphics)g2);
            boolean skipNextGap = false;
            if (!leftIcons.isEmpty()) {
                Rectangle iconsRect = ToolbarComboWidgetUI.paintIcons(leftIcons, combo2, g2, paintRect, combo2.getLeftIconsGap());
                ToolbarComboWidgetUI.doClip(paintRect, iconsRect.width + ToolbarComboWidgetUiSizes.getGapAfterLeftIcons());
                skipNextGap = true;
            }
            if (!StringUtil.isEmpty((String)(text2 = ToolbarComboWidgetUI.getText(combo2))) && maxTextWidth > 0) {
                Rectangle textRect = new Rectangle(paintRect.x, paintRect.y, maxTextWidth, paintRect.height);
                this.drawText(c, text2, g2, textRect);
                ToolbarComboWidgetUI.doClip(paintRect, maxTextWidth);
                skipNextGap = false;
            }
            if (!rightIcons.isEmpty()) {
                if (!skipNextGap) {
                    ToolbarComboWidgetUI.doClip(paintRect, ToolbarComboWidgetUiSizes.getGapBeforeRightIcons());
                }
                Rectangle iconsRect = ToolbarComboWidgetUI.paintIcons(rightIcons, combo2, g2, paintRect, combo2.getRightIconsGap());
                ToolbarComboWidgetUI.doClip(paintRect, iconsRect.width);
                skipNextGap = false;
            }
            if (ToolbarComboWidgetUI.isSeparatorShown(combo2)) {
                ToolbarComboWidgetUI.doClip(paintRect, ToolbarComboWidgetUiSizes.getSeparatorGap());
                g2.setColor(c.isEnabled() ? UIManager.getColor("MainToolbar.separatorColor") : UIUtil.getLabelDisabledForeground());
                g2.fillRect(paintRect.x, (int)paintRect.getCenterY() - 10, 1, 20);
                this.separatorPosition = paintRect.x + combo2.getInsets().left;
                ToolbarComboWidgetUI.doClip(paintRect, 1 + ToolbarComboWidgetUiSizes.getSeparatorGap());
                skipNextGap = false;
            }
            if (combo2.isExpandable()) {
                if (!skipNextGap) {
                    ToolbarComboWidgetUI.doClip(paintRect, ToolbarComboWidgetUiSizes.getGapBeforeExpandIcon());
                }
                ToolbarComboWidgetUI.paintIcons(Collections.singletonList(EXPAND_ICON), combo2, g2, paintRect, 0);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        ToolbarComboWidget widget2 = (ToolbarComboWidget)c;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(c, c.getFontMetrics(c.getFont()), ToolbarComboWidgetUI.getText(widget2), null, 0, 0, 0, 0, new Rectangle(width, height), iconRect, textRect, 0);
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return textRect.y + fm.getAscent();
    }

    public void setTextCutStrategy(TextCutStrategy strategy) {
        this.textCutStrategy = strategy;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBackground(Graphics g, ToolbarComboWidget c) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        try {
            if (c.isOpaque()) {
                g2.setColor(c.getBackground());
                Rectangle bounds = g2.getClipBounds();
                g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            Color highlightBackground = c.getHighlightBackground();
            int arc = JBUI.CurrentTheme.MainToolbar.Dropdown.hoverArc().get();
            if (highlightBackground != null) {
                Rectangle highlightRect = c.getVisibleRect();
                g2.setColor(highlightBackground);
                g2.fillRoundRect(highlightRect.x, highlightRect.y, highlightRect.width, highlightRect.height, arc, arc);
            }
            if (c.isEnabled()) {
                Color hoverBackground;
                Rectangle hoverRect = this.hoverTracker.getHoverRect();
                Color color = hoverBackground = ProjectWindowCustomizerService.Companion.getInstance().isActive() ? c.getTransparentHoverBackground() : c.getHoverBackground();
                if (hoverRect != null && hoverBackground != null) {
                    g2.setColor(hoverBackground);
                    g2.fillRoundRect(hoverRect.x, hoverRect.y, hoverRect.width, hoverRect.height, arc, arc);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    private void drawText(JComponent c, @NotNull String fullText, Graphics2D g, Rectangle textBounds) {
        if (fullText == null) {
            ToolbarComboWidgetUI.$$$reportNull$$$0(0);
        }
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        g.setColor(c.isEnabled() ? c.getForeground() : UIUtil.getLabelDisabledForeground());
        int baseline = c.getBaseline(textBounds.width, textBounds.height);
        String text2 = this.textCutStrategy.calcShownText(fullText, metrics, textBounds.width, c);
        Rectangle strBounds = metrics.getStringBounds(text2, g).getBounds();
        strBounds.setLocation(Math.max(0, (int)(textBounds.getCenterX() - strBounds.getCenterX())), baseline);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            strBounds.y -= metrics.getAscent();
            v.paint(g, strBounds);
        } else {
            SwingUtilities2.drawString(c, (Graphics)g, text2, strBounds.x, strBounds.y);
        }
    }

    private static int calcMaxTextWidth(ToolbarComboWidget c, Rectangle paintRect) {
        int right;
        int left = ToolbarComboWidgetUI.calcIconsWidth(c.getLeftIcons(), c.getLeftIconsGap());
        if (left > 0) {
            left += ToolbarComboWidgetUiSizes.getGapAfterLeftIcons();
        }
        if ((right = ToolbarComboWidgetUI.calcIconsWidth(c.getRightIcons(), c.getRightIconsGap())) > 0) {
            right += ToolbarComboWidgetUiSizes.getGapBeforeRightIcons();
        }
        int separator = ToolbarComboWidgetUI.isSeparatorShown(c) ? 2 * ToolbarComboWidgetUiSizes.getSeparatorGap() + 1 : 0;
        int expandButton = c.isExpandable() ? ToolbarComboWidgetUiSizes.getGapBeforeExpandIcon() + EXPAND_ICON.getIconWidth() : 0;
        int otherElementsWidth = left + right + separator + expandButton;
        return paintRect.width - otherElementsWidth;
    }

    private static int calcIconsWidth(List<? extends Icon> icons, int gapBetweenIcons) {
        int res = 0;
        for (Icon icon2 : icons) {
            if (res > 0) {
                res += gapBetweenIcons;
            }
            res += icon2.getIconWidth();
        }
        return res;
    }

    private static void doClip(Rectangle bounds, int shift) {
        bounds.setBounds(bounds.x + shift, bounds.y, Math.max(bounds.width - shift, 0), bounds.height);
    }

    private static Rectangle paintIcons(List<? extends Icon> icons, JComponent c, Graphics g, Rectangle bounds, int gapBetweenIcons) {
        if (icons.isEmpty()) {
            return new Rectangle();
        }
        int maxHeight = 0;
        int shift = 0;
        for (Icon icon2 : icons) {
            if (shift != 0) {
                shift += gapBetweenIcons;
            }
            int x = bounds.x + shift;
            int y = bounds.y + bounds.height / 2 - icon2.getIconHeight() / 2;
            icon2.paintIcon(c, g, x, y);
            shift += icon2.getIconWidth();
            maxHeight = Math.max(maxHeight, icon2.getIconHeight());
        }
        return new Rectangle(shift, maxHeight);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        ToolbarComboWidget combo2 = (ToolbarComboWidget)c;
        Dimension res = new Dimension();
        List<Icon> icons = combo2.getLeftIcons();
        boolean skipNextGap = false;
        if (!icons.isEmpty()) {
            res.width += ToolbarComboWidgetUI.calcIconsWidth(icons, combo2.getLeftIconsGap()) + ToolbarComboWidgetUiSizes.getGapAfterLeftIcons();
            res.height = icons.stream().mapToInt(Icon::getIconHeight).max().orElse(0);
            skipNextGap = true;
        }
        if (!StringUtil.isEmpty((String)combo2.getText())) {
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            String text2 = ToolbarComboWidgetUI.getText(combo2);
            res.width += UIUtil.computeStringWidth((JComponent)c, (FontMetrics)metrics, (String)text2);
            res.height = Math.max(res.height, metrics.getHeight());
            skipNextGap = false;
        }
        if (!(icons = combo2.getRightIcons()).isEmpty()) {
            if (res.width > 0 && !skipNextGap) {
                res.width += ToolbarComboWidgetUiSizes.getGapBeforeRightIcons();
            }
            res.width += ToolbarComboWidgetUI.calcIconsWidth(icons, combo2.getRightIconsGap());
            res.height = Math.max(res.height, icons.stream().mapToInt(Icon::getIconHeight).max().orElse(0));
            skipNextGap = false;
        }
        if (ToolbarComboWidgetUI.isSeparatorShown(combo2)) {
            res.width += 2 * ToolbarComboWidgetUiSizes.getSeparatorGap() + 1;
            skipNextGap = false;
        }
        if (combo2.isExpandable()) {
            if (res.width > 0 && !skipNextGap) {
                res.width += ToolbarComboWidgetUiSizes.getGapBeforeExpandIcon();
            }
            res.width += EXPAND_ICON.getIconWidth();
            res.height = Math.max(res.height, EXPAND_ICON.getIconHeight());
        }
        Insets insets = c.getInsets();
        res.height += insets.top + insets.bottom;
        res.width += insets.left + insets.right;
        res.width = Integer.min(this.maxWidth, res.width);
        return res;
    }

    @Nls
    private static String getText(ToolbarComboWidget widget2) {
        View v = (View)widget2.getClientProperty("html");
        if (v != null) {
            try {
                @NlsSafe String text2 = v.getDocument().getText(0, v.getDocument().getLength()).strip();
                return text2;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return widget2.getText();
    }

    private static boolean isSeparatorShown(ToolbarComboWidget widget2) {
        return !widget2.getPressListeners().isEmpty() && widget2.isExpandable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullText", "com/intellij/ide/ui/laf/darcula/ui/ToolbarComboWidgetUI", "drawText"));
    }

    private final class HoverAreaTracker
    extends MyMouseTracker {
        private boolean mouseInside = false;
        private Rectangle hoverRect;

        private HoverAreaTracker() {
        }

        private Rectangle getHoverRect() {
            return this.hoverRect;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
            this.calcHoverRect(e.getPoint());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
            if (!this.comp.isPopupShowing()) {
                this.updateHoverRect(null);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.calcHoverRect(e.getPoint());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("isPopupShowing".equals(evt.getPropertyName())) {
                if (Objects.equals(evt.getNewValue(), true)) {
                    this.calcHoverRect(null);
                } else if (!this.mouseInside) {
                    this.updateHoverRect(null);
                }
            }
        }

        private void calcHoverRect(@Nullable Point mousePosition) {
            Rectangle compBounds = this.comp.getVisibleRect();
            if (!ToolbarComboWidgetUI.isSeparatorShown(this.comp)) {
                this.updateHoverRect(compBounds);
                return;
            }
            Rectangle left = new Rectangle(compBounds.x, compBounds.y, ToolbarComboWidgetUI.this.separatorPosition - ToolbarComboWidgetUiSizes.getSeparatorGap(), compBounds.height);
            Rectangle right = new Rectangle(ToolbarComboWidgetUI.this.separatorPosition + 1 + ToolbarComboWidgetUiSizes.getSeparatorGap(), compBounds.y, compBounds.width - ToolbarComboWidgetUI.this.separatorPosition - 1 - ToolbarComboWidgetUiSizes.getSeparatorGap(), compBounds.height);
            this.updateHoverRect(mousePosition == null || mousePosition.x <= ToolbarComboWidgetUI.this.separatorPosition ? left : right);
        }

        private void updateHoverRect(Rectangle newRect) {
            if (Objects.equals(this.hoverRect, newRect)) {
                return;
            }
            this.hoverRect = newRect;
            this.comp.repaint();
        }
    }

    private static final class ToolbarComboWidgetClickListener
    extends ClickListener {
        private ToolbarComboWidgetClickListener() {
        }

        private static void notifyPressListeners(MouseEvent e) {
            ToolbarComboWidget comp = (ToolbarComboWidget)e.getComponent();
            ActionEvent ae = new ActionEvent(comp, 0, null, System.currentTimeMillis(), e.getModifiersEx());
            comp.getPressListeners().forEach(listener2 -> listener2.actionPerformed(ae));
        }

        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            Component component2;
            if (e == null) {
                ToolbarComboWidgetClickListener.$$$reportNull$$$0(0);
            }
            if (!((component2 = e.getComponent()) instanceof ToolbarComboWidget)) {
                return false;
            }
            ToolbarComboWidget comp = (ToolbarComboWidget)component2;
            if (!comp.isEnabled()) {
                return false;
            }
            if (!comp.isExpandable()) {
                ToolbarComboWidgetClickListener.notifyPressListeners(e);
                return false;
            }
            if (!ToolbarComboWidgetUI.isSeparatorShown(comp)) {
                comp.doExpand(e);
                return true;
            }
            int leftPartWidth = comp.getWidth() - (ToolbarComboWidgetUiSizes.getGapBeforeExpandIcon() + EXPAND_ICON.getIconWidth() + comp.getInsets().right);
            if (e.getPoint().x <= leftPartWidth) {
                ToolbarComboWidgetClickListener.notifyPressListeners(e);
                return false;
            }
            comp.doExpand(e);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/laf/darcula/ui/ToolbarComboWidgetUI$ToolbarComboWidgetClickListener", "onClick"));
        }
    }

    private static abstract class MyMouseTracker
    extends MouseAdapter
    implements PropertyChangeListener {
        protected ToolbarComboWidget comp;

        private MyMouseTracker() {
        }

        public void installTo(ToolbarComboWidget c) {
            this.comp = c;
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
            c.addPropertyChangeListener(this);
        }

        public void uninstall() {
            this.comp.removeMouseListener(this);
            this.comp.removeMouseMotionListener(this);
            this.comp.removePropertyChangeListener(this);
            this.comp = null;
        }
    }
}

