/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.DebugAttachDetectorArgs;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.TimeUnit;

public final class DebugAttachDetector {
    private boolean myAttached;
    private boolean myReady;

    public DebugAttachDetector() {
        Application app = ApplicationManager.getApplication();
        if (!DebugAttachDetectorArgs.canDetectAttach() || !app.isInternal() || app.isUnitTestMode() || Boolean.getBoolean("disable.attach.detector") || PluginManagerCore.isRunningFromSources() || !DebugAttachDetector.isDebugEnabled()) {
            return;
        }
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            boolean attached = DebugAttachDetector.isAttached();
            if (!this.myReady) {
                this.myAttached = attached;
                this.myReady = true;
            } else if (attached != this.myAttached) {
                this.myAttached = attached;
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Remote debugger", this.myAttached ? "attached" : "detached", NotificationType.WARNING));
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public static boolean isDebugEnabled() {
        return DebugAttachDetectorArgs.isDebugEnabled();
    }

    public static boolean isAttached() {
        return DebugAttachDetectorArgs.isAttached();
    }
}

