/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginPathManager {
    private static ConcurrentMap<String, File> ourPluginHomes = new ConcurrentHashMap<String, File>();

    private PluginPathManager() {
    }

    public static File getPluginHome(@NonNls String pluginName) {
        File subRepo = ourPluginHomes.computeIfAbsent(pluginName, k -> {
            File repo = PluginPathManager.findSubRepo(k);
            return repo != null ? repo : new File(PathManager.getHomePath(), "plugins/" + k);
        });
        return subRepo;
    }

    private static File findSubRepo(String pluginName) {
        for (File subRepo : SubRepoHolder.subRepos) {
            File candidate = new File(subRepo, pluginName);
            if (!candidate.isDirectory()) continue;
            return candidate;
        }
        return null;
    }

    public static String getPluginHomePath(String pluginName) {
        return PluginPathManager.getPluginHome(pluginName).getPath();
    }

    public static String getPluginHomePathRelative(String pluginName) {
        File subRepo = PluginPathManager.findSubRepo(pluginName);
        if (subRepo != null) {
            String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
            return "/" + FileUtil.getRelativePath((String)homePath, (String)FileUtil.toSystemIndependentName((String)subRepo.getPath()), (char)'/');
        }
        return "/plugins/" + pluginName;
    }

    @Nullable
    public static File getPluginResource(@NotNull Class<?> pluginClass, @NotNull String resourceName) {
        Path result2;
        if (pluginClass == null) {
            PluginPathManager.$$$reportNull$$$0(0);
        }
        if (resourceName == null) {
            PluginPathManager.$$$reportNull$$$0(1);
        }
        if ((result2 = PluginManagerCoreKt.getPluginDistDirByClass(pluginClass)) != null) {
            return result2.resolve(resourceName).toFile();
        }
        try {
            String pathForClass = PathManager.getJarPathForClass(pluginClass);
            assert (pathForClass != null) : pluginClass;
            if (!pathForClass.endsWith(".jar")) {
                URL resource2 = pluginClass.getClassLoader().getResource(resourceName);
                if (resource2 == null) {
                    return null;
                }
                return new File(URLUtil.decode((String)resource2.getPath()));
            }
            File jarFile = new File(pathForClass);
            if (!jarFile.isFile()) {
                return null;
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, resourceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pluginClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resourceName";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/application/PluginPathManager";
        objectArray[2] = "getPluginResource";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SubRepoHolder {
        @NonNls
        private static final List<String> ROOT_NAMES = List.of("android", "community", "community/android", "contrib", "CIDR");
        private static final List<File> subRepos = SubRepoHolder.findSubRepos();

        private SubRepoHolder() {
        }

        private static List<File> findSubRepos() {
            File[] gitRoots;
            ArrayList<File> result2 = new ArrayList<File>();
            for (File subdir : gitRoots = SubRepoHolder.getSortedSubReposRoots(new File(PathManager.getHomePath()))) {
                File pluginsDir = new File(subdir, "plugins");
                if (pluginsDir.exists()) {
                    result2.add(pluginsDir);
                } else {
                    result2.add(subdir);
                }
                result2.addAll(Arrays.asList(SubRepoHolder.getSortedSubReposRoots(subdir)));
            }
            return result2;
        }

        private static File @NotNull [] getSortedSubReposRoots(@NotNull File dir) {
            if (dir == null) {
                SubRepoHolder.$$$reportNull$$$0(0);
            }
            HashSet<File> result2 = new HashSet<File>();
            for (String root : ROOT_NAMES) {
                File subRepo = new File(dir, root);
                if (!subRepo.isDirectory()) continue;
                result2.add(subRepo.toPath().normalize().toFile());
            }
            File[] gitRoots = result2.toArray(new File[0]);
            Arrays.sort(gitRoots, FileUtil::compareFiles);
            if (gitRoots == null) {
                SubRepoHolder.$$$reportNull$$$0(1);
            }
            return gitRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/PluginPathManager$SubRepoHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/PluginPathManager$SubRepoHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedSubReposRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortedSubReposRoots";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

