/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.util.SystemProperties;
import java.awt.datatransfer.DataFlavor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClipboardUtil {
    private static final Logger LOG = Logger.getInstance(ClipboardUtil.class);
    private static final int WAIT_TIMEOUT_ON_MAIN_THREAD_MS = SystemProperties.getIntProperty((String)"idea.clipboard.wait.timeout", (int)1000);

    public static <E> E handleClipboardSafely(@NotNull Supplier<? extends E> supplier, E defaultValue) {
        if (supplier == null) {
            ClipboardUtil.$$$reportNull$$$0(0);
        }
        ThrowableComputable task = () -> {
            try {
                return supplier.get();
            }
            catch (IllegalStateException e) {
                if (SystemInfo.isWindows) {
                    LOG.debug("Clipboard is busy");
                } else {
                    LOG.warn((Throwable)e);
                }
            }
            catch (NullPointerException e) {
                LOG.warn("Java bug #6322854", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Java bug #7173464", (Throwable)e);
            }
            return defaultValue;
        };
        return (E)(ApplicationManager.getApplication().isDispatchThread() ? (IdeEventQueue.getInstance().isDispatchingOnMainThread ? task.compute() : ClipboardUtil.waitOnEdtWithTimeout(task, defaultValue)) : DiskQueryRelay.compute(task));
    }

    private static <E> E waitOnEdtWithTimeout(@NotNull ThrowableComputable<E, RuntimeException> task, E defaultValue) {
        if (task == null) {
            ClipboardUtil.$$$reportNull$$$0(1);
        }
        try {
            return (E)ProcessIOExecutorService.INSTANCE.submit(() -> task.compute()).get(WAIT_TIMEOUT_ON_MAIN_THREAD_MS, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOG.warn(e.getCause());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    @Nullable
    public static String getTextInClipboard() {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ex/ClipboardUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleClipboardSafely";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "waitOnEdtWithTimeout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

