/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollPositionCalculator;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ScrollRequestListener;
import com.intellij.openapi.editor.impl.VisibleEditorsTracker;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.components.Interpolable;
import com.intellij.util.MathUtil;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Animations;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScrollingModelImpl
implements ScrollingModelEx {
    private static final Logger LOG = Logger.getInstance(ScrollingModelImpl.class);
    @NotNull
    private final ScrollingModel.Supplier supplier;
    private final List<VisibleAreaListener> visibleAreaListeners;
    private final List<ScrollRequestListener> scrollRequestListeners;
    private AnimatedScrollingRunnable currentAnimationRequest;
    private boolean animationDisabled;
    private int accumulatedXOffset;
    private int accumulatedYOffset;
    private boolean accumulateViewportChanges;
    private boolean viewportPositioned;
    private final DocumentListener documentListener;
    private final ChangeListener viewportChangeListener;

    @ApiStatus.Internal
    public ScrollingModelImpl(EditorImpl editor2) {
        this(new DefaultEditorSupplier(editor2));
    }

    @ApiStatus.Internal
    public ScrollingModelImpl(@NotNull ScrollingModel.Supplier supplier) {
        if (supplier == null) {
            ScrollingModelImpl.$$$reportNull$$$0(0);
        }
        this.visibleAreaListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.scrollRequestListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.accumulatedXOffset = -1;
        this.accumulatedYOffset = -1;
        this.documentListener = new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ScrollingModelImpl.this.supplier.getEditor().getDocument().isInBulkUpdate()) {
                    ScrollingModelImpl.this.cancelAnimatedScrolling(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/ScrollingModelImpl$1", "beforeDocumentChange"));
            }
        };
        this.viewportChangeListener = new MyChangeListener();
        this.supplier = supplier;
    }

    void initListeners() {
        this.supplier.getScrollPane().getViewport().addChangeListener(this.viewportChangeListener);
        this.supplier.getEditor().getDocument().addDocumentListener(this.documentListener);
    }

    private boolean adjustVerticalOffsetIfNecessary() {
        int currentOffset;
        Editor editor2 = this.supplier.getEditor();
        int maxY = Math.max(editor2.getLineHeight(), editor2.getDocument().getLineCount() * editor2.getLineHeight());
        int minPreferredY = maxY - this.getVisibleArea().height * 2 / 3;
        int offsetToUse = Math.min(minPreferredY, currentOffset = this.getVerticalScrollOffset());
        if (offsetToUse != currentOffset) {
            this.scroll(this.getHorizontalScrollOffset(), offsetToUse);
            return true;
        }
        return false;
    }

    @RequiresEdt
    @NotNull
    public Rectangle getVisibleArea() {
        ThreadingAssertions.assertEventDispatchThread();
        Rectangle rectangle = this.supplier.getScrollPane().getViewport().getViewRect();
        if (rectangle == null) {
            ScrollingModelImpl.$$$reportNull$$$0(1);
        }
        return rectangle;
    }

    @RequiresEdt
    @NotNull
    public Rectangle getVisibleAreaOnScrollingFinished() {
        ThreadingAssertions.assertEventDispatchThread();
        if (EditorCoreUtil.isTrueSmoothScrollingEnabled()) {
            Rectangle viewRect = this.supplier.getScrollPane().getViewport().getViewRect();
            return new Rectangle(ScrollingModelImpl.getOffset(this.getHorizontalScrollBar()), ScrollingModelImpl.getOffset(this.getVerticalScrollBar()), viewRect.width, viewRect.height);
        }
        if (this.currentAnimationRequest != null) {
            Rectangle rectangle = this.currentAnimationRequest.getTargetVisibleArea();
            if (rectangle == null) {
                ScrollingModelImpl.$$$reportNull$$$0(2);
            }
            return rectangle;
        }
        Rectangle rectangle = this.getVisibleArea();
        if (rectangle == null) {
            ScrollingModelImpl.$$$reportNull$$$0(3);
        }
        return rectangle;
    }

    @RequiresEdt
    public void scrollToCaret(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("scrollToCaret request: " + String.valueOf(scrollType)));
        }
        Editor editor2 = this.supplier.getEditor();
        AsyncEditorLoader.Companion.performWhenLoaded(editor2, (Runnable)((ContextAwareRunnable)() -> {
            VisualPosition visualPosition = editor2.getCaretModel().getVisualPosition();
            LogicalPosition logicalPosition = editor2.visualToLogicalPosition(visualPosition);
            for (ScrollRequestListener listener2 : this.scrollRequestListeners) {
                listener2.scrollRequested(logicalPosition, scrollType);
            }
            this.scrollTo(this.supplier.getScrollingHelper().calculateScrollingLocation(editor2, visualPosition), scrollType);
        }));
    }

    private void scrollTo(@NotNull Point targetLocation, @NotNull ScrollType scrollType) {
        AnimatedScrollingRunnable canceledThread;
        if (targetLocation == null) {
            ScrollingModelImpl.$$$reportNull$$$0(5);
        }
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(6);
        }
        Rectangle viewRect = (canceledThread = this.cancelAnimatedScrolling(false)) == null ? this.getVisibleArea() : canceledThread.getTargetVisibleArea();
        targetLocation = this.stickyPanelAdjust(targetLocation, viewRect);
        Point p = this.calcOffsetsToScroll(targetLocation, scrollType, viewRect);
        this.scroll(p.x, p.y);
    }

    @NotNull
    private Point stickyPanelAdjust(@NotNull Point targetLocation, @NotNull Rectangle viewRect) {
        EditorImpl editor2;
        int height;
        Editor editor3;
        if (targetLocation == null) {
            ScrollingModelImpl.$$$reportNull$$$0(7);
        }
        if (viewRect == null) {
            ScrollingModelImpl.$$$reportNull$$$0(8);
        }
        if ((editor3 = this.supplier.getEditor()) instanceof EditorImpl && (height = (editor2 = (EditorImpl)editor3).getStickyLinesPanelHeight()) > 0) {
            viewRect.height -= height;
            return new Point(targetLocation.x, targetLocation.y - height);
        }
        Point point = targetLocation;
        if (point == null) {
            ScrollingModelImpl.$$$reportNull$$$0(9);
        }
        return point;
    }

    @RequiresEdt
    public void scrollTo(@NotNull LogicalPosition logicalPosition, @NotNull ScrollType scrollType) {
        if (logicalPosition == null) {
            ScrollingModelImpl.$$$reportNull$$$0(10);
        }
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("scrollTo request: " + String.valueOf(scrollType) + " - " + String.valueOf(logicalPosition)));
        }
        Editor editor2 = this.supplier.getEditor();
        AsyncEditorLoader.Companion.performWhenLoaded(editor2, (Runnable)((ContextAwareRunnable)() -> {
            for (ScrollRequestListener listener2 : this.scrollRequestListeners) {
                listener2.scrollRequested(logicalPosition, scrollType);
            }
            this.scrollTo(this.supplier.getScrollingHelper().calculateScrollingLocation(editor2, logicalPosition), scrollType);
        }));
    }

    @RequiresEdt
    public void runActionOnScrollingFinished(@NotNull Runnable action2) {
        if (action2 == null) {
            ScrollingModelImpl.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.currentAnimationRequest != null) {
            this.currentAnimationRequest.addPostRunnable(action2);
            return;
        }
        action2.run();
    }

    @ApiStatus.Internal
    public boolean isAnimationEnabled() {
        return !this.animationDisabled;
    }

    public void disableAnimation() {
        this.animationDisabled = true;
    }

    public void enableAnimation() {
        this.animationDisabled = false;
    }

    @NotNull
    private Point calcOffsetsToScroll(@NotNull Point targetLocation, @NotNull ScrollType scrollType, @NotNull Rectangle viewRect) {
        if (targetLocation == null) {
            ScrollingModelImpl.$$$reportNull$$$0(13);
        }
        if (scrollType == null) {
            ScrollingModelImpl.$$$reportNull$$$0(14);
        }
        if (viewRect == null) {
            ScrollingModelImpl.$$$reportNull$$$0(15);
        }
        Point point = ((ScrollPositionCalculator)ApplicationManager.getApplication().getService(ScrollPositionCalculator.class)).calcOffsetsToScroll(this.supplier.getEditor(), targetLocation, scrollType, viewRect, this.supplier.getScrollPane());
        if (point == null) {
            ScrollingModelImpl.$$$reportNull$$$0(16);
        }
        return point;
    }

    @RequiresEdt
    @Nullable
    public JScrollBar getVerticalScrollBar() {
        ThreadingAssertions.assertEventDispatchThread();
        JScrollPane scrollPane = this.supplier.getScrollPane();
        return scrollPane.getVerticalScrollBar();
    }

    @ApiStatus.Internal
    @RequiresEdt
    @Nullable
    public JScrollBar getHorizontalScrollBar() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.supplier.getScrollPane().getHorizontalScrollBar();
    }

    public int getVerticalScrollOffset() {
        return ScrollingModelImpl.getOffset(this.getVerticalScrollBar());
    }

    public int getHorizontalScrollOffset() {
        return ScrollingModelImpl.getOffset(this.getHorizontalScrollBar());
    }

    private static int getOffset(JScrollBar scrollBar) {
        return scrollBar == null ? 0 : (scrollBar instanceof Interpolable ? ((Interpolable)scrollBar).getTargetValue() : scrollBar.getValue());
    }

    public void scrollVertically(int scrollOffset) {
        this.scroll(this.getHorizontalScrollOffset(), scrollOffset);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void _scrollVertically(int n) {
        void scrollOffset;
        ThreadingAssertions.assertEventDispatchThread();
        JScrollBar scrollbar = this.supplier.getScrollPane().getVerticalScrollBar();
        scrollbar.setValue((int)scrollOffset);
    }

    public void scrollHorizontally(int scrollOffset) {
        this.scroll(scrollOffset, this.getVerticalScrollOffset());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void _scrollHorizontally(int n) {
        void scrollOffset;
        ThreadingAssertions.assertEventDispatchThread();
        JScrollBar scrollbar = this.supplier.getScrollPane().getHorizontalScrollBar();
        scrollbar.setValue((int)scrollOffset);
    }

    public void scroll(int hOffset, int vOffset) {
        boolean useAnimation;
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("scroll to point: x:" + hOffset + ", y:" + vOffset));
        }
        if (this.accumulateViewportChanges) {
            this.accumulatedXOffset = hOffset;
            this.accumulatedYOffset = vOffset;
            return;
        }
        this.cancelAnimatedScrolling(false);
        Editor editor2 = this.supplier.getEditor();
        if (!editor2.getSettings().isAnimatedScrolling() || this.animationDisabled || RemoteDesktopService.isRemoteSession()) {
            useAnimation = false;
        } else if (!CommandProcessor.getInstance().isCommandInProgress()) {
            useAnimation = editor2.getComponent().isShowing();
        } else {
            VisibleEditorsTracker editorTracker = VisibleEditorsTracker.getInstance();
            useAnimation = editorTracker.wasEditorVisibleOnCommandStart(editor2);
        }
        this.cancelAnimatedScrolling(false);
        if (useAnimation) {
            int startHOffset = this.getHorizontalScrollOffset();
            int startVOffset = this.getVerticalScrollOffset();
            if (startHOffset == hOffset && startVOffset == vOffset) {
                return;
            }
            try {
                this.currentAnimationRequest = new AnimatedScrollingRunnable(startHOffset, startVOffset, hOffset, vOffset);
            }
            catch (NoAnimationRequiredException e) {
                this._scrollHorizontally(hOffset);
                this._scrollVertically(vOffset);
            }
        } else {
            this._scrollHorizontally(hOffset);
            this._scrollVertically(vOffset);
        }
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        if (listener2 == null) {
            ScrollingModelImpl.$$$reportNull$$$0(17);
        }
        this.visibleAreaListeners.add(listener2);
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        if (listener2 == null) {
            ScrollingModelImpl.$$$reportNull$$$0(18);
        }
        boolean success2 = this.visibleAreaListeners.remove(listener2);
        LOG.assertTrue(success2);
    }

    @ApiStatus.Internal
    public void finishAnimation() {
        this.cancelAnimatedScrolling(true);
    }

    @Nullable
    private AnimatedScrollingRunnable cancelAnimatedScrolling(boolean scrollToTarget) {
        AnimatedScrollingRunnable request = this.currentAnimationRequest;
        this.currentAnimationRequest = null;
        if (request != null) {
            request.cancel(scrollToTarget);
        }
        return request;
    }

    @ApiStatus.Internal
    public void dispose() {
        this.supplier.getEditor().getDocument().removeDocumentListener(this.documentListener);
        this.supplier.getScrollPane().getViewport().removeChangeListener(this.viewportChangeListener);
    }

    @ApiStatus.Internal
    public void beforeModalityStateChanged() {
        this.cancelAnimatedScrolling(true);
    }

    @ApiStatus.Internal
    public boolean isScrollingNow() {
        return this.currentAnimationRequest != null;
    }

    @Override
    public void accumulateViewportChanges() {
        this.accumulateViewportChanges = true;
    }

    @Override
    public void flushViewportChanges() {
        this.accumulateViewportChanges = false;
        if (this.accumulatedXOffset >= 0 && this.accumulatedYOffset >= 0) {
            this.scroll(this.accumulatedXOffset, this.accumulatedYOffset);
            this.accumulatedYOffset = -1;
            this.accumulatedXOffset = -1;
            this.cancelAnimatedScrolling(true);
        }
    }

    void onBulkDocumentUpdateStarted() {
        this.cancelAnimatedScrolling(true);
    }

    @ApiStatus.Internal
    public void addScrollRequestListener(ScrollRequestListener scrollRequestListener, Disposable parentDisposable) {
        this.scrollRequestListeners.add(scrollRequestListener);
        Disposer.register((Disposable)parentDisposable, () -> this.scrollRequestListeners.remove(scrollRequestListener));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 9, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ScrollingModelImpl";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollType";
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocation";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRect";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPosition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ScrollingModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleArea";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleAreaOnScrollingFinished";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "stickyPanelAdjust";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcOffsetsToScroll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCaret";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scrollTo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stickyPanelAdjust";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runActionOnScrollingFinished";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calcOffsetsToScroll";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addVisibleAreaListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeVisibleAreaListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 9, 16 -> new IllegalStateException(string);
        };
    }

    private static final class DefaultEditorSupplier
    implements ScrollingModel.Supplier {
        private final EditorEx myEditor;
        private final ScrollingModel.ScrollingHelper myScrollingHelper;

        private DefaultEditorSupplier(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                DefaultEditorSupplier.$$$reportNull$$$0(0);
            }
            this.myScrollingHelper = new ScrollingModel.ScrollingHelper(this){

                @NotNull
                public Point calculateScrollingLocation(@NotNull Editor editor2, @NotNull VisualPosition pos) {
                    if (editor2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pos == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    int prefixAdjustment = 0;
                    if (pos.column == 0 && editor2 instanceof EditorEx) {
                        EditorEx editorEx = (EditorEx)editor2;
                        prefixAdjustment = editorEx.getPrefixTextWidthInPixels();
                    }
                    Point res = editor2.visualPositionToXY(pos);
                    res.translate(-prefixAdjustment, 0);
                    Point point = res;
                    if (point == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return point;
                }

                @NotNull
                public Point calculateScrollingLocation(@NotNull Editor editor2, @NotNull LogicalPosition pos) {
                    if (editor2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (pos == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    int prefixAdjustment = 0;
                    if (pos.column == 0 && editor2 instanceof EditorEx) {
                        EditorEx editorEx = (EditorEx)editor2;
                        prefixAdjustment = editorEx.getPrefixTextWidthInPixels();
                    }
                    Point res = editor2.logicalPositionToXY(pos);
                    res.translate(-prefixAdjustment, 0);
                    Point point = res;
                    if (point == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return point;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 5 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "editor";
                            break;
                        }
                        case 1: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pos";
                            break;
                        }
                        case 2: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/editor/impl/ScrollingModelImpl$DefaultEditorSupplier$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/editor/impl/ScrollingModelImpl$DefaultEditorSupplier$1";
                            break;
                        }
                        case 2: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "calculateScrollingLocation";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "calculateScrollingLocation";
                            break;
                        }
                        case 2: 
                        case 5: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2, 5 -> new IllegalStateException(string);
                    };
                }
            };
            this.myEditor = editor2;
        }

        @NotNull
        public Editor getEditor() {
            EditorEx editorEx = this.myEditor;
            if (editorEx == null) {
                DefaultEditorSupplier.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @NotNull
        public JScrollPane getScrollPane() {
            JScrollPane jScrollPane = this.myEditor.getScrollPane();
            if (jScrollPane == null) {
                DefaultEditorSupplier.$$$reportNull$$$0(2);
            }
            return jScrollPane;
        }

        @NotNull
        public ScrollingModel.ScrollingHelper getScrollingHelper() {
            ScrollingModel.ScrollingHelper scrollingHelper = this.myScrollingHelper;
            if (scrollingHelper == null) {
                DefaultEditorSupplier.$$$reportNull$$$0(3);
            }
            return scrollingHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/ScrollingModelImpl$DefaultEditorSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/ScrollingModelImpl$DefaultEditorSupplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollPane";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollingHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @DirtyUI
    private final class MyChangeListener
    implements ChangeListener {
        private Rectangle myLastViewRect;

        private MyChangeListener() {
        }

        @Override
        @DirtyUI
        public void stateChanged(ChangeEvent event) {
            EditorThreading.run(() -> {
                Rectangle viewRect = ScrollingModelImpl.this.getVisibleArea();
                VisibleAreaEvent visibleAreaEvent = new VisibleAreaEvent(ScrollingModelImpl.this.supplier.getEditor(), this.myLastViewRect, viewRect);
                if (!ScrollingModelImpl.this.viewportPositioned && viewRect.height > 0) {
                    ScrollingModelImpl.this.viewportPositioned = true;
                    if (ScrollingModelImpl.this.adjustVerticalOffsetIfNecessary()) {
                        return;
                    }
                }
                this.myLastViewRect = viewRect;
                for (VisibleAreaListener listener2 : ScrollingModelImpl.this.visibleAreaListeners) {
                    listener2.visibleAreaChanged(visibleAreaEvent);
                }
            });
        }
    }

    private final class AnimatedScrollingRunnable {
        private final int myStartHOffset;
        private final int myStartVOffset;
        private final int myEndHOffset;
        private final int myEndVOffset;
        private final ArrayList<Runnable> myPostRunnables = new ArrayList();
        private final JBAnimator myAnimator;

        AnimatedScrollingRunnable(int startHOffset, int startVOffset, int endHOffset, int endVOffset) throws NoAnimationRequiredException {
            this.myStartHOffset = startHOffset;
            this.myStartVOffset = startVOffset;
            this.myEndHOffset = endHOffset;
            this.myEndVOffset = endVOffset;
            this.myAnimator = new JBAnimator().setPeriod(4).setName("Scrolling Model Animator");
            this.myAnimator.animate(new Animation[]{Animations.animation(fraction -> {
                int hOffset = (int)((double)this.myStartHOffset + (double)(this.myEndHOffset - this.myStartHOffset) * fraction + 0.5);
                int vOffset = (int)((double)this.myStartVOffset + (double)(this.myEndVOffset - this.myStartVOffset) * fraction + 0.5);
                ScrollingModelImpl.this._scrollHorizontally(hOffset);
                ScrollingModelImpl.this._scrollVertically(vOffset);
            }).setDuration(this.getScrollDuration()).setEasing(Easing.EASE_OUT).runWhenExpired(() -> this.finish(true))});
        }

        int getScrollDuration() {
            int defaultDuration = Registry.intValue((String)"idea.editor.smooth.scrolling.navigation.duration", (int)100);
            if (defaultDuration < 0) {
                return 0;
            }
            int HDist = Math.abs(this.myEndHOffset - this.myStartHOffset);
            int VDist = Math.abs(this.myEndVOffset - this.myStartVOffset);
            double totalDist = Math.hypot(HDist, VDist);
            int lineHeight = ScrollingModelImpl.this.supplier.getEditor().getLineHeight();
            double lineDist = totalDist / (double)lineHeight;
            double part = MathUtil.clamp((double)((lineDist - 1.0) / 10.0), (double)0.0, (double)1.0);
            return (int)Math.round(part * (double)defaultDuration);
        }

        @NotNull
        Rectangle getTargetVisibleArea() {
            Rectangle viewRect = ScrollingModelImpl.this.getVisibleArea();
            return new Rectangle(this.myEndHOffset, this.myEndVOffset, viewRect.width, viewRect.height);
        }

        /*
         * WARNING - void declaration
         */
        @RequiresEdt
        public void cancel(boolean bl) {
            void scrollToTarget;
            ThreadingAssertions.assertEventDispatchThread();
            this.finish((boolean)scrollToTarget);
        }

        void addPostRunnable(Runnable runnable2) {
            this.myPostRunnables.add(runnable2);
        }

        private void finish(boolean scrollToTarget) {
            if (scrollToTarget || !this.myPostRunnables.isEmpty()) {
                ScrollingModelImpl.this._scrollHorizontally(this.myEndHOffset);
                ScrollingModelImpl.this._scrollVertically(this.myEndVOffset);
            }
            Disposer.dispose((Disposable)this.myAnimator);
            if (ScrollingModelImpl.this.currentAnimationRequest == this) {
                ScrollingModelImpl.this.currentAnimationRequest = null;
            }
            this.executePostRunnables();
        }

        private void executePostRunnables() {
            for (Runnable runnable2 : this.myPostRunnables) {
                runnable2.run();
            }
        }
    }

    private static final class NoAnimationRequiredException
    extends Exception {
        private NoAnimationRequiredException() {
        }
    }
}

