/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004J\n\u0010\u001a\u001a\u00020\u001bH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/editor/impl/view/CaretSelection;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "start", "Lcom/intellij/openapi/editor/VisualPosition;", "end", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/editor/VisualPosition;Lcom/intellij/openapi/editor/VisualPosition;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getStart", "()Lcom/intellij/openapi/editor/VisualPosition;", "getEnd", "contains", "", "pos", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
final class CaretSelection {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final VisualPosition start;
    @NotNull
    private final VisualPosition end;

    public CaretSelection(@NotNull EditorImpl editor2, @NotNull VisualPosition start2, @NotNull VisualPosition end) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.editor = editor2;
        this.start = start2;
        this.end = end;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final VisualPosition getStart() {
        return this.start;
    }

    @NotNull
    public final VisualPosition getEnd() {
        return this.end;
    }

    public final boolean contains(double pos) {
        Pair pair = new Pair((Object)this.editor.visualPositionToPoint2D(this.start), (Object)this.editor.visualPositionToPoint2D(this.end));
        Object object = pair.component1();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
        Point2D startPos = (Point2D)object;
        Object object2 = pair.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
        Point2D endPos = (Point2D)object2;
        double d = startPos.getX() - 0.01;
        return pos <= endPos.getX() + 0.01 ? d <= pos : false;
    }

    @NotNull
    public final EditorImpl component1() {
        return this.editor;
    }

    @NotNull
    public final VisualPosition component2() {
        return this.start;
    }

    @NotNull
    public final VisualPosition component3() {
        return this.end;
    }

    @NotNull
    public final CaretSelection copy(@NotNull EditorImpl editor2, @NotNull VisualPosition start2, @NotNull VisualPosition end) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new CaretSelection(editor2, start2, end);
    }

    public static /* synthetic */ CaretSelection copy$default(CaretSelection caretSelection, EditorImpl editorImpl, VisualPosition visualPosition, VisualPosition visualPosition2, int n, Object object) {
        if ((n & 1) != 0) {
            editorImpl = caretSelection.editor;
        }
        if ((n & 2) != 0) {
            visualPosition = caretSelection.start;
        }
        if ((n & 4) != 0) {
            visualPosition2 = caretSelection.end;
        }
        return caretSelection.copy(editorImpl, visualPosition, visualPosition2);
    }

    @NotNull
    public String toString() {
        return "CaretSelection(editor=" + this.editor + ", start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result2 = this.editor.hashCode();
        result2 = result2 * 31 + this.start.hashCode();
        result2 = result2 * 31 + this.end.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CaretSelection)) {
            return false;
        }
        CaretSelection caretSelection = (CaretSelection)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)caretSelection.editor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)caretSelection.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)caretSelection.end);
    }
}

