/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.TextFragment;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SimpleTextFragment
extends TextFragment {
    private final char @NotNull [] myText;
    @NotNull
    private final Font myFont;
    private float @Nullable [] myCharAlignment;

    SimpleTextFragment(char @NotNull [] lineChars, int start2, int end, @NotNull FontInfo fontInfo, @Nullable EditorView view2) {
        if (fontInfo == null) {
            SimpleTextFragment.$$$reportNull$$$0(0);
        }
        if (lineChars == null) {
            SimpleTextFragment.$$$reportNull$$$0(1);
        }
        super(end - start2, view2);
        this.myCharAlignment = null;
        this.myText = Arrays.copyOfRange(lineChars, start2, end);
        this.myFont = fontInfo.getFont();
        float x = 0.0f;
        for (int i2 = 0; i2 < this.myText.length; ++i2) {
            Float newWidth;
            char codePoint = this.myText[i2];
            float charWidth = fontInfo.charWidth2D(codePoint);
            if (this.isGridCellAlignmentEnabled() && (newWidth = this.adjustedWidthOrNull(codePoint, charWidth)) != null) {
                if (this.myCharAlignment == null) {
                    this.myCharAlignment = new float[this.myText.length];
                }
                this.myCharAlignment[i2] = newWidth.floatValue() - charWidth;
                charWidth = newWidth.floatValue();
            }
            this.myCharPositions[i2] = x += charWidth;
        }
    }

    @Override
    boolean isRtl() {
        return false;
    }

    @Override
    int offsetToLogicalColumn(int offset) {
        return offset;
    }

    @Override
    public Consumer<Graphics2D> draw(float x, float y, int startColumn, int endColumn) {
        return g -> {
            g.setFont(this.myFont);
            int xAsInt = (int)x;
            int yAsInt = (int)y;
            if (this.myCharAlignment != null) {
                this.drawAligned((Graphics2D)g, this.myText, startColumn, endColumn - startColumn, x, y);
            } else if (x == (float)xAsInt && y == (float)yAsInt) {
                g.drawChars(this.myText, startColumn, endColumn - startColumn, xAsInt, yAsInt);
            } else {
                g.drawString(new String(this.myText, startColumn, endColumn - startColumn), x, y);
            }
        };
    }

    private void drawAligned(Graphics2D g, char[] text2, int start2, int length, float startX, float y) {
        assert (this.myCharAlignment != null);
        if (length == 0) {
            return;
        }
        int end = start2 + length;
        int i2 = start2;
        int j = start2;
        float firstCharPosition = start2 == 0 ? 0.0f : this.myCharPositions[start2 - 1];
        float x = startX;
        while (i2 < end) {
            while (j < end && this.myCharAlignment[j] == 0.0f) {
                ++j;
            }
            if (j > i2) {
                g.drawString(new String(text2, i2, j - i2), x, y);
                x = startX + (this.myCharPositions[j - 1] - firstCharPosition);
                i2 = j;
            }
            if (i2 >= end) continue;
            j = i2 + 1;
            g.drawString(new String(text2, i2, j - i2), x += this.myCharAlignment[i2] / 2.0f, y);
            x = startX + (this.myCharPositions[j - 1] - firstCharPosition);
            i2 = j;
        }
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.myCharPositions.length;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.myCharPositions.length;
    }

    @Override
    public int visualColumnToOffset(float startX, int column) {
        return column;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        float relX = x - startX;
        float prevPos = 0.0f;
        for (int i2 = 0; i2 < this.myCharPositions.length; ++i2) {
            float newPos = this.myCharPositions[i2];
            if (relX < (newPos + prevPos) / 2.0f) {
                return new int[]{i2, relX <= prevPos ? 0 : 1};
            }
            prevPos = newPos;
        }
        return new int[]{this.myCharPositions.length, relX <= this.myCharPositions[this.myCharPositions.length - 1] ? 0 : 1};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return startX + this.getX(column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fontInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lineChars";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/view/SimpleTextFragment";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

