/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class DefaultLineMarkerRenderer
implements LineMarkerRendererEx {
    private final TextAttributesKey myAttributesKey;
    private final int myThickness;
    private final int myDepth;
    private final LineMarkerRendererEx.Position myPosition;
    private final Color myColor;
    private final boolean myIsSticky;

    public DefaultLineMarkerRenderer(@NotNull TextAttributesKey myAttributesKey, int thickness) {
        if (myAttributesKey == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        this(myAttributesKey, thickness, 0, LineMarkerRendererEx.Position.RIGHT);
    }

    public DefaultLineMarkerRenderer(@NotNull TextAttributesKey attributesKey, int thickness, int depth, @NotNull LineMarkerRendererEx.Position position2) {
        if (attributesKey == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        if (position2 == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        this(attributesKey, thickness, depth, position2, false);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public DefaultLineMarkerRenderer(@NotNull TextAttributesKey attributesKey, int thickness, int depth, @NotNull LineMarkerRendererEx.Position position2, boolean isSticky) {
        if (attributesKey == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(3);
        }
        if (position2 == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(4);
        }
        this.myAttributesKey = attributesKey;
        this.myThickness = thickness;
        this.myDepth = depth;
        this.myPosition = position2;
        this.myIsSticky = isSticky;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(this.myAttributesKey);
        Color color = attributes.getBackgroundColor();
        Color color2 = color = color != null ? color : attributes.getForegroundColor();
        this.myColor = color != null ? (ColorUtil.isDark((Color)scheme.getDefaultBackground()) ? ColorUtil.shift((Color)color, (double)1.5) : color.darker()) : null;
    }

    public void paint(@NotNull Editor editor2, @NotNull Graphics g, @NotNull Rectangle r) {
        if (editor2 == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(5);
        }
        if (g == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(6);
        }
        if (r == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(7);
        }
        if (this.myColor == null || ExperimentalUI.isNewUI()) {
            return;
        }
        g.setColor(this.myColor);
        g.fillRect(r.x, r.y, this.myThickness, r.height);
        g.fillRect(r.x + this.myThickness, r.y, this.myDepth, this.myThickness);
        g.fillRect(r.x + this.myThickness, r.y + r.height - this.myThickness, this.myDepth, this.myThickness);
    }

    @NotNull
    public TextAttributesKey getAttributesKey() {
        TextAttributesKey textAttributesKey = this.myAttributesKey;
        if (textAttributesKey == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(8);
        }
        return textAttributesKey;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public int getThickness() {
        return this.myThickness;
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position2 = this.myPosition;
        if (position2 == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(9);
        }
        return position2;
    }

    public Color getColor() {
        return this.myColor;
    }

    @Override
    public boolean isSticky() {
        return this.myIsSticky;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myAttributesKey";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/DefaultLineMarkerRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/DefaultLineMarkerRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

