/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.fileChooser.FileChooserPanel;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.ui.UIBundle;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class GoToWslHomeAction
extends FileChooserAction
implements LightEditCompatible {
    GoToWslHomeAction() {
    }

    @Override
    protected void update(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        if (panel2 == null) {
            GoToWslHomeAction.$$$reportNull$$$0(0);
        }
        if (e == null) {
            GoToWslHomeAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser") && PathEnvironmentVariableUtil.isOnPath((String)"wsl.exe"));
    }

    @Override
    protected void actionPerformed(@NotNull FileChooserPanel panel2, @NotNull AnActionEvent e) {
        ArrayList<WSLDistribution> vms;
        if (panel2 == null) {
            GoToWslHomeAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            GoToWslHomeAction.$$$reportNull$$$0(3);
        }
        if ((vms = (ArrayList<WSLDistribution>)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<List<WSLDistribution>, RuntimeException>(this, e.getProject(), UIBundle.message((String)"file.chooser.wsl.enumerating", (Object[])new Object[0]), true){

            protected List<WSLDistribution> compute(@NotNull ProgressIndicator i2) {
                if (i2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (List)ProgressIndicatorUtils.awaitWithCheckCanceled(WslDistributionManager.getInstance().getInstalledDistributionsFuture(), (ProgressIndicator)i2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i", "com/intellij/openapi/fileChooser/actions/GoToWslHomeAction$1", "compute"));
            }
        })).isEmpty()) {
            Messages.showWarningDialog((Project)e.getProject(), (String)UIBundle.message((String)"file.chooser.wsl.missing.text", (Object[])new Object[0]), (String)UIBundle.message((String)"file.chooser.wsl.missing.title", (Object[])new Object[0]));
        } else if (vms.size() == 1) {
            GoToWslHomeAction.navigate((WSLDistribution)vms.get(0), e.getProject(), panel2);
        } else {
            vms = new ArrayList<WSLDistribution>(vms);
            vms.sort(Comparator.comparing(WSLDistribution::toString));
            JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(vms).setItemChosenCallback(vm -> GoToWslHomeAction.navigate(vm, e.getProject(), panel2)).createPopup();
            PopupUtil.showForActionButtonEvent((JBPopup)popup2, (AnActionEvent)e);
        }
    }

    private static void navigate(final WSLDistribution vm, Project project2, FileChooserPanel panel2) {
        Path home = (Path)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Path, RuntimeException>(project2, UIBundle.message((String)"file.chooser.wsl.resolving", (Object[])new Object[0]), false){

            protected Path compute(@NotNull ProgressIndicator i2) {
                String env;
                Path candidate;
                List homes;
                if (i2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((homes = NioFiles.list((Path)(candidate = vm.getUNCRootPath().resolve("home")))).size() == 1) {
                    candidate = (Path)homes.get(0);
                } else if (homes.size() > 1 && (env = vm.getUserHome()) != null && !env.isBlank()) {
                    candidate = vm.getUNCRootPath().resolve(env);
                }
                return candidate;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i", "com/intellij/openapi/fileChooser/actions/GoToWslHomeAction$2", "compute"));
            }
        });
        panel2.load(home);
    }

    @Override
    protected void update(@NotNull FileSystemTree fileChooser, @NotNull AnActionEvent e) {
        if (fileChooser == null) {
            GoToWslHomeAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            GoToWslHomeAction.$$$reportNull$$$0(5);
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    @Override
    protected void actionPerformed(@NotNull FileSystemTree fileChooser, @NotNull AnActionEvent e) {
        if (fileChooser == null) {
            GoToWslHomeAction.$$$reportNull$$$0(6);
        }
        if (e == null) {
            GoToWslHomeAction.$$$reportNull$$$0(7);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/actions/GoToWslHomeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

