/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorListRendererContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileTypeWithDescriptorRenderer<T>
extends SimpleListCellRenderer<T>
implements UiInspectorListRendererContextProvider {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    @NotNull
    private final ListModel<? extends T> myModel;
    private final Function<? super T, ? extends FileType> myConverter;
    @Nullable
    private Set<String> myDuplicateDescriptions;

    public FileTypeWithDescriptorRenderer(@NotNull ListModel<? extends T> model2, @NotNull Function<? super T, ? extends FileType> converter) {
        if (model2 == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(1);
        }
        this.myModel = model2;
        this.myConverter = converter;
        model2.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                FileTypeWithDescriptorRenderer.this.myDuplicateDescriptions = null;
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FileTypeWithDescriptorRenderer.this.myDuplicateDescriptions = null;
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FileTypeWithDescriptorRenderer.this.myDuplicateDescriptions = null;
            }
        });
    }

    public void customize(@NotNull JList<? extends T> list2, T t, int index, boolean selected, boolean hasFocus) {
        if (list2 == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(2);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        FileType value = this.myConverter.apply(t);
        Icon icon2 = value.getIcon();
        if (icon2 != null) {
            layeredIcon.setIcon(icon2, 1, (-icon2.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon2.getIconHeight()) / 2);
        }
        this.setIcon((Icon)layeredIcon);
        String description = value.getDescription();
        if (this.isDuplicated(description)) {
            this.setText(description + " (" + value.getName() + ")");
        } else {
            this.setText(description);
        }
    }

    private boolean isDuplicated(String description) {
        if (this.myDuplicateDescriptions == null) {
            this.myDuplicateDescriptions = new HashSet<String>();
            HashSet<String> filter2 = new HashSet<String>();
            for (int i2 = 0; i2 < this.myModel.getSize(); ++i2) {
                String s = this.myConverter.apply(this.myModel.getElementAt(i2)).getDescription();
                if (filter2.add(s)) continue;
                this.myDuplicateDescriptions.add(s);
            }
        }
        return this.myDuplicateDescriptions.contains(description);
    }

    @NotNull
    public List<PropertyBean> getUiInspectorContext(@NotNull JList<?> list2, @Nullable Object value, int index) {
        FileType fileType2;
        if (list2 == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(3);
        }
        if ((fileType2 = this.myConverter.apply(value)) == null) {
            List<PropertyBean> list3 = Collections.emptyList();
            if (list3 == null) {
                FileTypeWithDescriptorRenderer.$$$reportNull$$$0(4);
            }
            return list3;
        }
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        result2.add(new PropertyBean("FileType ID", (Object)fileType2.getName(), true));
        result2.add(new PropertyBean("FileType Class", (Object)UiInspectorUtil.getClassPresentation((Object)fileType2), true));
        ArrayList<PropertyBean> arrayList = result2;
        if (arrayList == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void resetDuplicates() {
        this.myDuplicateDescriptions = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeWithDescriptorRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeWithDescriptorRenderer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiInspectorContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUiInspectorContext";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

