/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.ConfigurablesListPanelKt;
import com.intellij.openapi.options.newEditor.ExternalUpdateRequest;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.LightColors;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public class ConfigurableEditor
extends AbstractEditor
implements AnActionListener,
AWTEventListener {
    private final MergingUpdateQueue queue;
    private final ConfigurableCardPanel myCardPanel;
    private final JLabel myErrorLabel;
    private final AbstractAction myApplyAction;
    private final AbstractAction myResetAction;
    private Configurable configurable;

    ConfigurableEditor(Disposable parent) {
        super(parent);
        this.queue = new MergingUpdateQueue("SettingsModification", 1000, false, (JComponent)this, (Disposable)this, (JComponent)this, Alarm.ThreadToUse.SWING_THREAD, this.coroutineScope);
        this.myCardPanel = new ConfigurableCardPanel(){

            @Override
            protected JComponent create(Configurable configurable) {
                JComponent content2 = super.create(configurable);
                return content2 != null ? content2 : ConfigurableEditor.this.createDefaultContent(configurable);
            }
        };
        this.myErrorLabel = new JLabel();
        this.myApplyAction = new AbstractAction(CommonBundle.getApplyButtonText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigurableEditor.this.apply();
            }
        };
        this.myResetAction = new AbstractAction(UIBundle.message((String)"configurable.reset.action.name", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigurableEditor.this.reset();
            }
        };
    }

    ConfigurableEditor(Disposable parent, Configurable configurable) {
        super(parent);
        this.queue = new MergingUpdateQueue("SettingsModification", 1000, false, (JComponent)this, (Disposable)this, (JComponent)this, Alarm.ThreadToUse.SWING_THREAD, this.coroutineScope);
        this.myCardPanel = new /* invalid duplicate definition of identical inner class */;
        this.myErrorLabel = new JLabel();
        this.myApplyAction = new /* invalid duplicate definition of identical inner class */;
        this.myResetAction = new /* invalid duplicate definition of identical inner class */;
        this.init(configurable, parent instanceof SettingsEditor);
    }

    protected void init(Configurable configurable, boolean enableError) {
        this.myApplyAction.setEnabled(false);
        this.myResetAction.putValue("ShortDescription", UIBundle.message((String)"configurable.reset.action.description", (Object[])new Object[0]));
        this.myResetAction.setEnabled(false);
        this.myErrorLabel.setOpaque(true);
        this.myErrorLabel.setEnabled(enableError);
        this.myErrorLabel.setVisible(false);
        this.myErrorLabel.setVerticalTextPosition(1);
        this.myErrorLabel.setBorder((Border)JBUI.Borders.empty((int)10, (int)15, (int)15, (int)15));
        this.myErrorLabel.setBackground(LightColors.RED);
        this.add("South", RelativeFont.HUGE.install((Component)this.myErrorLabel));
        this.add("Center", this.myCardPanel);
        Disposer.register((Disposable)this, (Disposable)this.myCardPanel);
        MessageBusConnection messageBus = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        messageBus.subscribe(AnActionListener.TOPIC, (Object)this);
        messageBus.subscribe(ExternalUpdateRequest.TOPIC, conf -> this.updateCurrent(conf, false));
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        if (configurable != null) {
            this.configurable = configurable;
            this.myCardPanel.select(configurable, true).doWhenDone(() -> this.postUpdateCurrent(configurable));
        }
        this.updateCurrent(configurable, false);
    }

    @Override
    protected void disposeOnce() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.myCardPanel.removeAll();
    }

    @Override
    protected String getHelpTopic() {
        return this.configurable == null ? null : this.configurable.getHelpTopic();
    }

    @Override
    protected Action getApplyAction() {
        return this.myApplyAction;
    }

    @Override
    protected Action getResetAction() {
        return this.myResetAction;
    }

    @Override
    protected boolean apply() {
        this.updateIfCurrent(this.configurable);
        return this.setError(ConfigurableEditor.apply(this.myApplyAction.isEnabled() ? this.configurable : null));
    }

    protected void reset() {
        if (this.configurable != null) {
            ConfigurableCardPanel.reset(this.configurable);
            this.updateCurrent(this.configurable, true);
            FeatureUsageUiEventsKt.getUiEventLogger().logResetConfigurable(this.configurable);
        }
    }

    @Override
    protected boolean cancel(AWTEvent source) {
        this.configurable.cancel();
        return super.cancel(source);
    }

    void openLink(Configurable configurable) {
        ShowSettingsUtil.getInstance().editConfigurable((Component)this, configurable);
    }

    public final void beforeEditorTyping(char ch, @NotNull DataContext context2) {
        if (context2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(0);
        }
    }

    public final void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(1);
        }
        if (event == null) {
            ConfigurableEditor.$$$reportNull$$$0(2);
        }
    }

    public final void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        if (action2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(3);
        }
        if (event == null) {
            ConfigurableEditor.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(5);
        }
        this.requestUpdate();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        if (this.configurable == null) {
            return null;
        }
        JComponent preferred = this.configurable.getPreferredFocusedComponent();
        return preferred == null ? UIUtil.getPreferredFocusedComponent((Container)this.getContent(this.configurable)) : preferred;
    }

    @Override
    public final void eventDispatched(AWTEvent event) {
        switch (event.getID()) {
            case 501: 
            case 502: 
            case 506: {
                MouseEvent me = (MouseEvent)event;
                if (!SwingUtilities.isDescendingFrom(me.getComponent(), this) && !this.isPopupOverEditor(me.getComponent())) break;
                this.requestUpdate();
                break;
            }
            case 401: 
            case 402: {
                KeyEvent ke = (KeyEvent)event;
                if (!SwingUtilities.isDescendingFrom(ke.getComponent(), this)) break;
                this.requestUpdate();
            }
        }
    }

    void requestUpdate() {
        final Configurable configurable = this.configurable;
        this.queue.queue(new Update(this){

            public void run() {
                ConfigurableEditor.this.updateIfCurrent(configurable);
            }

            public boolean isExpired() {
                return ConfigurableEditor.this.configurable != configurable;
            }
        });
    }

    private boolean isPopupOverEditor(Component component2) {
        Window editor2 = ComponentUtil.getWindow((Component)this);
        if (editor2 != null) {
            Window popup2 = ComponentUtil.getWindow((Component)component2);
            if (popup2 == editor2) {
                return true;
            }
            if (popup2 != null && editor2 == popup2.getParent()) {
                if (popup2 instanceof JDialog) {
                    JDialog dialog2 = (JDialog)popup2;
                    return Dialog.ModalityType.MODELESS == dialog2.getModalityType();
                }
                return popup2 instanceof JWindow;
            }
        }
        return false;
    }

    void updateCurrent(Configurable configurable, boolean reset) {
        boolean modified = configurable != null && configurable.isModified();
        this.myApplyAction.setEnabled(modified);
        this.myResetAction.setEnabled(modified);
        if (!modified && reset) {
            this.setError(null);
        }
    }

    void postUpdateCurrent(Configurable configurable) {
    }

    final void updateIfCurrent(Configurable configurable) {
        if (this.configurable == configurable) {
            this.updateCurrent(configurable, false);
        }
    }

    @NotNull
    final Promise<? super Object> select(Configurable configurable) {
        assert (!this.isDisposed) : "Already disposed";
        long startTime = System.currentTimeMillis();
        boolean loadedFromCache = this.myCardPanel.getValue(configurable, false) != null;
        ActionCallback callback = this.myCardPanel.select(configurable, false);
        callback.doWhenDone(() -> {
            if (this.configurable != configurable) {
                SpotlightPainter.Companion.allowScrolling(this);
            }
            this.configurable = configurable;
            this.updateCurrent(configurable, false);
            this.postUpdateCurrent(configurable);
            if (configurable != null) {
                FeatureUsageUiEventsKt.getUiEventLogger().logSelectConfigurable(configurable, loadedFromCache, System.currentTimeMillis() - startTime);
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)callback);
        if (promise == null) {
            ConfigurableEditor.$$$reportNull$$$0(6);
        }
        return promise;
    }

    final boolean setError(ConfigurationException exception) {
        if (exception == null) {
            this.myErrorLabel.setVisible(false);
            return true;
        }
        if (this.myErrorLabel.isEnabled()) {
            this.myErrorLabel.setText(HtmlChunk.body().children(new HtmlChunk[]{HtmlChunk.text((String)exception.getTitle()).wrapWith("strong"), HtmlChunk.text((String)":"), HtmlChunk.br(), exception.getMessageHtml()}).wrapWith("html").toString());
            this.myErrorLabel.setVisible(true);
        } else {
            Messages.showMessageDialog((Component)this, (String)exception.getMessage(), (String)exception.getTitle(), (Icon)Messages.getErrorIcon());
        }
        return false;
    }

    final JComponent getContent(Configurable configurable) {
        return (JComponent)this.myCardPanel.getValue(configurable, false);
    }

    final JComponent readContent(Configurable configurable) {
        return (JComponent)this.myCardPanel.getValue(configurable, true);
    }

    private JComponent createDefaultContent(Configurable configurable) {
        JPanel content2 = new JPanel(new BorderLayout());
        content2.setBorder((Border)JBUI.Borders.empty((int)11, (int)16, (int)16, (int)16));
        Configurable.Composite compositeGroup = (Configurable.Composite)ObjectUtils.tryCast((Object)configurable, Configurable.Composite.class);
        if (compositeGroup == null) {
            String description = IdeBundle.message((String)"label.select.configuration.element", (Object[])new Object[0]);
            content2.add("Center", new JLabel(description, 0));
            content2.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        } else {
            ConfigurableGroup configurableGroup = ConfigurableWrapper.cast(ConfigurableGroup.class, (UnnamedConfigurable)configurable);
            String description = configurableGroup != null ? configurableGroup.getDescription() : null;
            content2.add("Center", (Component)ConfigurablesListPanelKt.createConfigurablesListPanel(description, Arrays.asList(compositeGroup.getConfigurables()), this));
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)content2, (boolean)true);
        pane2.setHorizontalScrollBarPolicy(31);
        return pane2;
    }

    static ConfigurationException apply(Configurable configurable) {
        if (configurable != null) {
            try {
                configurable.apply();
                FeatureUsageUiEventsKt.getUiEventLogger().logApplyConfigurable(configurable);
            }
            catch (ConfigurationException exception) {
                return exception;
            }
        }
        return null;
    }

    @Nullable
    public Configurable getConfigurable() {
        return this.configurable;
    }

    void reload() {
        this.myCardPanel.removeAll();
        this.configurable = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/ConfigurableEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/ConfigurableEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeEditorTyping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "afterActionPerformed";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

