/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.InternalThreading;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.awt.SunToolkit;

@ApiStatus.Internal
public class EventStealer {
    private final LinkedBlockingQueue<InputEvent> myInputEvents;
    private final LinkedBlockingQueue<InvocationEvent> myInvocationEvents;
    private final LinkedBlockingQueue<Object> myPingQueue;
    @NotNull
    private final Consumer<? super InputEvent> myInputEventDispatcher;
    private static final Object PING = new Object();
    private static final Logger LOG = Logger.getInstance(EventStealer.class);

    EventStealer(@NotNull Disposable parent, @NotNull Consumer<? super InputEvent> inputConsumer) {
        if (parent == null) {
            EventStealer.$$$reportNull$$$0(0);
        }
        if (inputConsumer == null) {
            EventStealer.$$$reportNull$$$0(1);
        }
        this(parent, false, inputConsumer);
    }

    EventStealer(@NotNull Disposable parent, boolean installPingingQueue, @NotNull Consumer<? super InputEvent> inputConsumer) {
        if (parent == null) {
            EventStealer.$$$reportNull$$$0(2);
        }
        if (inputConsumer == null) {
            EventStealer.$$$reportNull$$$0(3);
        }
        this.myInputEvents = new LinkedBlockingQueue();
        this.myInvocationEvents = new LinkedBlockingQueue();
        this.myInputEventDispatcher = inputConsumer;
        IdeEventQueue.getInstance().addPostEventListener((Function1<? super AWTEvent, Boolean>)((Function1)event -> {
            if (event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                this.myInputEvents.offer(me);
                this.ping();
                return true;
            }
            if (event instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)event;
                if (event.getID() != 400) {
                    this.myInputEvents.offer(ke);
                    this.ping();
                    return true;
                }
            }
            if (event instanceof InvocationEvent) {
                InvocationEvent ie = (InvocationEvent)event;
                if (EventStealer.isUrgentInvocationEvent(event)) {
                    this.myInvocationEvents.offer(ie);
                    this.ping();
                    return true;
                }
            }
            return false;
        }), parent);
        this.myPingQueue = installPingingQueue ? new LinkedBlockingQueue(1) : null;
    }

    private void ping() {
        if (this.myPingQueue != null) {
            this.myPingQueue.offer(PING);
        }
    }

    public static boolean isUrgentInvocationEvent(AWTEvent event) {
        String eventString = event.toString();
        if (eventString.contains(",runnable=com.intellij.openapi.actionSystem.impl.ActionMenu$$Lambda") || eventString.contains(",runnable=com.intellij.platform.ide.menu.MacNativeActionMenuKt$$Lambda")) {
            return false;
        }
        return event instanceof InternalThreading.TransferredWriteActionEvent || eventString.contains(",runnable=sun.lwawt.macosx.LWCToolkit") || eventString.contains(",runnable=RunnableWithTransferredWriteAction") || eventString.contains(",runnable=DispatchTerminationEvent") || event.getClass().getName().equals("sun.awt.AWTThreading$TrackedInvocationEvent");
    }

    List<InputEvent> drainUndispatchedInputEvents() {
        ArrayList<InputEvent> result2 = new ArrayList<InputEvent>();
        this.myInputEvents.drainTo(result2);
        return result2;
    }

    void dispatchEvents(int timeoutMs) {
        SunToolkit.flushPendingEvents();
        try {
            while (true) {
                this.dispatchAllExistingEvents();
                InputEvent event = this.myInputEvents.poll(timeoutMs, TimeUnit.MILLISECONDS);
                if (event == null) {
                    return;
                }
                this.myInputEventDispatcher.accept(event);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void waitForPing(int timeoutMs) {
        if (this.myPingQueue == null) {
            LOG.error("Ping queue must be installed");
            return;
        }
        try {
            this.myPingQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    String dumpDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Input events: ");
        sb.append(this.myInputEvents.size());
        sb.append(" (");
        for (InputEvent inputEvent : this.myInputEvents) {
            sb.append(inputEvent.toString());
            sb.append(", ");
        }
        sb.append("); ");
        sb.append("Invocation events:");
        sb.append(this.myInvocationEvents.size());
        sb.append("(");
        for (InvocationEvent invocationEvent : this.myInvocationEvents) {
            sb.append(invocationEvent.toString());
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    void dispatchAllExistingEvents() {
        InvocationEvent event;
        while ((event = this.myInvocationEvents.poll()) != null) {
            event.dispatch();
        }
        return;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "inputConsumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/progress/util/EventStealer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

