/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.configuration;

import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.configuration.HeadlessLogging;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0012\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0002J-\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/project/configuration/ChannelingProgressIndicator;", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "prefix", "", "<init>", "(Ljava/lang/String;)V", "setIndeterminate", "", "indeterminate", "", "lastState", "Ljava/util/concurrent/atomic/AtomicReference;", "", "kotlin.jvm.PlatformType", "setFraction", "fraction", "setText", "text", "setText2", "trimProgressTextAndNullize", "s", "progressStateText", "details", "(Ljava/lang/Double;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "offerState", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nChannelingProgressIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelingProgressIndicator.kt\ncom/intellij/openapi/project/configuration/ChannelingProgressIndicator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class ChannelingProgressIndicator
extends ProgressIndicatorBase {
    @NotNull
    private final String prefix;
    @NotNull
    private final AtomicReference<Double> lastState;

    public ChannelingProgressIndicator(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.lastState = new AtomicReference<Double>(0.0);
    }

    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
    }

    public void setFraction(double fraction) {
        super.setFraction(fraction);
        Double lastStateValue = this.lastState.get();
        Intrinsics.checkNotNull((Object)lastStateValue);
        if (fraction - lastStateValue > 0.2 && this.lastState.compareAndSet(lastStateValue, fraction)) {
            this.offerState();
        }
    }

    public void setText(@Nullable String text2) {
        super.setText(text2);
        super.setText2("");
        this.offerState();
    }

    public void setText2(@Nullable String text2) {
        super.setText2(text2);
    }

    private final String trimProgressTextAndNullize(String s) {
        Object object;
        Object object2;
        String string = s;
        if (string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null && (string = StringsKt.trimEnd((String)string, (char[])(object2 = new char[]{'.', '\u2026', ' '}))) != null) {
            Object it = object2 = (Object)string;
            boolean bl = false;
            object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object2 : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String progressStateText(Double fraction, String text2, String details) {
        Object object;
        String string;
        String shortText;
        block7: {
            block6: {
                void it;
                String text3 = this.trimProgressTextAndNullize(text2);
                String text22 = this.trimProgressTextAndNullize(details);
                CharSequence charSequence = text3;
                if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)text22) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    return null;
                }
                String string2 = text3;
                if (string2 == null) {
                    string2 = "";
                }
                string = shortText = string2;
                object = text22;
                if (object == null) break block6;
                String string3 = object;
                String string4 = string;
                boolean bl = false;
                String string5 = " (" + (String)it + ")";
                string = string4;
                object = string5;
                if (string5 != null) break block7;
            }
            object = "";
        }
        String verboseText = string + (String)object;
        if (StringsKt.isBlank((CharSequence)shortText) || fraction == null) {
            return verboseText;
        }
        int v = (int)(100.0 * fraction);
        int total = 18;
        int completed = RangesKt.coerceIn((int)((int)((double)total * fraction)), (int)0, (int)total);
        String d = StringsKt.padEnd((String)StringsKt.repeat((CharSequence)".", (int)completed), (int)total, (char)' ');
        String verboseReport = StringsKt.padEnd$default((String)StringsKt.take((String)verboseText, (int)100), (int)105, (char)'\u0000', (int)2, null) + d + " " + v + "%";
        return verboseReport;
    }

    private final void offerState() {
        String string = this.progressStateText(this.isIndeterminate() ? null : Double.valueOf(this.getFraction()), this.getText(), this.getText2());
        if (string == null) {
            return;
        }
        String progressState = string;
        String actualPrefix = ((CharSequence)this.prefix).length() == 0 ? "" : "[" + this.prefix + "]: ";
        HeadlessLogging.INSTANCE.logMessage(actualPrefix + progressState);
    }
}

