/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.FrameWrapperKt;
import com.intellij.openapi.ui.MyJDialog;
import com.intellij.openapi.ui.MyJFrame;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WindowState;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.FullScreenSupport;
import com.intellij.ui.ToolbarService;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.ImageUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BK\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0003\u0010\t\u001a\u00020\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010*\u001a\u0004\u0018\u00010)H\u0005J\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010.\u001a\u00020,J\u0016\u0010/\u001a\u00020,2\f\u00100\u001a\b\u0012\u0004\u0012\u00020,01H\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u00102\u001a\u00020\bJ\u0006\u00103\u001a\u00020,J\b\u00104\u001a\u00020,H\u0016J\u0010\u00105\u001a\u00020,2\u0006\u0010\"\u001a\u000206H\u0002J\u0006\u00107\u001a\u00020#J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020>2\u0006\u0010;\u001a\u00020<H\u0014J\u0019\u0010?\u001a\u0004\u0018\u00010\u000b2\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0010\u00a2\u0006\u0002\bAJ\u0010\u0010B\u001a\u00020,2\u0006\u0010C\u001a\u00020DH\u0016J\u0006\u0010E\u001a\u00020,J\u0010\u0010F\u001a\u00020,2\b\u0010G\u001a\u0004\u0018\u00010\u001eJ\u0016\u0010H\u001a\u00020,2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dJ\u0010\u0010I\u001a\u00020,2\b\u0010%\u001a\u0004\u0018\u00010!J\u0012\u0010J\u001a\u00020,2\b\u0010K\u001a\u0004\u0018\u00010LH\u0014J\u000e\u0010M\u001a\u00020,2\u0006\u0010N\u001a\u00020OJ\u0010\u0010P\u001a\u00020,2\b\u0010Q\u001a\u0004\u0018\u00010RR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0011\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\f\u001a\u0004\u0018\u00010\r8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u0004\u0018\u00010)8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010'R\u0011\u00108\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010'\u00a8\u0006S"}, d2={"Lcom/intellij/openapi/ui/FrameWrapper;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/UiCompatibleDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "dimensionKey", "", "isDialog", "", "title", "component", "Ljavax/swing/JComponent;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ZLjava/lang/String;Ljavax/swing/JComponent;Lkotlinx/coroutines/CoroutineScope;)V", "getDimensionKey", "()Ljava/lang/String;", "getTitle", "setTitle", "(Ljava/lang/String;)V", "getComponent", "()Ljavax/swing/JComponent;", "setComponent", "(Ljavax/swing/JComponent;)V", "preferredFocusedComponent", "getPreferredFocusedComponent", "setPreferredFocusedComponent", "images", "", "Ljava/awt/Image;", "isCloseOnEsc", "onCloseHandler", "Ljava/util/function/BooleanSupplier;", "frame", "Ljava/awt/Window;", "isDisposing", "value", "isDisposed", "()Z", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "getStatusBar", "show", "", "isDockWindow", "createContents", "executeOnDispose", "task", "Lkotlin/Function0;", "restoreBounds", "close", "dispose", "addCloseOnEsc", "Ljavax/swing/RootPaneContainer;", "getFrame", "isActive", "createJFrame", "Ljavax/swing/JFrame;", "parent", "Lcom/intellij/openapi/wm/IdeFrame;", "createJDialog", "Ljavax/swing/JDialog;", "getNorthExtension", "key", "getNorthExtension$intellij_platform_ide_impl", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "closeOnEsc", "setImage", "image", "setImages", "setOnCloseHandler", "loadFrameState", "state", "Lcom/intellij/openapi/util/WindowState;", "setLocation", "location", "Ljava/awt/Point;", "setSize", "size", "Ljava/awt/Dimension;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFrameWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameWrapper.kt\ncom/intellij/openapi/ui/FrameWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1586#2:488\n1661#2,3:489\n1#3:492\n*S KotlinDebug\n*F\n+ 1 FrameWrapper.kt\ncom/intellij/openapi/ui/FrameWrapper\n*L\n157#1:488\n157#1:489,3\n*E\n"})
public class FrameWrapper
implements Disposable,
UiCompatibleDataProvider {
    @Nullable
    private final Project project;
    @Nullable
    private final String dimensionKey;
    private final boolean isDialog;
    @NotNull
    private String title;
    @Nullable
    private JComponent component;
    @JvmField
    @Nullable
    protected final CoroutineScope coroutineScope;
    @Nullable
    private JComponent preferredFocusedComponent;
    @NotNull
    private List<? extends Image> images;
    private boolean isCloseOnEsc;
    @Nullable
    private BooleanSupplier onCloseHandler;
    @Nullable
    private Window frame;
    @JvmField
    public boolean isDisposing;
    private boolean isDisposed;
    @JvmField
    @Nullable
    public StatusBar statusBar;

    @JvmOverloads
    public FrameWrapper(@Nullable Project project2, @NonNls @Nullable String dimensionKey, boolean isDialog, @NlsContexts.DialogTitle @NotNull String title2, @Nullable JComponent component2, @Nullable CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.project = project2;
        this.dimensionKey = dimensionKey;
        this.isDialog = isDialog;
        this.title = title2;
        this.component = component2;
        this.coroutineScope = coroutineScope;
        this.images = CollectionsKt.emptyList();
        if (this.project != null) {
            SimpleMessageBusConnection connection = this.coroutineScope == null ? (SimpleMessageBusConnection)ApplicationManager.getApplication().getMessageBus().connect((Disposable)this) : ApplicationManager.getApplication().getMessageBus().connect(this.coroutineScope);
            connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

                public void projectClosing(Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    if (project2 == project) {
                        this.close();
                    }
                }
            });
        }
    }

    public /* synthetic */ FrameWrapper(Project project2, String string, boolean bl, String string2, JComponent jComponent, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            jComponent = null;
        }
        if ((n & 0x20) != 0) {
            coroutineScope = null;
        }
        this(project2, string, bl, string2, jComponent, coroutineScope);
    }

    @Nullable
    protected String getDimensionKey() {
        return this.dimensionKey;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.title = string;
    }

    @Nullable
    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(@Nullable JComponent jComponent) {
        this.component = jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.preferredFocusedComponent;
    }

    public void setPreferredFocusedComponent(@Nullable JComponent jComponent) {
        this.preferredFocusedComponent = jComponent;
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    @ApiStatus.Obsolete
    @Nullable
    protected final StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void show() {
        this.show(true);
    }

    protected boolean isDockWindow() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void createContents() {
        JComponent it;
        Window frame = this.getFrame();
        if (frame instanceof JFrame) {
            ((JFrame)frame).setDefaultCloseOperation(0);
        } else {
            Intrinsics.checkNotNull((Object)frame, (String)"null cannot be cast to non-null type javax.swing.JDialog");
            ((JDialog)frame).setDefaultCloseOperation(0);
        }
        ComponentUtil.decorateWindowHeader((JRootPane)((RootPaneContainer)((Object)frame)).getRootPane());
        if (frame instanceof JFrame) {
            ToolbarService toolbarService = ToolbarService.Companion.getInstance();
            JRootPane jRootPane = ((JFrame)frame).getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
            toolbarService.setTransparentTitleBar(frame, jRootPane, FrameWrapper::createContents$lambda$0, arg_0 -> FrameWrapper.createContents$lambda$1(this, arg_0));
        }
        WindowAdapter windowListener2 = new WindowAdapter(this){
            final /* synthetic */ FrameWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowOpened(WindowEvent e) {
                block3: {
                    Component toFocus;
                    Component component2;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)FrameWrapper.access$getProject$p(this.this$0));
                    JComponent jComponent = this.this$0.getPreferredFocusedComponent();
                    if (jComponent != null) {
                        component2 = jComponent;
                    } else {
                        component2 = focusManager.getLastFocusedFor(e.getWindow());
                        if (component2 == null) {
                            JComponent jComponent2 = this.this$0.getComponent();
                            Intrinsics.checkNotNull((Object)jComponent2);
                            component2 = focusManager.getFocusTargetFor(jComponent2);
                        }
                    }
                    Component component3 = toFocus = component2;
                    if (component3 == null) break block3;
                    component3.requestFocusInWindow();
                }
            }

            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.close();
            }
        };
        frame.addWindowListener(windowListener2);
        this.executeOnDispose((Function0<Unit>)((Function0)() -> FrameWrapper.createContents$lambda$2(frame, windowListener2)));
        if (this.isCloseOnEsc) {
            this.addCloseOnEsc((RootPaneContainer)((Object)frame));
        }
        if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
            JComponent jComponent = this.getComponent();
            if (jComponent != null) {
                it = jComponent;
                boolean bl = false;
                this.setComponent(CustomFrameDialogContent.Companion.getCustomContentHolder(frame, it, this.isDockWindow()));
            }
        }
        Container container = ((RootPaneContainer)((Object)frame)).getContentPane();
        JComponent jComponent = this.getComponent();
        Intrinsics.checkNotNull((Object)jComponent);
        container.add((Component)jComponent, "Center");
        if (frame instanceof JFrame) {
            ((JFrame)frame).setTitle(this.title);
        } else {
            ((JDialog)frame).setTitle(this.title);
        }
        if (this.images.isEmpty()) {
            AppUIUtilKt.updateAppWindowIcon(frame);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.images;
            Window window = frame;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Image image2 = (Image)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ImageUtil.toBufferedImage((Image)it2));
            }
            window.setIconImages((List)destination$iv$iv);
        }
    }

    private final void executeOnDispose(Function0<Unit> task) {
        if (this.coroutineScope == null) {
            Disposer.register((Disposable)this, () -> FrameWrapper.executeOnDispose$lambda$0(task));
        } else {
            JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> FrameWrapper.executeOnDispose$lambda$1(task, arg_0));
        }
    }

    public final void show(boolean restoreBounds) {
        WindowState state2;
        this.createContents();
        Window frame = this.getFrame();
        String string = this.getDimensionKey();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = FrameWrapperKt.access$getWindowStateService(this.project).getState(it, frame);
        } else {
            v1 = state2 = null;
        }
        if (restoreBounds) {
            this.loadFrameState(state2);
        }
        if (SystemInfoRt.isMac) {
            TouchbarSupport.showWindowActions(this, frame);
        }
        frame.setVisible(true);
    }

    public final void close() {
        block4: {
            block3: {
                block2: {
                    if (this.isDisposed) break block2;
                    if (this.onCloseHandler == null) break block3;
                    BooleanSupplier booleanSupplier = this.onCloseHandler;
                    Intrinsics.checkNotNull((Object)booleanSupplier);
                    if (booleanSupplier.getAsBoolean()) break block3;
                }
                return;
            }
            Disposer.dispose((Disposable)this);
            Window window = this.frame;
            if (window == null) break block4;
            window.setVisible(false);
        }
    }

    public void dispose() {
        CoroutineScope coroutineScope = this.coroutineScope;
        if (coroutineScope != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
        }
        if (this.isDisposed) {
            return;
        }
        Window frame = this.frame;
        this.frame = null;
        this.setPreferredFocusedComponent(null);
        this.setComponent(null);
        this.images = CollectionsKt.emptyList();
        this.isDisposed = true;
        if (frame != null) {
            frame.setVisible(false);
            JRootPane rootPane = ((RootPaneContainer)((Object)frame)).getRootPane();
            ((Container)frame).removeAll();
            if (frame instanceof IdeFrame) {
                MouseGestureManager.getInstance().remove((IdeFrame)frame);
            }
            frame.dispose();
            DialogWrapper.cleanupRootPane((JRootPane)rootPane);
            DialogWrapper.cleanupWindowListeners((Window)frame);
        }
    }

    private final void addCloseOnEsc(RootPaneContainer frame) {
        JRootPane rootPane = frame.getRootPane();
        ActionListener closeAction = arg_0 -> FrameWrapper.addCloseOnEsc$lambda$0(this, arg_0);
        rootPane.registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 2);
        Intrinsics.checkNotNull((Object)rootPane);
        JComponent jComponent = rootPane;
        ShortcutSet shortcutSet = CommonShortcuts.getCloseActiveWindow();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getCloseActiveWindow(...)");
        ActionUtil.registerForEveryKeyboardShortcut((JComponent)jComponent, (ActionListener)closeAction, (ShortcutSet)shortcutSet);
    }

    @NotNull
    public final Window getFrame() {
        boolean bl;
        boolean bl2 = bl = !this.isDisposed;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FrameWrapper$getFrame$22 = false;
            String $i$a$-assert-FrameWrapper$getFrame$22 = "Already disposed!";
            throw new AssertionError((Object)$i$a$-assert-FrameWrapper$getFrame$22);
        }
        Window result2 = this.frame;
        if (result2 == null) {
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.project);
            Intrinsics.checkNotNull((Object)ideFrame);
            IdeFrame parent = ideFrame;
            this.frame = result2 = this.isDialog ? (Window)this.createJDialog(parent) : (Window)this.createJFrame(parent);
        }
        return result2;
    }

    public final boolean isActive() {
        Window window = this.frame;
        return window != null ? window.isActive() : false;
    }

    @NotNull
    protected JFrame createJFrame(@NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new MyJFrame(this, parent);
    }

    @NotNull
    protected JDialog createJDialog(@NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new MyJDialog(this, parent);
    }

    @Nullable
    public JComponent getNorthExtension$intellij_platform_ide_impl(@Nullable String key) {
        return null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    public final void closeOnEsc() {
        this.isCloseOnEsc = true;
    }

    public final void setImage(@Nullable Image image2) {
        this.setImages(CollectionsKt.listOfNotNull((Object)image2));
    }

    public final void setImages(@Nullable List<? extends Image> value) {
        List list2 = value;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.images = list2;
    }

    public final void setOnCloseHandler(@Nullable BooleanSupplier value) {
        this.onCloseHandler = value;
    }

    protected void loadFrameState(@Nullable WindowState state2) {
        Window frame = this.getFrame();
        if (state2 == null) {
            IdeFrame ideFrame = WindowManagerEx.getInstanceEx().getIdeFrame(this.project);
            if (ideFrame != null) {
                frame.setBounds(ideFrame.suggestChildFrameBounds());
            }
        } else {
            state2.applyTo(frame);
        }
        Intrinsics.checkNotNull((Object)frame, (String)"null cannot be cast to non-null type javax.swing.RootPaneContainer");
        ((RootPaneContainer)((Object)frame)).getRootPane().revalidate();
    }

    public final void setLocation(@NotNull Point location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.getFrame().setLocation(location);
    }

    public final void setSize(@Nullable Dimension size2) {
        this.getFrame().setSize(size2);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project2, @NonNls @Nullable String dimensionKey, boolean isDialog, @NlsContexts.DialogTitle @NotNull String title2, @Nullable JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this(project2, dimensionKey, isDialog, title2, component2, null, 32, null);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project2, @NonNls @Nullable String dimensionKey, boolean isDialog, @NlsContexts.DialogTitle @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this(project2, dimensionKey, isDialog, title2, null, null, 48, null);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project2, @NonNls @Nullable String dimensionKey, boolean isDialog) {
        this(project2, dimensionKey, isDialog, null, null, null, 56, null);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project2, @NonNls @Nullable String dimensionKey) {
        this(project2, dimensionKey, false, null, null, null, 60, null);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project2) {
        this(project2, null, false, null, null, null, 62, null);
    }

    private static final Unit createContents$lambda$1$0(Runnable $runnable) {
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final FullScreenSupport createContents$lambda$0() {
        Object r = FullScreenSupport.NEW.apply("com.intellij.ui.mac.MacFullScreenSupport");
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        return (FullScreenSupport)r;
    }

    private static final Unit createContents$lambda$1(FrameWrapper this$0, Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this$0.executeOnDispose((Function0<Unit>)((Function0)() -> FrameWrapper.createContents$lambda$1$0(runnable2)));
        return Unit.INSTANCE;
    }

    private static final Unit createContents$lambda$2(Window $frame, createContents.windowListener.1 $windowListener) {
        $frame.removeWindowListener($windowListener);
        return Unit.INSTANCE;
    }

    private static final void executeOnDispose$lambda$0(Function0 $task) {
        $task.invoke();
    }

    private static final Unit executeOnDispose$lambda$1(Function0 $task, Throwable it) {
        $task.invoke();
        return Unit.INSTANCE;
    }

    private static final void addCloseOnEsc$lambda$0(FrameWrapper this$0, ActionEvent it) {
        if (!PopupUtil.handleEscKeyEvent()) {
            this$0.close();
        }
    }
}

