/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import org.jetbrains.annotations.Nls;

public enum ChannelStatus {
    EAP("eap", "channel.status.eap"),
    MILESTONE("milestone", "channel.status.milestone"),
    BETA("beta", "channel.status.beta"),
    RELEASE("release", "channel.status.stable");

    private final String myCode;
    private final String myDisplayNameKey;

    private ChannelStatus(String code, String displayNameKey) {
        this.myCode = code;
        this.myDisplayNameKey = displayNameKey;
    }

    public static ChannelStatus fromCode(String code) {
        for (ChannelStatus type : ChannelStatus.values()) {
            if (!type.getCode().equalsIgnoreCase(code)) continue;
            return type;
        }
        return RELEASE;
    }

    public String getCode() {
        return this.myCode;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return IdeBundle.message((String)this.myDisplayNameKey, (Object[])new Object[0]);
    }

    public String toString() {
        return this.getDisplayName();
    }
}

