/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/updateSettings/impl/DetectedPluginsPanel;", "Lcom/intellij/ui/OrderPanel;", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myDetailsComponent", "Lcom/intellij/ide/plugins/newui/PluginDetailsPageComponent;", "myHeader", "Lcom/intellij/ide/plugins/PluginHeaderPanel;", "mySkippedPlugins", "Ljava/util/HashSet;", "Lcom/intellij/openapi/extensions/PluginId;", "Lkotlin/collections/HashSet;", "addAll", "", "orderEntries", "", "isChecked", "", "downloader", "setChecked", "checked", "requestFocus", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDetectedPluginsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetectedPluginsPanel.kt\ncom/intellij/openapi/updateSettings/impl/DetectedPluginsPanel\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,131:1\n42#2,3:132\n*S KotlinDebug\n*F\n+ 1 DetectedPluginsPanel.kt\ncom/intellij/openapi/updateSettings/impl/DetectedPluginsPanel\n*L\n78#1:132,3\n*E\n"})
public final class DetectedPluginsPanel
extends OrderPanel<PluginDownloader> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginDetailsPageComponent myDetailsComponent;
    @NotNull
    private final PluginHeaderPanel myHeader = new PluginHeaderPanel();
    @NotNull
    private final HashSet<PluginId> mySkippedPlugins = new HashSet();

    public DetectedPluginsPanel(@Nullable Project project2) {
        super(PluginDownloader.class);
        MyPluginModel pluginModel = new MyPluginModel(project2);
        pluginModel.setPluginUpdatesService(new PluginUpdatesService(){

            @Override
            public void finishUpdate() {
            }
        });
        this.myDetailsComponent = new PluginDetailsPageComponent(new PluginModelFacade(pluginModel), DetectedPluginsPanel::_init_$lambda$0, true, null, 8, null);
        JTable jTable = this.getEntryTable();
        Intrinsics.checkNotNullExpressionValue((Object)jTable, (String)"getEntryTable(...)");
        JTable entryTable = jTable;
        entryTable.setTableHeader(null);
        entryTable.setDefaultRenderer(PluginDownloader.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table2, Object value, boolean selected, boolean hasFocus, int row2, int column) {
                String version;
                String oldPluginName;
                IdeaPluginDescriptor installedPlugin;
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                this.setBorder(null);
                if (!(value instanceof PluginDownloader)) {
                    return;
                }
                String string = ((PluginDownloader)value).getPluginName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPluginName(...)");
                String pluginName = string;
                this.append(pluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                IdeaPluginDescriptor ideaPluginDescriptor = installedPlugin = PluginManagerCore.getPlugin((PluginId)((PluginDownloader)value).getId());
                String string2 = oldPluginName = ideaPluginDescriptor != null ? ideaPluginDescriptor.getName() : null;
                if (oldPluginName != null && !Comparing.strEqual((String)pluginName, (String)oldPluginName)) {
                    this.append(" - " + oldPluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                IdeaPluginDescriptor ideaPluginDescriptor2 = installedPlugin;
                String installedVersion = ideaPluginDescriptor2 != null ? ideaPluginDescriptor2.getVersion() : null;
                String availableVersion = ((PluginDownloader)value).getPluginVersion();
                if (installedVersion != null && availableVersion != null) {
                    String[] stringArray = new String[3];
                    stringArray[0] = installedVersion;
                    Intrinsics.checkNotNullExpressionValue((Object)UIUtil.rightArrow(), (String)"rightArrow(...)");
                    stringArray[2] = availableVersion;
                    v4 = StringUtil.join((String[])stringArray, (String)"");
                } else {
                    v4 = version = StringUtil.defaultIfEmpty((String)installedVersion, (String)availableVersion);
                }
                if (StringUtil.isNotEmpty((String)version)) {
                    this.append(" " + version, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                }
            }
        });
        entryTable.getSelectionModel().addListSelectionListener(arg_0 -> DetectedPluginsPanel._init_$lambda$1(entryTable, this, arg_0));
        this.removeAll();
        Splitter splitter2 = (Splitter)new OnePixelSplitter(false);
        splitter2.setFirstComponent(DetectedPluginsPanel.Companion.wrapWithPane(entryTable, 1, 1, 0, true));
        splitter2.setSecondComponent(DetectedPluginsPanel.Companion.wrapWithPane(this.myDetailsComponent, 0, 0, 1, false));
        splitter2.setProportion(0.3f);
        this.add((Component)splitter2, "Center");
    }

    public void addAll(@NotNull Collection<? extends PluginDownloader> orderEntries) {
        Intrinsics.checkNotNullParameter(orderEntries, (String)"orderEntries");
        super.addAll(orderEntries);
        TableUtil.ensureSelectionExists((JTable)this.getEntryTable());
    }

    public boolean isChecked(@NotNull PluginDownloader downloader) {
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        return !this.mySkippedPlugins.contains(downloader.getId());
    }

    public void setChecked(@NotNull PluginDownloader downloader, boolean checked) {
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        PluginId pluginId = downloader.getId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        PluginId pluginId2 = pluginId;
        boolean bl = checked ? this.mySkippedPlugins.remove(pluginId2) : this.mySkippedPlugins.add(pluginId2);
    }

    public void requestFocus() {
        this.getEntryTable().requestFocus();
    }

    private static final void _init_$lambda$0(LinkLabel linkLabel, Object object) {
    }

    private static final void _init_$lambda$1(JTable $entryTable, DetectedPluginsPanel this$0, ListSelectionEvent it) {
        boolean $i$f$service = false;
        Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CoroutineScope coroutineScope = ((CoreUiCoroutineScopeHolder)object).coroutineScope;
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($entryTable, this$0, null){
            int I$0;
            Object L$0;
            int label;
            final /* synthetic */ JTable $entryTable;
            final /* synthetic */ DetectedPluginsPanel this$0;
            {
                this.$entryTable = $entryTable;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        int selectedRow = this.$entryTable.getSelectedRow();
                        if (selectedRow == -1) return Unit.INSTANCE;
                        PluginDownloader pluginDownloader = DetectedPluginsPanel.access$getValueAt(this.this$0, selectedRow);
                        Intrinsics.checkNotNull((Object)pluginDownloader);
                        IdeaPluginDescriptor ideaPluginDescriptor = pluginDownloader.getDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"getDescriptor(...)");
                        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
                        DetectedPluginsPanel.access$getMyHeader$p(this.this$0).setPlugin(plugin);
                        DetectedPluginsPanel.access$getMyDetailsComponent$p(this.this$0).setOnlyUpdateMode();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)plugin);
                        this.I$0 = selectedRow;
                        this.label = 1;
                        Object object2 = DetectedPluginsPanel.access$getMyDetailsComponent$p(this.this$0).showPluginImpl(new PluginUiModelAdapter(plugin), null, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        int selectedRow = this.I$0;
                        IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static final /* synthetic */ PluginDownloader access$getValueAt(DetectedPluginsPanel $this, int p0) {
        return (PluginDownloader)$this.getValueAt(p0);
    }

    public static final /* synthetic */ PluginHeaderPanel access$getMyHeader$p(DetectedPluginsPanel $this) {
        return $this.myHeader;
    }

    public static final /* synthetic */ PluginDetailsPageComponent access$getMyDetailsComponent$p(DetectedPluginsPanel $this) {
        return $this.myDetailsComponent;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/updateSettings/impl/DetectedPluginsPanel$Companion;", "", "<init>", "()V", "wrapWithPane", "Ljavax/swing/JComponent;", "c", "top", "", "left", "right", "scrollPane", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final JComponent wrapWithPane(JComponent c, int top, int left, int right, boolean scrollPane) {
            JComponent c2 = c;
            if (scrollPane) {
                JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)c2);
                Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
                c2 = jScrollPane;
            }
            c2.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)top, (int)left, (int)1, (int)right));
            return c2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

