/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.monitoring;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.monitoring.VFSInitKind;
import com.intellij.openapi.vfs.newvfs.persistent.VFSInitException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class VfsUsageCollector
extends CounterUsagesCollector {
    private static final int DURATION_THRESHOLD_MS = 100;
    private static final EventLogGroup GROUP_VFS = new EventLogGroup("vfs", 19);
    private static final LongEventField FIELD_WAIT_MS = EventFields.Long((String)"wait_ms");
    private static final EventId1<Long> EVENT_INITIAL_REFRESH = GROUP_VFS.registerEvent("initial_refresh", (EventField)EventFields.DurationMs);
    private static final RoundedIntEventField FIELD_BG_REFRESH_SESSIONS = EventFields.RoundedInt((String)"sessions");
    private static final RoundedIntEventField FIELD_BG_REFRESH_EVENTS = EventFields.RoundedInt((String)"events");
    private static final EventId3<Long, Integer, Integer> EVENT_BACKGROUND_REFRESH = GROUP_VFS.registerEvent("background_refresh", (EventField)EventFields.DurationMs, (EventField)FIELD_BG_REFRESH_SESSIONS, (EventField)FIELD_BG_REFRESH_EVENTS);
    private static final BooleanEventField FIELD_REFRESH_RECURSIVE = EventFields.Boolean((String)"recursive");
    private static final RoundedIntEventField FIELD_REFRESH_LOCAL_ROOTS = EventFields.RoundedInt((String)"roots_local");
    private static final RoundedIntEventField FIELD_REFRESH_ARCHIVE_ROOTS = EventFields.RoundedInt((String)"roots_arc");
    private static final RoundedIntEventField FIELD_REFRESH_OTHER_ROOTS = EventFields.RoundedInt((String)"roots_other");
    private static final BooleanEventField FIELD_REFRESH_CANCELLED = EventFields.Boolean((String)"cancelled");
    private static final IntEventField FIELD_REFRESH_TRIES = EventFields.Int((String)"tries");
    private static final VarargEventId EVENT_REFRESH_SESSION = GROUP_VFS.registerVarargEvent("refresh_session", new EventField[]{FIELD_REFRESH_RECURSIVE, FIELD_REFRESH_LOCAL_ROOTS, FIELD_REFRESH_ARCHIVE_ROOTS, FIELD_REFRESH_OTHER_ROOTS, FIELD_REFRESH_CANCELLED, FIELD_WAIT_MS, EventFields.DurationMs, FIELD_REFRESH_TRIES});
    private static final IntEventField FIELD_REFRESH_FULL_SCANS = EventFields.Int((String)"full_scans");
    private static final IntEventField FIELD_REFRESH_PARTIAL_SCANS = EventFields.Int((String)"partial_scans");
    private static final IntEventField FIELD_REFRESH_RETRIES = EventFields.Int((String)"retries");
    private static final LongEventField FIELD_REFRESH_VFS_TIME_MS = EventFields.Long((String)"vfs_time_ms");
    private static final LongEventField FIELD_REFRESH_IO_TIME_MS = EventFields.Long((String)"io_time_ms");
    private static final VarargEventId EVENT_REFRESH_SCAN = GROUP_VFS.registerVarargEvent("refresh_scan", new EventField[]{FIELD_REFRESH_FULL_SCANS, FIELD_REFRESH_PARTIAL_SCANS, FIELD_REFRESH_RETRIES, EventFields.DurationMs, FIELD_REFRESH_VFS_TIME_MS, FIELD_REFRESH_IO_TIME_MS});
    private static final LongEventField FIELD_EVENT_LISTENERS_MS = EventFields.Long((String)"listeners_ms");
    private static final IntEventField FIELD_EVENT_TRIES = EventFields.Int((String)"tries");
    private static final IntEventField FIELD_EVENT_NUMBER = EventFields.Int((String)"events");
    private static final VarargEventId EVENT_EVENTS = GROUP_VFS.registerVarargEvent("events", new EventField[]{FIELD_WAIT_MS, FIELD_EVENT_LISTENERS_MS, FIELD_EVENT_TRIES, EventFields.DurationMs, FIELD_EVENT_NUMBER});
    private static final EnumEventField<VFSInitKind> FIELD_INITIALIZATION_KIND = EventFields.Enum((String)"init_kind", VFSInitKind.class);
    private static final IntEventField FIELD_INITIALIZATION_ATTEMPTS = EventFields.Int((String)"init_attempts");
    private static final LongEventField FIELD_CREATION_TIMESTAMP = EventFields.Long((String)"creation_timestamp");
    private static final IntEventField FIELD_IMPL_VERSION = EventFields.Int((String)"impl_version");
    private static final LongEventField FIELD_TOTAL_INIT_DURATION_MS = EventFields.Long((String)"init_duration_ms");
    private static final StringListEventField FIELD_ERRORS_HAPPENED = EventFields.StringList((String)"errors_happened", Stream.of(VFSInitException.ErrorCategory.values()).map(Enum::name).toList());
    private static final VarargEventId EVENT_VFS_INITIALIZATION = GROUP_VFS.registerVarargEvent("initialization", new EventField[]{FIELD_INITIALIZATION_KIND, FIELD_CREATION_TIMESTAMP, FIELD_INITIALIZATION_ATTEMPTS, FIELD_IMPL_VERSION, FIELD_TOTAL_INIT_DURATION_MS, FIELD_ERRORS_HAPPENED});
    private static final LongEventField FIELD_HEALTH_CHECK_VFS_CREATION_TIMESTAMP_MS = EventFields.Long((String)"vfs_creation_timestamp_ms");
    private static final LongEventField FIELD_HEALTH_CHECK_DURATION_MS = EventFields.Long((String)"check_duration_ms");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_CHECKED = EventFields.Int((String)"file_records_checked");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_DELETED = EventFields.Int((String)"file_records_deleted");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_NAME_NULL = EventFields.Int((String)"file_records_name_null");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_NAME_UNRESOLVABLE = EventFields.Int((String)"file_records_name_unresolvable");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_ATTRIBUTE_ID_UNRESOLVABLE = EventFields.Int((String)"file_records_attribute_unresolvable");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_CONTENT_NOT_NULL = EventFields.Int((String)"file_records_content_not_null");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_CONTENT_UNRESOLVABLE = EventFields.Int((String)"file_records_content_unresolvable");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_NULL_PARENTS = EventFields.Int((String)"file_records_null_parents");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_CHILDREN_CHECKED = EventFields.Int((String)"file_records_children_checked");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_CHILDREN_INCONSISTENT = EventFields.Int((String)"file_records_children_inconsistent");
    private static final IntEventField FIELD_HEALTH_CHECK_FILE_RECORDS_GENERAL_ERRORS = EventFields.Int((String)"file_records_general_errors");
    private static final IntEventField FIELD_HEALTH_CHECK_NAMES_CHECKED = EventFields.Int((String)"names_checked");
    private static final IntEventField FIELD_HEALTH_CHECK_NAMES_RESOLVED_TO_NULL = EventFields.Int((String)"names_resolved_to_null");
    private static final IntEventField FIELD_HEALTH_CHECK_NAMES_IDS_RESOLVED_TO_NULL = EventFields.Int((String)"names_ids_resolved_to_null");
    private static final IntEventField FIELD_HEALTH_CHECK_NAMES_INCONSISTENT_RESOLUTIONS = EventFields.Int((String)"names_inconsistent_resolution");
    private static final IntEventField FIELD_HEALTH_CHECK_NAMES_GENERAL_ERRORS = EventFields.Int((String)"names_general_errors");
    private static final IntEventField FIELD_HEALTH_CHECK_CONTENTS_CHECKED = EventFields.Int((String)"contents_checked");
    private static final IntEventField FIELD_HEALTH_CHECK_CONTENTS_ERRORS = EventFields.Int((String)"contents_errors");
    private static final IntEventField FIELD_HEALTH_CHECK_ROOTS_CHECKED = EventFields.Int((String)"roots_checked");
    private static final IntEventField FIELD_HEALTH_CHECK_ROOTS_WITH_PARENTS = EventFields.Int((String)"roots_with_parents");
    private static final IntEventField FIELD_HEALTH_CHECK_ROOTS_DELETED_BUT_NOT_REMOVED = EventFields.Int((String)"roots_deleted_but_not_removed");
    private static final IntEventField FIELD_HEALTH_CHECK_ROOTS_ERRORS = EventFields.Int((String)"roots_errors");
    private static final IntEventField FIELD_HEALTH_CHECK_ATTRIBUTES_ERRORS = EventFields.Int((String)"attributes_errors");
    private static final VarargEventId EVENT_VFS_HEALTH_CHECK = GROUP_VFS.registerVarargEvent("health_check", new EventField[]{FIELD_HEALTH_CHECK_VFS_CREATION_TIMESTAMP_MS, FIELD_HEALTH_CHECK_DURATION_MS, FIELD_HEALTH_CHECK_FILE_RECORDS_CHECKED, FIELD_HEALTH_CHECK_FILE_RECORDS_DELETED, FIELD_HEALTH_CHECK_FILE_RECORDS_NAME_NULL, FIELD_HEALTH_CHECK_FILE_RECORDS_NAME_UNRESOLVABLE, FIELD_HEALTH_CHECK_FILE_RECORDS_ATTRIBUTE_ID_UNRESOLVABLE, FIELD_HEALTH_CHECK_FILE_RECORDS_CONTENT_NOT_NULL, FIELD_HEALTH_CHECK_FILE_RECORDS_CONTENT_UNRESOLVABLE, FIELD_HEALTH_CHECK_FILE_RECORDS_NULL_PARENTS, FIELD_HEALTH_CHECK_FILE_RECORDS_CHILDREN_CHECKED, FIELD_HEALTH_CHECK_FILE_RECORDS_CHILDREN_INCONSISTENT, FIELD_HEALTH_CHECK_FILE_RECORDS_GENERAL_ERRORS, FIELD_HEALTH_CHECK_NAMES_CHECKED, FIELD_HEALTH_CHECK_NAMES_IDS_RESOLVED_TO_NULL, FIELD_HEALTH_CHECK_NAMES_RESOLVED_TO_NULL, FIELD_HEALTH_CHECK_NAMES_INCONSISTENT_RESOLUTIONS, FIELD_HEALTH_CHECK_NAMES_GENERAL_ERRORS, FIELD_HEALTH_CHECK_CONTENTS_CHECKED, FIELD_HEALTH_CHECK_CONTENTS_ERRORS, FIELD_HEALTH_CHECK_ROOTS_CHECKED, FIELD_HEALTH_CHECK_ROOTS_WITH_PARENTS, FIELD_HEALTH_CHECK_ROOTS_DELETED_BUT_NOT_REMOVED, FIELD_HEALTH_CHECK_ROOTS_ERRORS, FIELD_HEALTH_CHECK_ATTRIBUTES_ERRORS});
    private static final IntEventField FIELD_ACCUMULATED_VFS_ERRORS = EventFields.Int((String)"accumulated_errors");
    private static final LongEventField FIELD_TIME_SINCE_STARTUP = EventFields.Long((String)"time_since_startup_ms");
    private static final VarargEventId EVENT_VFS_INTERNAL_ERRORS = GROUP_VFS.registerVarargEvent("internal_errors", new EventField[]{FIELD_HEALTH_CHECK_VFS_CREATION_TIMESTAMP_MS, FIELD_TIME_SINCE_STARTUP, FIELD_ACCUMULATED_VFS_ERRORS});

    public EventLogGroup getGroup() {
        return GROUP_VFS;
    }

    public static void logInitialRefresh(Project project2, long duration2) {
        EVENT_INITIAL_REFRESH.log(project2, (Object)duration2);
    }

    public static void logBackgroundRefresh(long duration2, int sessions, int events) {
        if (duration2 > 100L) {
            EVENT_BACKGROUND_REFRESH.log((Object)duration2, (Object)sessions, (Object)events);
        }
    }

    public static void logRefreshSession(boolean recursive, int lfsRoots, int arcRoots, int otherRoots, boolean cancelled, long wait, long duration2, int tries) {
        if (duration2 >= 100L) {
            EVENT_REFRESH_SESSION.log(new EventPair[]{FIELD_REFRESH_RECURSIVE.with((Object)recursive), FIELD_REFRESH_LOCAL_ROOTS.with((Object)lfsRoots), FIELD_REFRESH_ARCHIVE_ROOTS.with((Object)arcRoots), FIELD_REFRESH_OTHER_ROOTS.with((Object)otherRoots), FIELD_REFRESH_CANCELLED.with((Object)cancelled), FIELD_WAIT_MS.with((Object)wait), EventFields.DurationMs.with((Object)duration2), FIELD_REFRESH_TRIES.with((Object)tries)});
        }
    }

    public static void logRefreshScan(int fullScans, int partialScans, int retries, long duration2, long vfsTime, long ioTime) {
        if (duration2 >= 100L) {
            EVENT_REFRESH_SCAN.log(new EventPair[]{FIELD_REFRESH_FULL_SCANS.with((Object)fullScans), FIELD_REFRESH_PARTIAL_SCANS.with((Object)partialScans), FIELD_REFRESH_RETRIES.with((Object)retries), EventFields.DurationMs.with((Object)duration2), FIELD_REFRESH_VFS_TIME_MS.with((Object)vfsTime), FIELD_REFRESH_IO_TIME_MS.with((Object)ioTime)});
        }
    }

    public static void logEventProcessing(long wait, long listenerTime, int listenerTries, long edtTime, int events) {
        if (listenerTime + edtTime >= 100L) {
            EVENT_EVENTS.log(new EventPair[]{FIELD_WAIT_MS.with((Object)wait), FIELD_EVENT_LISTENERS_MS.with((Object)listenerTime), FIELD_EVENT_TRIES.with((Object)listenerTries), EventFields.DurationMs.with((Object)edtTime), FIELD_EVENT_NUMBER.with((Object)events)});
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void logVfsInitialization(int vfsImplementationVersion, long vfsCreationTimestamp, @NotNull VFSInitKind initKind, @NotNull List<VFSInitException.ErrorCategory> errorsHappened, int initializationAttempts, long l) {
        void totalInitializationDurationMs;
        if (initKind == null) {
            VfsUsageCollector.$$$reportNull$$$0(0);
        }
        if (errorsHappened == null) {
            VfsUsageCollector.$$$reportNull$$$0(1);
        }
        EVENT_VFS_INITIALIZATION.log(new EventPair[]{FIELD_INITIALIZATION_KIND.with((Object)initKind), FIELD_CREATION_TIMESTAMP.with((Object)vfsCreationTimestamp), FIELD_INITIALIZATION_ATTEMPTS.with((Object)initializationAttempts), FIELD_IMPL_VERSION.with((Object)vfsImplementationVersion), FIELD_ERRORS_HAPPENED.with((Object)ContainerUtil.map(errorsHappened, Enum::name)), FIELD_TOTAL_INIT_DURATION_MS.with((Object)((long)totalInitializationDurationMs))});
    }

    public static void logVfsHealthCheck(long creationTimestampMs, long checkDurationMs, int fileRecordsChecked, int fileRecordsDeleted, int fileRecordsNameIdsNull, int fileRecordsNameIdsUnresolvable, int fileRecordsAttributeIdUnresolvable, int fileRecordsContentIdsNotNull, int fileRecordsContentIdsUnresolvable, int fileRecordsNullParents, int fileRecordsChildrenChecked, int fileRecordsInconsistentParentChildRelationships, int fileRecordsGeneralErrors, int namesChecked, int namesResolvedToNull, int namesIdsResolvedToNull, int namesInconsistentResolution, int namesGeneralErrors, int rootsChecked, int rootsWithParents, int rootsDeletedButNotRemoved, int rootsGeneralErrors, int contentRecordsChecked, int contentGeneralErrors) {
        EVENT_VFS_HEALTH_CHECK.log(new EventPair[]{FIELD_HEALTH_CHECK_VFS_CREATION_TIMESTAMP_MS.with((Object)creationTimestampMs), FIELD_HEALTH_CHECK_DURATION_MS.with((Object)checkDurationMs), FIELD_HEALTH_CHECK_FILE_RECORDS_CHECKED.with((Object)fileRecordsChecked), FIELD_HEALTH_CHECK_FILE_RECORDS_DELETED.with((Object)fileRecordsDeleted), FIELD_HEALTH_CHECK_FILE_RECORDS_NAME_NULL.with((Object)fileRecordsNameIdsNull), FIELD_HEALTH_CHECK_FILE_RECORDS_NAME_UNRESOLVABLE.with((Object)fileRecordsNameIdsUnresolvable), FIELD_HEALTH_CHECK_FILE_RECORDS_ATTRIBUTE_ID_UNRESOLVABLE.with((Object)fileRecordsAttributeIdUnresolvable), FIELD_HEALTH_CHECK_FILE_RECORDS_CONTENT_NOT_NULL.with((Object)fileRecordsContentIdsNotNull), FIELD_HEALTH_CHECK_FILE_RECORDS_CONTENT_UNRESOLVABLE.with((Object)fileRecordsContentIdsUnresolvable), FIELD_HEALTH_CHECK_FILE_RECORDS_NULL_PARENTS.with((Object)fileRecordsNullParents), FIELD_HEALTH_CHECK_FILE_RECORDS_CHILDREN_CHECKED.with((Object)fileRecordsChildrenChecked), FIELD_HEALTH_CHECK_FILE_RECORDS_CHILDREN_INCONSISTENT.with((Object)fileRecordsInconsistentParentChildRelationships), FIELD_HEALTH_CHECK_FILE_RECORDS_GENERAL_ERRORS.with((Object)fileRecordsGeneralErrors), FIELD_HEALTH_CHECK_NAMES_CHECKED.with((Object)namesChecked), FIELD_HEALTH_CHECK_NAMES_RESOLVED_TO_NULL.with((Object)namesResolvedToNull), FIELD_HEALTH_CHECK_NAMES_IDS_RESOLVED_TO_NULL.with((Object)namesIdsResolvedToNull), FIELD_HEALTH_CHECK_NAMES_INCONSISTENT_RESOLUTIONS.with((Object)namesInconsistentResolution), FIELD_HEALTH_CHECK_NAMES_GENERAL_ERRORS.with((Object)namesGeneralErrors), FIELD_HEALTH_CHECK_ROOTS_CHECKED.with((Object)rootsChecked), FIELD_HEALTH_CHECK_ROOTS_WITH_PARENTS.with((Object)rootsWithParents), FIELD_HEALTH_CHECK_ROOTS_DELETED_BUT_NOT_REMOVED.with((Object)rootsDeletedButNotRemoved), FIELD_HEALTH_CHECK_ROOTS_ERRORS.with((Object)rootsGeneralErrors), FIELD_HEALTH_CHECK_CONTENTS_CHECKED.with((Object)contentRecordsChecked), FIELD_HEALTH_CHECK_CONTENTS_ERRORS.with((Object)contentGeneralErrors)});
    }

    public static void logVfsInternalErrors(long vfsCreationTimestamp, long sinceStartupMs, int errorsAccumulatedSinceStartup) {
        EVENT_VFS_INTERNAL_ERRORS.log(new EventPair[]{FIELD_HEALTH_CHECK_VFS_CREATION_TIMESTAMP_MS.with((Object)vfsCreationTimestamp), FIELD_TIME_SINCE_STARTUP.with((Object)sinceStartupMs), FIELD_ACCUMULATED_VFS_ERRORS.with((Object)errorsAccumulatedSinceStartup)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "initKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "errorsHappened";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vfs/newvfs/monitoring/VfsUsageCollector";
        objectArray[2] = "logVfsInitialization";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

