/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ContentTooBigException;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DigestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PersistentFSContentAccessor {
    @NotNull
    private final PersistentFSConnection connection;

    PersistentFSContentAccessor(@NotNull PersistentFSConnection connection) {
        if (connection == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(0);
        }
        this.connection = connection;
    }

    @Nullable
    InputStream readContent(int fileId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(fileId);
        int contentId = this.connection.records().getContentRecordId(fileId);
        if (contentId == 0) {
            return null;
        }
        return this.readContentByContentId(contentId);
    }

    @NotNull
    InputStream readContentByContentId(int contentId) throws IOException {
        InputStream inputStream = this.connection.contents().readStream(contentId);
        if (inputStream == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(1);
        }
        return inputStream;
    }

    void writeContent(int fileId, @NotNull ByteArraySequence content2, boolean fixedSizeHint) throws IOException {
        if (content2 == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(2);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        PersistentFSRecordsStorage records = this.connection.records();
        int contentRecordId = this.writeContentRecord(content2);
        records.setContentRecordId(fileId, contentRecordId);
    }

    int writeContentRecord(@NotNull ByteArraySequence content2) throws IOException, ContentTooBigException {
        if (content2 == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(3);
        }
        return this.connection.contents().storeRecord(content2);
    }

    @ApiStatus.Obsolete
    byte @Nullable [] getContentHash(int fileId) throws IOException {
        int contentId = this.connection.records().getContentRecordId(fileId);
        if (contentId <= 0) {
            return null;
        }
        return this.connection.contents().contentHash(contentId);
    }

    @NotNull
    private static MessageDigest contentHashDigest() {
        MessageDigest messageDigest = DigestUtil.sha1();
        if (messageDigest == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(4);
        }
        return messageDigest;
    }

    public static byte @NotNull [] calculateHash(@NotNull ByteArraySequence bytes) {
        if (bytes == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(5);
        }
        return PersistentFSContentAccessor.calculateHash(bytes.getInternalBuffer(), bytes.getOffset(), bytes.length());
    }

    public static byte @NotNull [] calculateHash(byte[] bytes, int offset, int length) {
        MessageDigest digest = PersistentFSContentAccessor.contentHashDigest();
        digest.update(String.valueOf(length).getBytes(StandardCharsets.UTF_8));
        digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
        digest.update(bytes, offset, length);
        byte[] byArray = digest.digest();
        if (byArray == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    int acquireContentRecord(int fileId) throws IOException {
        return this.connection.records().getContentRecordId(fileId);
    }

    void deleteContent(int fileId) {
    }

    void releaseContentRecord(int contentRecordId) throws IOException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSContentAccessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSContentAccessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentByContentId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "contentHashDigest";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeContentRecord";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateHash";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6 -> new IllegalStateException(string);
        };
    }

    final class ContentOutputStream
    extends DataOutputStream {
        private final int fileId;
        private final boolean fixedSize;

        ContentOutputStream(int fileId, boolean fixedSize) {
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            PersistentFSConnection.ensureIdIsValid(fileId);
            this.fileId = fileId;
            this.fixedSize = fixedSize;
        }

        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            PersistentFSContentAccessor.this.writeContent(this.fileId, _out.toByteArraySequence(), this.fixedSize);
        }
    }
}

