/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSContentAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.util.BitUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PersistentFSRecordAccessor {
    private static final Logger LOG = Logger.getInstance(PersistentFSRecordAccessor.class);
    @NotNull
    private final PersistentFSConnection connection;
    @NotNull
    private final PersistentFSContentAccessor contentAccessor;
    @NotNull
    private final PersistentFSAttributeAccessor attributeAccessor;
    private final Object newFreeRecordsSync;
    private final IntList newFreeRecords;

    PersistentFSRecordAccessor(@NotNull PersistentFSContentAccessor contentAccessor, @NotNull PersistentFSAttributeAccessor attributeAccessor, @NotNull PersistentFSConnection connection) {
        if (contentAccessor == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(0);
        }
        if (attributeAccessor == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(2);
        }
        this.newFreeRecordsSync = new Object();
        this.newFreeRecords = IntLists.synchronize((IntList)new IntArrayList(), (Object)this.newFreeRecordsSync);
        this.contentAccessor = contentAccessor;
        this.attributeAccessor = attributeAccessor;
        this.connection = connection;
    }

    public void markRecordAsDeleted(int id2) throws IOException {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.newFreeRecords.add(id2);
        }
        this.connection.records().setFlags(id2, 1024);
    }

    public int createRecord(Iterable<FSRecordsImpl.FileIdIndexedStorage> fileIdIndexedStorages) throws IOException {
        PersistentFSRecordsStorage records = this.connection.records();
        if (!FSRecordsImpl.REUSE_DELETED_FILE_IDS) {
            int newRecordId = records.allocateRecord();
            this.checkNewRecordIsZero(records, newRecordId);
            return newRecordId;
        }
        int reusedRecordId = this.connection.reserveFreeRecord();
        if (reusedRecordId < 0) {
            int newRecordId = records.allocateRecord();
            this.checkNewRecordIsZero(records, newRecordId);
            return newRecordId;
        }
        this.deleteContentAndAttributes(reusedRecordId);
        for (FSRecordsImpl.FileIdIndexedStorage storage : fileIdIndexedStorages) {
            storage.clear(reusedRecordId);
        }
        records.cleanRecord(reusedRecordId);
        return reusedRecordId;
    }

    private void checkNewRecordIsZero(PersistentFSRecordsStorage records, int newRecordId) throws IOException {
        int parentId = records.getParent(newRecordId);
        int nameId = records.getNameId(newRecordId);
        int contentId = records.getContentRecordId(newRecordId);
        int attributeRecordId = records.getAttributeRecordId(newRecordId);
        int flags = records.getFlags(newRecordId);
        int modCount = records.getModCount(newRecordId);
        long length = records.getLength(newRecordId);
        long timestamp = records.getTimestamp(newRecordId);
        if (parentId != 0 || nameId != 0 || contentId != 0 || attributeRecordId != 0 || flags != 0 || length != 0L || timestamp != 0L) {
            String message = "new record (id: " + newRecordId + ") has non-empty fields: parentId=" + parentId + ", flags=" + flags + ", nameId= " + nameId + ", attributeId=" + attributeRecordId + ", contentId=" + contentId + ", length=" + length + ", timestamp=" + timestamp + ", modCount=" + modCount + " (globalModCount: " + records.getGlobalModCount() + "), status={" + this.connection.describeConsistencyStatus() + "}";
            if (records.wasAlwaysClosedProperly()) {
                FSRecords.THROTTLED_LOG.error(message);
            } else {
                FSRecords.THROTTLED_LOG.warn(message);
            }
            this.connection.markAsCorruptedAndScheduleRebuild(new IOException(message));
            records.cleanRecord(newRecordId);
        }
    }

    public boolean isDeleted(int id2) throws IOException {
        int flags = this.connection.records().getFlags(id2);
        return PersistentFSRecordAccessor.hasDeletedFlag(flags) || this.newFreeRecords.contains(id2);
    }

    public static boolean hasDeletedFlag(int flags) {
        return BitUtil.isSet((int)flags, (int)1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public IntList getNewFreeRecords() {
        Object object = this.newFreeRecordsSync;
        // MONITORENTER : object
        IntArrayList intArrayList = new IntArrayList(this.newFreeRecords);
        // MONITOREXIT : object
        if (intArrayList != null) return intArrayList;
        PersistentFSRecordAccessor.$$$reportNull$$$0(3);
        return intArrayList;
    }

    private void deleteContentAndAttributes(int id2) throws IOException {
        this.contentAccessor.deleteContent(id2);
        this.attributeAccessor.deleteAttributes(id2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAccessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFreeRecords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

