/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.dev;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.Hash;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class OptimizedCaseInsensitiveStringHashing
implements Hash.Strategy<String> {
    private static final Logger LOG;
    private static final VarHandle CODER_HANDLE;
    private static final VarHandle VALUE_HANDLE;
    private static final Hash.Strategy<String> FALLBACK_STRATEGY;
    private static final OptimizedCaseInsensitiveStringHashing OPTIMIZED_STRATEGY;

    public static Hash.Strategy<String> instance() {
        if (CODER_HANDLE != null && VALUE_HANDLE != null) {
            return OPTIMIZED_STRATEGY;
        }
        return FALLBACK_STRATEGY;
    }

    private OptimizedCaseInsensitiveStringHashing() {
    }

    public int hashCode(@Nullable String str) {
        if (str == null) {
            return 0;
        }
        return OptimizedCaseInsensitiveStringHashing.caseInsensitiveHashCode(str);
    }

    public boolean equals(@Nullable String a, @Nullable String b) {
        return FALLBACK_STRATEGY.equals((Object)a, (Object)b);
    }

    @VisibleForTesting
    public static int caseInsensitiveHashCode(@NotNull String str) {
        byte coder;
        if (str == null) {
            OptimizedCaseInsensitiveStringHashing.$$$reportNull$$$0(0);
        }
        if ((coder = CODER_HANDLE.get(str)) == 1) {
            return FALLBACK_STRATEGY.hashCode((Object)str);
        }
        byte[] bytes = VALUE_HANDLE.get(str);
        int hash = 0;
        int length = str.length();
        for (int i2 = 0; i2 < length; ++i2) {
            byte ch = bytes[i2];
            hash = 31 * hash + (ch & 0xDF);
        }
        return hash;
    }

    @VisibleForTesting
    public static int caseInsensitiveHashCode(byte ch) {
        return ch & 0xDF;
    }

    static {
        VarHandle valueHandle;
        VarHandle coderHandle;
        LOG = Logger.getInstance(OptimizedCaseInsensitiveStringHashing.class);
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(String.class, MethodHandles.lookup());
            coderHandle = lookup.findVarHandle(String.class, "coder", Byte.TYPE).withInvokeExactBehavior();
            valueHandle = lookup.findVarHandle(String.class, "value", byte[].class).withInvokeExactBehavior();
        }
        catch (Exception e) {
            LOG.error("Can't initialize fast case-insensitive hashing strategy", (Throwable)e);
            coderHandle = null;
            valueHandle = null;
        }
        CODER_HANDLE = coderHandle;
        VALUE_HANDLE = valueHandle;
        FALLBACK_STRATEGY = FastUtilHashingStrategies.getCaseInsensitiveStringStrategy();
        OPTIMIZED_STRATEGY = new OptimizedCaseInsensitiveStringHashing();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/vfs/newvfs/persistent/dev/OptimizedCaseInsensitiveStringHashing", "caseInsensitiveHashCode"));
    }
}

