/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.ToolWindowEntry;
import com.intellij.util.ModalityUiUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowFocusWatcher;", "Lcom/intellij/openapi/wm/FocusWatcher;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/wm/impl/ToolWindowImpl;Ljavax/swing/JComponent;)V", "id", "", "isFocusedComponentChangeValid", "", "Ljava/awt/Component;", "cause", "Ljava/awt/AWTEvent;", "focusedComponentChanged", "", "intellij.platform.ide.impl"})
final class ToolWindowFocusWatcher
extends FocusWatcher {
    @NotNull
    private final ToolWindowImpl toolWindow;
    @NotNull
    private final String id;

    public ToolWindowFocusWatcher(@NotNull ToolWindowImpl toolWindow2, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.toolWindow = toolWindow2;
        this.id = this.toolWindow.getId();
        this.install(component2);
        Disposer.register((Disposable)this.toolWindow.getDisposable(), () -> ToolWindowFocusWatcher._init_$lambda$0(this, component2));
    }

    protected boolean isFocusedComponentChangeValid(@Nullable Component component2, @Nullable AWTEvent cause) {
        return component2 != null;
    }

    protected void focusedComponentChanged(@Nullable Component component2, @Nullable AWTEvent cause) {
        if (component2 == null || !this.toolWindow.isActive()) {
            return;
        }
        ToolWindowManagerImpl toolWindowManager = this.toolWindow.toolWindowManager;
        toolWindowManager.getFocusManager().doWhenFocusSettlesDown(ExpirableRunnable.forProject((Project)toolWindowManager.getProject(), () -> ToolWindowFocusWatcher.focusedComponentChanged$lambda$0(toolWindowManager, this, component2)));
    }

    private static final void _init_$lambda$0(ToolWindowFocusWatcher this$0, JComponent $component) {
        this$0.deinstall($component);
    }

    private static final void focusedComponentChanged$lambda$0$0(ToolWindowManagerImpl $toolWindowManager, ToolWindowFocusWatcher this$0, Component $component) {
        ToolWindowEntry toolWindowEntry = $toolWindowManager.getEntry$intellij_platform_ide_impl(this$0.id);
        if (toolWindowEntry == null) {
            return;
        }
        ToolWindowEntry entry = toolWindowEntry;
        WindowInfo windowInfo = entry.getReadOnlyWindowInfo();
        if (!windowInfo.isVisible()) {
            return;
        }
        ToolWindowManagerImpl.activateToolWindow$intellij_platform_ide_impl$default($toolWindowManager, entry, $toolWindowManager.getRegisteredMutableInfoOrLogError$intellij_platform_ide_impl(entry.getId()), false, null, 8, null);
        InternalDecoratorImpl.Companion.setActiveDecorator$intellij_platform_ide_impl(this$0.toolWindow, $component);
    }

    private static final void focusedComponentChanged$lambda$0(ToolWindowManagerImpl $toolWindowManager, ToolWindowFocusWatcher this$0, Component $component) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Condition)$toolWindowManager.getProject().getDisposed(), () -> ToolWindowFocusWatcher.focusedComponentChanged$lambda$0$0($toolWindowManager, this$0, $component));
    }
}

