/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.wm.impl.customFrameDecorations.frameButtons.CustomFrameButtons;
import com.intellij.openapi.wm.impl.customFrameDecorations.frameButtons.LinuxResizableCustomFrameButtons;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0014J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0016J\b\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0017H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00178DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/FrameHeader;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;", "frame", "Ljavax/swing/JFrame;", "<init>", "(Ljavax/swing/JFrame;)V", "getFrame", "()Ljavax/swing/JFrame;", "iconifyAction", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$CustomFrameAction;", "restoreAction", "maximizeAction", "state", "", "getState", "()I", "setState", "(I)V", "closeAction", "Ljavax/swing/Action;", "getCloseAction$annotations", "()V", "buttonPanes", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/CustomFrameButtons;", "getButtonPanes", "()Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/CustomFrameButtons;", "buttonPanes$delegate", "Lkotlin/Lazy;", "windowStateChanged", "", "updateActive", "iconify", "maximize", "restore", "addNotify", "updateActions", "addMenuItems", "menu", "Ljavax/swing/JPopupMenu;", "createButtonsPane", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFrameHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameHeader.kt\ncom/intellij/openapi/wm/impl/customFrameDecorations/header/FrameHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public abstract non-sealed class FrameHeader
extends CustomHeader {
    @NotNull
    private final JFrame frame;
    @NotNull
    private final CustomHeader.CustomFrameAction iconifyAction;
    @NotNull
    private final CustomHeader.CustomFrameAction restoreAction;
    @NotNull
    private final CustomHeader.CustomFrameAction maximizeAction;
    private int state;
    @NotNull
    private final Action closeAction;
    @NotNull
    private final Lazy buttonPanes$delegate;

    public FrameHeader(@NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        super(frame, null);
        this.frame = frame;
        String string = ActionsBundle.message((String)"action.MinimizeCurrentWindow.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon2 = AllIcons.Windows.MinimizeSmall;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"MinimizeSmall");
        this.iconifyAction = new CustomHeader.CustomFrameAction(string, icon2, (Function0<Unit>)((Function0)() -> FrameHeader.iconifyAction$lambda$0(this)));
        String string2 = CommonBundle.message((String)"button.without.mnemonic.restore", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Icon icon3 = AllIcons.Windows.RestoreSmall;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"RestoreSmall");
        this.restoreAction = new CustomHeader.CustomFrameAction(string2, icon3, (Function0<Unit>)((Function0)() -> FrameHeader.restoreAction$lambda$0(this)));
        String string3 = IdeBundle.message((String)"action.maximize.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Icon icon4 = AllIcons.Windows.MaximizeSmall;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"MaximizeSmall");
        this.maximizeAction = new CustomHeader.CustomFrameAction(string3, icon4, (Function0<Unit>)((Function0)() -> FrameHeader.maximizeAction$lambda$0(this)));
        this.closeAction = CustomHeader.Companion.createCloseAction$intellij_platform_ide_impl(this);
        this.buttonPanes$delegate = LazyKt.lazy(() -> FrameHeader.buttonPanes_delegate$lambda$0(this));
    }

    @NotNull
    protected final JFrame getFrame() {
        return this.frame;
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int n) {
        this.state = n;
    }

    private static /* synthetic */ void getCloseAction$annotations() {
    }

    @Nullable
    protected final CustomFrameButtons getButtonPanes() {
        Lazy lazy = this.buttonPanes$delegate;
        return (CustomFrameButtons)lazy.getValue();
    }

    @Override
    public void windowStateChanged() {
        super.windowStateChanged();
        this.updateActions();
    }

    @Override
    protected void updateActive() {
        block0: {
            super.updateActive();
            CustomFrameButtons customFrameButtons = this.getButtonPanes();
            if (customFrameButtons == null) break block0;
            customFrameButtons.onUpdateFrameActive();
        }
    }

    private final void iconify() {
        this.frame.setExtendedState(this.state | 1);
    }

    private final void maximize() {
        this.frame.setExtendedState(this.state | 6);
    }

    private final void restore() {
        if ((this.state & 1) != 0) {
            this.frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            this.frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateActions();
    }

    private final void updateActions() {
        this.state = this.frame.getExtendedState();
        if (this.frame.isResizable()) {
            if ((this.state & 6) == 6) {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(true);
            } else {
                this.maximizeAction.setEnabled(true);
                this.restoreAction.setEnabled(false);
            }
        } else {
            this.maximizeAction.setEnabled(false);
            this.restoreAction.setEnabled(false);
        }
        this.iconifyAction.setEnabled(true);
        this.closeAction.setEnabled(true);
        CustomFrameButtons customFrameButtons = this.getButtonPanes();
        if (customFrameButtons != null) {
            customFrameButtons.updateVisibility();
        }
        this.updateCustomTitleBar();
    }

    @Override
    public void addMenuItems(@NotNull JPopupMenu menu) {
        JMenuItem jMenuItem;
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        JMenuItem $this$addMenuItems_u24lambda_u240 = jMenuItem = menu.add(this.restoreAction);
        boolean bl = false;
        $this$addMenuItems_u24lambda_u240.setFont((Font)JBFont.create((Font)$this$addMenuItems_u24lambda_u240.getFont(), (boolean)false));
        JMenuItem $this$addMenuItems_u24lambda_u241 = jMenuItem = menu.add(this.iconifyAction);
        boolean bl2 = false;
        $this$addMenuItems_u24lambda_u241.setFont((Font)JBFont.create((Font)$this$addMenuItems_u24lambda_u241.getFont(), (boolean)false));
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            JMenuItem $this$addMenuItems_u24lambda_u242 = jMenuItem = menu.add(this.maximizeAction);
            boolean bl3 = false;
            $this$addMenuItems_u24lambda_u242.setFont((Font)JBFont.create((Font)$this$addMenuItems_u24lambda_u242.getFont(), (boolean)false));
        }
        menu.add(new JSeparator());
        JMenuItem closeMenuItem = menu.add(this.closeAction);
        closeMenuItem.setFont(JBFont.label().deriveFont(1));
    }

    private final CustomFrameButtons createButtonsPane() {
        if (CustomWindowHeaderUtil.INSTANCE.hideNativeLinuxTitle$intellij_platform_ide_impl(UISettings.Companion.getShadowInstance())) {
            return LinuxResizableCustomFrameButtons.Companion.create(this.closeAction, this.restoreAction, this.iconifyAction, this.maximizeAction);
        }
        return null;
    }

    private static final Unit iconifyAction$lambda$0(FrameHeader this$0) {
        this$0.iconify();
        return Unit.INSTANCE;
    }

    private static final Unit restoreAction$lambda$0(FrameHeader this$0) {
        this$0.restore();
        return Unit.INSTANCE;
    }

    private static final Unit maximizeAction$lambda$0(FrameHeader this$0) {
        this$0.maximize();
        return Unit.INSTANCE;
    }

    private static final CustomFrameButtons buttonPanes_delegate$lambda$0(FrameHeader this$0) {
        return this$0.createButtonsPane();
    }
}

