/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import com.intellij.serialization.stateProperties.MyMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00050\u0004B\u001d\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005H\u0016J0\u0010\u0015\u001a\u00020\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u0096\u0080\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u0096\u0080\u0004J\"\u0010\u0012\u001a\u00020\u000e2\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050\u001fH\u0016J\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/serialization/stateProperties/MapStoredProperty;", "K", "", "V", "Lcom/intellij/openapi/components/StoredPropertyBase;", "", "value", "<init>", "(Ljava/util/Map;)V", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "isEqualToDefault", "", "getValue", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "setValue", "", "newValue", "doSetValue", "old", "new", "", "equals", "other", "hashCode", "", "toString", "", "Lcom/intellij/openapi/components/StoredProperty;", "__getValue", "getModificationCount", "", "intellij.platform.objectSerializer"})
@ApiStatus.Internal
public final class MapStoredProperty<K, V>
extends StoredPropertyBase<Map<K, V>> {
    @NotNull
    private final Map<K, V> value;

    public MapStoredProperty(@Nullable Map<K, V> value) {
        Map map2 = value;
        if (map2 == null) {
            map2 = (Map)((Object)new MyMap());
        }
        this.value = map2;
    }

    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.OBJECT;
    }

    public boolean isEqualToDefault() {
        return this.value.isEmpty();
    }

    @NotNull
    public Map<K, V> getValue(@NotNull BaseState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        return this.value;
    }

    public void setValue(@NotNull BaseState thisRef, @NotNull Map<K, V> newValue) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        if (this.doSetValue(this.value, newValue)) {
            thisRef.intIncrementModificationCount();
        }
    }

    private final boolean doSetValue(Map<K, V> old, Map<K, ? extends V> map2) {
        if (Intrinsics.areEqual(old, map2)) {
            return false;
        }
        old.clear();
        old.putAll(map2);
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof MapStoredProperty && Intrinsics.areEqual(this.value, ((MapStoredProperty)((Object)other)).value);
    }

    public int hashCode() {
        return ((Object)this.value).hashCode();
    }

    @NotNull
    public String toString() {
        return this.isEqualToDefault() ? "" : this.value.toString();
    }

    public boolean setValue(@NotNull StoredProperty<Map<K, V>> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.doSetValue(this.value, ((MapStoredProperty)other).value);
    }

    @NotNull
    public final Map<K, V> __getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public long getModificationCount() {
        long l;
        if (this.value instanceof MyMap) {
            l = ((MyMap)((Object)this.value)).getModificationCount();
        } else {
            void var1_1;
            long result2 = 0L;
            for (V value : this.value.values()) {
                if (!(value instanceof BaseState)) break;
                result2 += ((BaseState)value).getModificationCount();
            }
            l = var1_1;
        }
        return l;
    }
}

