/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

final class MacOsNotifications
implements SystemNotificationsImpl.Notifier {
    private static MacOsNotifications ourInstance;

    @NotNull
    static synchronized MacOsNotifications getInstance() {
        if (ourInstance == null && JnaLoader.isLoaded()) {
            ourInstance = new MacOsNotifications();
        }
        MacOsNotifications macOsNotifications = ourInstance;
        if (macOsNotifications == null) {
            MacOsNotifications.$$$reportNull$$$0(0);
        }
        return macOsNotifications;
    }

    private MacOsNotifications() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(this){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                MacOsNotifications.cleanupDeliveredNotifications();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/ui/MacOsNotifications$1", "applicationActivated"));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(this){

            public void appClosing() {
                MacOsNotifications.cleanupDeliveredNotifications();
            }
        });
    }

    @Override
    public void notify(@NotNull String name2, @NotNull String title2, @NotNull String description) {
        if (name2 == null) {
            MacOsNotifications.$$$reportNull$$$0(1);
        }
        if (title2 == null) {
            MacOsNotifications.$$$reportNull$$$0(2);
        }
        if (description == null) {
            MacOsNotifications.$$$reportNull$$$0(3);
        }
        ID notification2 = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSUserNotification"), (String)"new", (Object[])new Object[0]);
        Foundation.invoke((ID)notification2, (String)"setTitle:", (Object[])new Object[]{Foundation.nsString((String)StringUtil.stripHtml((String)title2, (boolean)true).replace("%", "%%"))});
        Foundation.invoke((ID)notification2, (String)"setInformativeText:", (Object[])new Object[]{Foundation.nsString((String)StringUtil.stripHtml((String)description, (boolean)true).replace("%", "%%"))});
        ID center = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSUserNotificationCenter"), (String)"defaultUserNotificationCenter", (Object[])new Object[0]);
        Foundation.invoke((ID)center, (String)"deliverNotification:", (Object[])new Object[]{notification2});
    }

    private static void cleanupDeliveredNotifications() {
        ID center = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSUserNotificationCenter"), (String)"defaultUserNotificationCenter", (Object[])new Object[0]);
        Foundation.invoke((ID)center, (String)"removeAllDeliveredNotifications", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/MacOsNotifications";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/MacOsNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

