/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.ui.components.JBLabel;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/components/IconLabelButton;", "Lcom/intellij/ui/components/JBLabel;", "icon", "Ljavax/swing/Icon;", "onClickHandler", "Lkotlin/Function1;", "Ljavax/swing/JComponent;", "", "<init>", "(Ljavax/swing/Icon;Lkotlin/jvm/functions/Function1;)V", "hovered", "", "lb", "paintComponent", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
public final class IconLabelButton
extends JBLabel {
    private boolean hovered;
    @NotNull
    private final IconLabelButton lb;

    public IconLabelButton(@NotNull Icon icon2, final @NotNull Function1<? super JComponent, Unit> onClickHandler) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter(onClickHandler, (String)"onClickHandler");
        super(icon2);
        this.lb = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e)) {
                    onClickHandler.invoke((Object)this);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                hovered = true;
                lb.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                hovered = false;
                lb.repaint();
            }
        });
    }

    protected void paintComponent(@Nullable Graphics g) {
        if (this.hovered) {
            ActionButtonLook.SYSTEM_LOOK.paintBackground(g, (JComponent)((Object)this.lb), 2);
        }
        super.paintComponent(g);
    }
}

