/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefAppArmorUtils;
import com.intellij.ui.jcef.JBCefHealthMonitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class JBCefNotifications {
    @Nullable
    public static EditorNotificationPanel createEditorNotificationPanel(Editor editor2, JBCefHealthMonitor.Status status2) {
        return switch (status2) {
            default -> throw new MatchException(null, null);
            case JBCefHealthMonitor.Status.UNKNOWN, JBCefHealthMonitor.Status.OK -> null;
            case JBCefHealthMonitor.Status.UNPRIVILEGED_USER_NS_DISABLED -> {
                EditorNotificationPanel panel = JBCefNotifications.createEditorNotificationPanel(editor2, IdeBundle.message((String)"notification.content.jcef.browser.suspended.text", (Object[])new Object[0]));
                panel.createActionLabel(IdeBundle.message((String)"notification.content.jcef.enable.browser.button", (Object[])new Object[0]), () -> JBCefAppArmorUtils.showUnprivilegedUserNamespacesRestrictedDialog((Component)panel));
                yield panel;
            }
            case JBCefHealthMonitor.Status.RUN_UNDER_SUPER_USER -> JBCefNotifications.createEditorNotificationPanel(editor2, IdeBundle.message((String)"notification.content.jcef.super.user.error.message", (Object[])new Object[0]));
            case JBCefHealthMonitor.Status.GPU_PROCESS_FAILED -> JBCefNotifications.createEditorNotificationPanel(editor2, IdeBundle.message((String)"notification.content.jcef.gpu.process.failed.error.message", (Object[])new Object[0]));
        };
    }

    @Nullable
    static Component createStubPanel(JBCefHealthMonitor.Status status2) {
        return switch (status2) {
            default -> throw new MatchException(null, null);
            case JBCefHealthMonitor.Status.UNKNOWN, JBCefHealthMonitor.Status.OK -> null;
            case JBCefHealthMonitor.Status.UNPRIVILEGED_USER_NS_DISABLED -> JBCefNotifications.createUnprivilegedUserNSStubPanel();
            case JBCefHealthMonitor.Status.RUN_UNDER_SUPER_USER -> JBCefNotifications.createTextComponent(IdeBundle.message((String)"notification.content.jcef.super.user.error.message", (Object[])new Object[0]));
            case JBCefHealthMonitor.Status.GPU_PROCESS_FAILED -> JBCefNotifications.createTextComponent(IdeBundle.message((String)"notification.content.jcef.gpu.process.failed.error.message", (Object[])new Object[0]));
        };
    }

    static void showAppArmorNotification() {
        Notification notification2 = JBCefApp.getNotificationGroup().createNotification(IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.title", (Object[])new Object[0]), IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.message", (Object[])new Object[0]), NotificationType.WARNING);
        AnAction installProfileAction = JBCefAppArmorUtils.getInstallInstallAppArmorProfileAction(() -> notification2.expire());
        if (installProfileAction != null) {
            notification2.addAction(installProfileAction);
        }
        notification2.addAction((AnAction)NotificationAction.createSimple((String)IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.action.disable.sandbox", (Object[])new Object[0]), () -> {
            RegistryManager.getInstance().get("ide.browser.jcef.sandbox.enable").setValue(false);
            notification2.expire();
            ApplicationManager.getApplication().restart();
        }));
        notification2.addAction((AnAction)NotificationAction.createSimple((String)IdeBundle.message((String)"notification.content.jcef.unprivileged.userns.restricted.action.learn.more", (Object[])new Object[0]), () -> BrowserUtil.browse((String)"https://youtrack.jetbrains.com/articles/JBR-A-11")));
        Notifications.Bus.notify((Notification)notification2);
    }

    private static JComponent createUnprivilegedUserNSStubPanel() {
        return JBCefAppArmorUtils.getUnprivilegedUserNamespacesRestrictedStubPanel();
    }

    private static EditorNotificationPanel createEditorNotificationPanel(Editor editor2, @Nls String text2) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel(editor2, LightColors.YELLOW, null, EditorNotificationPanel.Status.Warning);
        panel2.setText(text2);
        return panel2;
    }

    private static JComponent createTextComponent(@Nls String text2) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        panel2.add((Component)new JLabel(text2), c);
        return panel2;
    }
}

