/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GroupHeaderSeparator;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.popup.NumericMnemonicItem;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.InlineActionsUtilKt;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupInlineActionsSupport;
import com.intellij.ui.popup.list.PopupInlineActionsSupportKt;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PopupListElementRenderer<E>
extends GroupedItemsListRenderer<E> {
    public static final Key<@NlsSafe String> CUSTOM_KEY_STROKE_TEXT = new Key("CUSTOM_KEY_STROKE_TEXT");
    protected final ListPopupImpl myPopup;
    @Nullable
    private JLabel myShortcutLabel;
    @Nullable
    private JLabel mySecondaryIconLabel;
    @Nullable
    private JLabel mySecondaryTextLabel;
    protected JLabel myMnemonicLabel;
    protected JLabel myIconLabel;
    private JPanel myButtonPane;
    private Boolean hasExtraButtons;
    private JComponent myMainPane;
    protected JComponent myButtonSeparator;
    protected JComponent myIconBar;
    private final PopupInlineActionsSupport myInlineActionsSupport;
    private final UpdateScaleHelper myUpdateScaleHelper;

    public PopupListElementRenderer(final @NotNull ListPopupImpl aPopup) {
        if (aPopup == null) {
            PopupListElementRenderer.$$$reportNull$$$0(0);
        }
        super((ListItemDescriptor)new ListItemDescriptorAdapter<E>(){

            public String getTextFor(E value) {
                return aPopup.getListStep().getTextFor(value);
            }

            public Icon getIconFor(E value) {
                return aPopup.getListStep().getIconFor(value);
            }

            public Icon getSelectedIconFor(E value) {
                return aPopup.getListStep().getSelectedIconFor(value);
            }

            public boolean hasSeparatorAboveOf(E value) {
                return aPopup.getListModel().isSeparatorAboveOf(value);
            }

            public String getCaptionAboveOf(E value) {
                return aPopup.getListModel().getCaptionAboveOf(value);
            }

            @Nullable
            public String getTooltipFor(E value) {
                ListPopupStep<Object> listStep = aPopup.getListStep();
                if (!(listStep instanceof ListPopupStepEx)) {
                    return null;
                }
                return ((ListPopupStepEx)listStep).getTooltipTextFor(value);
            }
        });
        this.hasExtraButtons = null;
        this.myUpdateScaleHelper = new UpdateScaleHelper();
        this.myPopup = aPopup;
        this.myInlineActionsSupport = PopupInlineActionsSupportKt.createSupport(this.myPopup);
    }

    public ListPopupImpl getPopup() {
        return this.myPopup;
    }

    protected SeparatorWithText createSeparator() {
        Insets labelInsets = ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Popup.separatorLabelInsets() : this.getDefaultItemComponentBorder().getBorderInsets(new JLabel());
        return new GroupHeaderSeparator(labelInsets);
    }

    protected Color getBackground() {
        return ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Popup.BACKGROUND : super.getBackground();
    }

    protected JComponent createItemComponent() {
        this.createLabel();
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension size2 = super.getPreferredSize();
                if (ExperimentalUI.isNewUI()) {
                    size2.height = JBUI.CurrentTheme.List.rowHeight();
                }
                return size2;
            }
        };
        panel2.add((Component)this.myTextLabel, "West");
        JPanel secondary = new JPanel(new BorderLayout());
        JBEmptyBorder secondaryBorder = ExperimentalUI.isNewUI() ? JBUI.Borders.empty() : JBUI.Borders.empty((int)0, (int)8, (int)1, (int)0);
        secondary.setBorder((Border)secondaryBorder);
        this.mySecondaryTextLabel = new JLabel();
        this.mySecondaryTextLabel.setEnabled(false);
        this.mySecondaryTextLabel.setForeground(UIManager.getColor("MenuItem.acceleratorForeground"));
        secondary.add((Component)this.mySecondaryTextLabel, "East");
        this.mySecondaryIconLabel = new JLabel();
        JBEmptyBorder secondaryIconBorder = JBUI.Borders.empty((int)0, (int)(JBUI.CurrentTheme.ActionsList.elementIconGap() + 1), (int)0, (int)1);
        this.mySecondaryIconLabel.setBorder((Border)secondaryIconBorder);
        this.mySecondaryIconLabel.setVisible(false);
        secondary.add((Component)this.mySecondaryIconLabel, "West");
        panel2.add((Component)secondary, "Center");
        this.myShortcutLabel = new JLabel();
        JBEmptyBorder shortcutBorder = ExperimentalUI.isNewUI() ? JBUI.Borders.empty() : JBUI.Borders.empty((int)0, (int)0, (int)1, (int)3);
        this.myShortcutLabel.setBorder((Border)shortcutBorder);
        this.myShortcutLabel.setForeground(UIManager.getColor("MenuItem.acceleratorForeground"));
        panel2.add((Component)this.myShortcutLabel, "East");
        this.myMnemonicLabel = new JLabel();
        this.myMnemonicLabel.setFont(JBUI.CurrentTheme.ActionsList.applyStylesForNumberMnemonic((Font)this.myMnemonicLabel.getFont()));
        if (!ExperimentalUI.isNewUI()) {
            Insets insets = JBUI.CurrentTheme.ActionsList.numberMnemonicInsets();
            this.myMnemonicLabel.setBorder((Border)new JBEmptyBorder(insets));
            Dimension preferredSize = new JLabel("W").getPreferredSize();
            JBInsets.addTo((Dimension)preferredSize, (Insets)insets);
            this.myMnemonicLabel.setPreferredSize(preferredSize);
        } else {
            this.myMnemonicLabel.setBorder((Border)new JBEmptyBorder(JBUI.CurrentTheme.ActionsList.mnemonicInsets()));
            this.myMnemonicLabel.setHorizontalAlignment(4);
            this.myMnemonicLabel.setText("W");
            Dimension preferredSize = this.myMnemonicLabel.getPreferredSize();
            this.myMnemonicLabel.setText(null);
            JBInsets.addTo((Dimension)preferredSize, (Insets)JBUI.insetsLeft((int)4));
            this.myMnemonicLabel.setPreferredSize(preferredSize);
            this.myMnemonicLabel.setMinimumSize((Dimension)JBUI.size((int)12, (int)this.myMnemonicLabel.getMinimumSize().height));
        }
        this.myMnemonicLabel.setVisible(false);
        this.myIconBar = this.createIconBar();
        return this.layoutComponent(panel2);
    }

    protected void createLabel() {
        super.createLabel();
        this.myIconLabel = new JLabel();
    }

    protected JComponent layoutComponent(JComponent middleItemComponent) {
        Object result2;
        this.myNextStepLabel = new JLabel();
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)middleItemComponent, "Center");
        JPanel right = new JPanel(new GridBagLayout());
        this.myButtonSeparator = PopupListElementRenderer.createButtonsSeparator();
        left.add((Component)this.myButtonSeparator, "East");
        if (this.myIconBar != null) {
            left.add((Component)this.myIconBar, "West");
        }
        if (ExperimentalUI.isNewUI()) {
            result2 = new SelectablePanel();
            ((JComponent)result2).setOpaque(false);
            PopupUtil.configListRendererFixedHeight((SelectablePanel)((SelectablePanel)result2));
        } else {
            result2 = new JPanel();
            ((JComponent)result2).setBorder((Border)JBUI.Borders.empty());
        }
        ((Container)result2).setLayout(new GridBagLayout());
        Insets insets = this.getDefaultItemComponentBorder().getBorderInsets((Component)result2);
        if (ExperimentalUI.isNewUI()) {
            left.setBorder((Border)JBUI.Borders.empty());
            right.setBorder((Border)JBUI.Borders.empty());
        } else {
            int leftRightInset = (20 - AllIcons.Icons.Ide.MenuArrow.getIconWidth()) / 2;
            left.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)0));
            right.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)leftRightInset, (int)insets.bottom, (int)insets.right));
        }
        GridBag gbc = new GridBag().setDefaultAnchor(0, 17).setDefaultWeightX(0, 1.0).setDefaultAnchor(10).setDefaultWeightX(0.0).setDefaultWeightY(1.0).setDefaultPaddingX(0).setDefaultPaddingY(0).setDefaultInsets(0, 0, 0, 0).setDefaultFill(1);
        ((Container)result2).add((Component)left, gbc.next());
        ((Container)result2).add((Component)right, gbc.next());
        this.myMainPane = left;
        this.myButtonPane = right;
        return result2;
    }

    protected void setComponentIcon(Icon icon2, Icon disabledIcon) {
        if (this.myIconLabel == null) {
            return;
        }
        this.myIconLabel.setIcon(icon2);
        this.myIconLabel.setDisabledIcon(disabledIcon);
        if (ExperimentalUI.isNewUI() && icon2 != null && icon2.getIconWidth() != -1 && icon2.getIconHeight() != -1) {
            this.myIconLabel.setBorder((Border)JBUI.Borders.emptyRight((int)(JBUI.CurrentTheme.ActionsList.elementIconGap() - 2)));
        }
    }

    @NotNull
    protected static JComponent createButtonsSeparator() {
        SeparatorComponent separator = new SeparatorComponent(JBUI.CurrentTheme.List.buttonSeparatorColor(), SeparatorOrientation.VERTICAL);
        separator.setHGap(1);
        separator.setVGap(JBUI.CurrentTheme.List.buttonSeparatorInset());
        SeparatorComponent separatorComponent = separator;
        if (separatorComponent == null) {
            PopupListElementRenderer.$$$reportNull$$$0(1);
        }
        return separatorComponent;
    }

    protected void customizeComponent(JList<? extends E> list2, E value, boolean isSelected) {
        JComponent jComponent;
        SelectablePanel selectablePanel;
        JComponent jComponent2;
        boolean showNextStepLabel;
        if (this.mySeparatorComponent.isVisible() && this.mySeparatorComponent instanceof GroupHeaderSeparator) {
            ((GroupHeaderSeparator)this.mySeparatorComponent).setHideLine(this.myCurrentIndex == 0);
        }
        ListPopupStep<Object> step2 = this.myPopup.getListStep();
        boolean isSelectable = step2.isSelectable(value);
        this.myTextLabel.setEnabled(isSelectable);
        this.myMainPane.setOpaque(false);
        this.myButtonPane.setOpaque(false);
        boolean nextStepButtonSelected = false;
        boolean bl = showNextStepLabel = step2.hasSubstep(value) && !this.myInlineActionsSupport.hasExtraButtons(value);
        if (showNextStepLabel) {
            this.myNextStepLabel.setVisible(isSelectable);
            this.myNextStepLabel.setIcon(isSelectable && isSelected ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow);
            this.myNextStepLabel.getAccessibleContext().setAccessibleName(isSelectable ? IdeBundle.message((String)"popup.list.item.renderer.next.step.label.accessible.name", (Object[])new Object[0]) : null);
            if (ExperimentalUI.isNewUI()) {
                this.myNextStepLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
            } else {
                this.getItemComponent().setBackground(this.calcBackground(isSelected && isSelectable));
            }
            this.setForegroundSelected((JComponent)this.myTextLabel, isSelected && isSelectable);
        } else {
            this.myNextStepLabel.setVisible(false);
            this.myNextStepLabel.getAccessibleContext().setAccessibleName(null);
        }
        boolean hasNextIcon = this.myNextStepLabel.isVisible();
        boolean hasInlineButtons = this.updateExtraButtons(list2, value, step2, isSelected, hasNextIcon);
        if (ExperimentalUI.isNewUI() && (jComponent2 = this.getItemComponent()) instanceof SelectablePanel) {
            selectablePanel = (SelectablePanel)jComponent2;
            this.myUpdateScaleHelper.saveScaleAndRunIfChanged(() -> {
                if (ExperimentalUI.isNewUI()) {
                    PopupUtil.configListRendererFixedHeight((SelectablePanel)selectablePanel);
                }
            });
            selectablePanel.setSelectionColor(isSelected && isSelectable ? UIUtil.getListSelectionBackground((boolean)true) : null);
            int leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get();
            JBInsets innerInsets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
            int expectedRightInset = leftRightInset * 2;
            if (hasNextIcon || hasInlineButtons) {
                expectedRightInset -= this.myButtonSeparator.getPreferredSize().width;
            }
            if (this.myShortcutLabel != null) {
                this.myShortcutLabel.setBorder(new EmptyBorder(0, 0, 0, expectedRightInset - leftRightInset));
                expectedRightInset = leftRightInset;
            }
            selectablePanel.setBorder((Border)new EmptyBorder(0, innerInsets.left + leftRightInset, 0, expectedRightInset));
        }
        if (step2 instanceof BaseListPopupStep) {
            E prevValue;
            Color bg = ((BaseListPopupStep)step2).getBackgroundFor(value);
            Color fg = ((BaseListPopupStep)step2).getForegroundFor(value);
            if (!isSelected && fg != null) {
                this.myTextLabel.setForeground(fg);
            }
            if (!isSelected && bg != null) {
                UIUtil.setBackgroundRecursively((Component)this.getItemComponent(), (Color)bg);
            }
            if (bg != null && this.mySeparatorComponent.isVisible() && this.myCurrentIndex > 0 && Comparing.equal((Object)bg, (Object)((BaseListPopupStep)step2).getBackgroundFor(prevValue = list2.getModel().getElementAt(this.myCurrentIndex - 1)))) {
                this.myRendererComponent.setBackground(bg);
            }
        }
        if (this.myMnemonicLabel != null && value instanceof NumericMnemonicItem && ((NumericMnemonicItem)value).digitMnemonicsEnabled()) {
            Character mnemonic = ((NumericMnemonicItem)value).getMnemonicChar();
            this.myMnemonicLabel.setText(mnemonic != null ? String.valueOf(mnemonic) : "");
            Color foreground = ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Popup.mnemonicForeground() : JBUI.CurrentTheme.ActionsList.MNEMONIC_FOREGROUND;
            this.myMnemonicLabel.setForeground(isSelected && isSelectable && !nextStepButtonSelected ? this.getSelectionForeground() : foreground);
            this.myMnemonicLabel.setVisible(true);
            this.myTextLabel.setDisplayedMnemonicIndex(-1);
        } else if (step2.isMnemonicsNavigationEnabled()) {
            int pos;
            MnemonicNavigationFilter filter2 = step2.getMnemonicNavigationFilter();
            int n = pos = filter2 == null ? -1 : filter2.getMnemonicPos(value);
            if (pos != -1) {
                Object text2 = this.myTextLabel.getText();
                text2 = ((String)text2).substring(0, pos) + ((String)text2).substring(pos + 1);
                this.myTextLabel.setText((String)text2);
                this.myTextLabel.setDisplayedMnemonicIndex(pos);
            }
        } else {
            this.myTextLabel.setDisplayedMnemonicIndex(-1);
        }
        if (this.myShortcutLabel != null) {
            this.myShortcutLabel.setEnabled(isSelectable);
            this.myShortcutLabel.setText("");
            if (value instanceof ShortcutProvider) {
                AnAction action2;
                String firstShortcutText;
                ShortcutSet set = ((ShortcutProvider)value).getShortcut();
                String shortcutText = null;
                if (set != null && !(firstShortcutText = KeymapUtil.getShortcutText((ShortcutSet)set)).isEmpty()) {
                    shortcutText = firstShortcutText;
                }
                if (shortcutText == null && value instanceof AnActionHolder && (action2 = ((AnActionHolder)value).getAction()) instanceof UserDataHolder) {
                    shortcutText = (String)((UserDataHolder)action2).getUserData(CUSTOM_KEY_STROKE_TEXT);
                }
                if (shortcutText != null) {
                    this.myShortcutLabel.setText("     " + shortcutText);
                    if (ExperimentalUI.isNewUI()) {
                        this.myNextStepLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
                    }
                }
            }
            this.myShortcutLabel.setForeground(isSelected && isSelectable && !nextStepButtonSelected ? UIManager.getColor("MenuItem.acceleratorSelectionForeground") : UIManager.getColor("MenuItem.acceleratorForeground"));
        }
        if (this.mySecondaryTextLabel != null) {
            String string;
            if (this.isShowSecondaryText() && step2 instanceof ListPopupStepEx) {
                ListPopupStepEx o = (ListPopupStepEx)step2;
                string = o.getSecondaryTextFor(value);
            } else {
                string = null;
            }
            String valueLabelText = string;
            this.mySecondaryTextLabel.setText(valueLabelText);
            if (ExperimentalUI.isNewUI()) {
                this.mySecondaryTextLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)(Strings.isEmpty((String)valueLabelText) ? 0 : 6)));
            }
            boolean selected = isSelected && isSelectable && !nextStepButtonSelected;
            this.setForegroundSelected(this.mySecondaryTextLabel, selected);
        }
        if (this.mySecondaryIconLabel != null) {
            Icon icon2;
            if (this.isShowSecondaryIcon() && step2 instanceof ListPopupStepEx) {
                ListPopupStepEx o = (ListPopupStepEx)step2;
                v3 = o.getSecondaryIconFor(value);
            } else {
                v3 = icon2 = null;
            }
            if (icon2 != null) {
                this.mySecondaryIconLabel.setIcon(icon2);
                boolean selected = isSelected && isSelectable && !nextStepButtonSelected;
                this.setForegroundSelected(this.mySecondaryIconLabel, selected);
                this.mySecondaryIconLabel.setVisible(true);
            } else {
                this.mySecondaryIconLabel.setVisible(false);
            }
        }
        if (ExperimentalUI.isNewUI() && (jComponent = this.getItemComponent()) instanceof SelectablePanel) {
            selectablePanel = (SelectablePanel)jComponent;
            selectablePanel.setSelectionColor(isSelected && isSelectable ? UIUtil.getListSelectionBackground((boolean)true) : null);
            this.setSelected(this.myMainPane, isSelected && isSelectable);
        }
        if (this.myIconLabel != null && value instanceof PopupFactoryImpl.ActionItem) {
            PopupFactoryImpl.ActionItem actionItem = (PopupFactoryImpl.ActionItem)value;
            this.myIconLabel.getAccessibleContext().setAccessibleName(actionItem.getAccessibleIconDescription());
        }
    }

    protected boolean isShowSecondaryText() {
        return true;
    }

    protected boolean isShowSecondaryIcon() {
        return true;
    }

    private boolean updateExtraButtons(JList<? extends E> list2, E value, ListPopupStep<Object> step2, boolean isSelected, boolean hasNextIcon) {
        List<Object> extraButtons;
        Integer activeButtonIndex;
        GridBag gb = new GridBag().setDefaultFill(1).setDefaultAnchor(10).setDefaultWeightX(1.0).setDefaultWeightY(1.0);
        boolean isSelectable = step2.isSelectable(value);
        if (!isSelectable) {
            activeButtonIndex = null;
            extraButtons = Collections.emptyList();
        } else {
            activeButtonIndex = this.myInlineActionsSupport.getActiveButtonIndex(list2);
            extraButtons = this.myInlineActionsSupport.createExtraButtons(value, isSelected, !isSelected || activeButtonIndex == null ? -1 : activeButtonIndex);
        }
        if (!extraButtons.isEmpty()) {
            this.myButtonPane.removeAll();
            this.myButtonSeparator.setVisible(true);
            extraButtons.forEach(comp -> this.myButtonPane.add((Component)comp, gb.next()));
            if (activeButtonIndex != null && activeButtonIndex < extraButtons.size()) {
                String text2 = this.myInlineActionsSupport.getToolTipText(value, activeButtonIndex);
                this.myRendererComponent.setToolTipText(text2);
            }
            this.hasExtraButtons = true;
        } else if (!hasNextIcon && this.myInlineActionsSupport.hasExtraButtons(value)) {
            this.myButtonPane.removeAll();
            this.myButtonSeparator.setVisible(false);
            this.myButtonPane.add(Box.createHorizontalStrut(InlineActionsUtilKt.buttonWidth()), gb.next());
            this.hasExtraButtons = true;
        } else if (this.hasExtraButtons == null || this.hasExtraButtons.booleanValue()) {
            this.myButtonPane.removeAll();
            this.myButtonSeparator.setVisible(false);
            this.myButtonPane.add((Component)this.myNextStepLabel, gb.next());
            this.hasExtraButtons = false;
        }
        return !extraButtons.isEmpty();
    }

    protected JComponent createIconBar() {
        JBBox res = JBBox.createHorizontalBox();
        res.add((Component)this.myIconLabel);
        if (!ExperimentalUI.isNewUI()) {
            res.setBorder((Border)JBUI.Borders.emptyRight((int)JBUI.CurrentTheme.ActionsList.elementIconGap()));
            res.add((Component)this.myMnemonicLabel);
        } else {
            JPanel wrapper2 = new JPanel(new BorderLayout());
            wrapper2.add(this.myMnemonicLabel);
            res.add((Component)wrapper2);
        }
        return res;
    }

    private Color calcBackground(boolean selected) {
        return selected ? this.getSelectionBackground() : this.getBackground();
    }

    @NotNull
    static Insets getListCellPadding() {
        if (ExperimentalUI.isNewUI()) {
            int leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get();
            JBInsets jBInsets = JBUI.insets((int)0, (int)leftRightInset, (int)0, (int)leftRightInset);
            if (jBInsets == null) {
                PopupListElementRenderer.$$$reportNull$$$0(2);
            }
            return jBInsets;
        }
        Insets insets = UIUtil.getListCellPadding();
        if (insets == null) {
            PopupListElementRenderer.$$$reportNull$$$0(3);
        }
        return insets;
    }

    @NlsSafe
    protected String getDelegateAccessibleName() {
        String shortcutLabelAccessibleName;
        String textLabelAccessibleName = this.myTextLabel == null ? null : this.myTextLabel.getAccessibleContext().getAccessibleName();
        String string = shortcutLabelAccessibleName = this.myShortcutLabel == null ? null : this.myShortcutLabel.getAccessibleContext().getAccessibleName();
        if (shortcutLabelAccessibleName != null) {
            shortcutLabelAccessibleName = shortcutLabelAccessibleName.trim();
        }
        String additionalLabels = AccessibleContextUtil.getCombinedName((String)", ", (Component[])new Component[]{this.mySecondaryTextLabel, this.myIconLabel, this.myNextStepLabel});
        return AccessibleContextUtil.combineAccessibleStrings((String)textLabelAccessibleName, (String)" ", (String)shortcutLabelAccessibleName, (String)", ", (String)additionalLabels);
    }

    @TestOnly
    public String getTextInTests() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return this.myTextLabel.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPopup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/list/PopupListElementRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/list/PopupListElementRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonsSeparator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellPadding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

