/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.TreeWalkerBase;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class AbstractTreeWalker<N>
extends TreeWalkerBase<N> {
    private final AtomicReference<State> state;
    private final AsyncPromise<TreePath> promise;
    private final ArrayDeque<ArrayDeque<N>> stack;
    private final Function<? super N, Object> converter;
    private final TreeVisitor visitor;
    private volatile TreePath current;

    public AbstractTreeWalker(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            AbstractTreeWalker.$$$reportNull$$$0(0);
        }
        this(visitor, node -> node);
    }

    public AbstractTreeWalker(@NotNull TreeVisitor visitor, Function<? super N, Object> converter) {
        if (visitor == null) {
            AbstractTreeWalker.$$$reportNull$$$0(1);
        }
        this.state = new AtomicReference();
        this.promise = new AsyncPromise();
        this.stack = new ArrayDeque();
        this.converter = converter;
        this.visitor = visitor;
    }

    @Override
    public void setChildren(@NotNull Collection<? extends N> children2) {
        boolean paused;
        if (children2 == null) {
            AbstractTreeWalker.$$$reportNull$$$0(2);
        }
        if (!(paused = this.state.compareAndSet(State.PAUSED, State.STARTED)) && !this.state.compareAndSet(State.REQUESTED, State.STARTED)) {
            throw new IllegalStateException();
        }
        this.stack.push(new ArrayDeque<N>(children2));
        if (paused) {
            this.processNextPath();
        }
    }

    @Override
    @NotNull
    public Promise<TreePath> promise() {
        AsyncPromise<TreePath> asyncPromise = this.promise;
        if (asyncPromise == null) {
            AbstractTreeWalker.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    @Override
    public void setError(@NotNull Throwable error2) {
        if (error2 == null) {
            AbstractTreeWalker.$$$reportNull$$$0(4);
        }
        this.state.set(State.FAILED);
        this.promise.setError(error2);
    }

    @Override
    public void start(N node) {
        this.start(null, node);
    }

    public void start(TreePath parent, N node) {
        TreePath result2 = null;
        if (node != null) {
            try {
                TreePath path = TreePathUtil.createTreePath(parent, this.converter.apply(node));
                switch (this.visitor.visit(path)) {
                    case CONTINUE: {
                        this.update(null, State.REQUESTED);
                        if (this.processChildren(path, node)) {
                            this.processNextPath();
                        }
                        return;
                    }
                    case INTERRUPT: {
                        result2 = path;
                        break;
                    }
                }
            }
            catch (Exception error2) {
                this.setError(error2);
                return;
            }
        }
        this.update(null, State.FINISHED);
        this.promise.setResult(result2);
    }

    private boolean processChildren(@NotNull TreePath path, @NotNull N node) {
        if (path == null) {
            AbstractTreeWalker.$$$reportNull$$$0(5);
        }
        if (node == null) {
            AbstractTreeWalker.$$$reportNull$$$0(6);
        }
        this.current = path;
        Collection<N> children2 = this.getChildren(node);
        if (children2 == null) {
            return !this.state.compareAndSet(State.REQUESTED, State.PAUSED);
        }
        this.update(State.REQUESTED, State.STARTED);
        this.stack.push(new ArrayDeque<N>(children2));
        return true;
    }

    private void processNextPath() {
        try {
            while (State.STARTED == this.state.get()) {
                TreePath path;
                ArrayDeque<N> siblings = this.stack.peek();
                if (siblings == null) {
                    this.update(State.STARTED, State.FINISHED);
                    this.current = null;
                    this.promise.setResult(null);
                    return;
                }
                N node = siblings.poll();
                if (node == null) {
                    path = this.current;
                    if (path == null) {
                        throw new IllegalStateException();
                    }
                    if (siblings != this.stack.poll()) {
                        throw new IllegalStateException();
                    }
                    this.current = path.getParentPath();
                    continue;
                }
                path = TreePathUtil.createTreePath(this.current, this.converter.apply(node));
                switch (this.visitor.visit(path)) {
                    case CONTINUE: {
                        this.update(State.STARTED, State.REQUESTED);
                        if (this.processChildren(path, node)) break;
                        return;
                    }
                    case INTERRUPT: {
                        this.update(State.STARTED, State.FINISHED);
                        this.current = null;
                        this.stack.clear();
                        this.promise.setResult((Object)path);
                        return;
                    }
                    case SKIP_SIBLINGS: {
                        siblings.clear();
                        break;
                    }
                }
            }
        }
        catch (Exception error2) {
            this.setError(error2);
        }
    }

    private void update(State expected, @NotNull State replacement) {
        if (replacement == null) {
            AbstractTreeWalker.$$$reportNull$$$0(7);
        }
        if (!this.state.compareAndSet(expected, replacement)) {
            throw new IllegalStateException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AbstractTreeWalker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AbstractTreeWalker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setError";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static enum State {
        STARTED,
        REQUESTED,
        PAUSED,
        FINISHED,
        FAILED;

    }
}

