/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/netty/bootstrap/BootstrapUtil;", "", "<init>", "()V", "initAndRegister", "Lio/netty/channel/ChannelFuture;", "channel", "Lio/netty/channel/Channel;", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "intellij.platform.ide.util.netty"})
public final class BootstrapUtil {
    @NotNull
    public static final BootstrapUtil INSTANCE = new BootstrapUtil();

    private BootstrapUtil() {
    }

    @NotNull
    public final ChannelFuture initAndRegister(@NotNull Channel channel, @NotNull Bootstrap bootstrap) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)bootstrap, (String)"bootstrap");
        try {
            bootstrap.init(channel);
        }
        catch (Throwable e) {
            channel.unsafe().closeForcibly();
            throw e;
        }
        ChannelFuture registrationFuture = bootstrap.config().group().register(channel);
        if (registrationFuture.cause() != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
        Intrinsics.checkNotNull((Object)registrationFuture);
        return registrationFuture;
    }
}

