/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.annotations.Interpretable;
import org.jetbrains.kotlinx.dataframe.api.CreateDataFrameDsl;
import org.jetbrains.kotlinx.dataframe.api.TraversePropertiesDsl;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.api.ToDataFrameKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001.B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u00030\u0013j\u0002`\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016J,\u0010\u001b\u001a\u00020\u0018*\u00020\u001c2\u001d\u0010\u001d\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\u00180\u001e\u00a2\u0006\u0002\b\u001fH\u0096\u0002JL\u0010 \u001a\u00020\u00182\u001a\u0010!\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030#0\"\"\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020%2\u0019\u0010&\u001a\u0015\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001e\u00a2\u0006\u0002\b\u001fH\u0016\u00a2\u0006\u0002\u0010'J*\u0010(\u001a\u00020\u00182\u001a\u0010)\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030*0\"\"\u0006\u0012\u0002\b\u00030*H\u0097\u0001\u00a2\u0006\u0002\u0010+J*\u0010(\u001a\u00020\u00182\u001a\u0010 \u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030#0\"\"\u0006\u0012\u0002\b\u00030#H\u0097\u0001\u00a2\u0006\u0002\u0010,J*\u0010-\u001a\u00020\u00182\u001a\u0010)\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030*0\"\"\u0006\u0012\u0002\b\u00030*H\u0097\u0001\u00a2\u0006\u0002\u0010+J*\u0010-\u001a\u00020\u00182\u001a\u0010 \u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030#0\"\"\u0006\u0012\u0002\b\u00030#H\u0097\u0001\u00a2\u0006\u0002\u0010,R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0002\b\u00030\u0013j\u0002`\u00140\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/api/CreateDataFrameDsl;", "Lorg/jetbrains/kotlinx/dataframe/api/TraversePropertiesDsl;", "source", "", "type", "Lkotlin/reflect/KType;", "prefix", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "configuration", "Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl$TraverseConfiguration;", "<init>", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl$TraverseConfiguration;)V", "getSource", "()Ljava/lang/Iterable;", "columns", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyBaseCol;", "getColumns$core", "()Ljava/util/List;", "add", "", "column", "path", "invoke", "", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "properties", "roots", "", "Lkotlin/reflect/KCallable;", "maxDepth", "", "body", "([Lkotlin/reflect/KCallable;ILkotlin/jvm/functions/Function1;)V", "exclude", "classes", "Lkotlin/reflect/KClass;", "([Lkotlin/reflect/KClass;)V", "([Lkotlin/reflect/KCallable;)V", "preserve", "TraverseConfiguration", "core"})
@SourceDebugExtension(value={"SMAP\ntoDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 toDataFrame.kt\norg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1869#2,2:439\n*S KotlinDebug\n*F\n+ 1 toDataFrame.kt\norg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl\n*L\n193#1:439,2\n*E\n"})
public final class CreateDataFrameDslImpl<T>
extends CreateDataFrameDsl<T>
implements TraversePropertiesDsl {
    @NotNull
    private final Iterable<T> source;
    @NotNull
    private final KType type;
    @NotNull
    private final ColumnPath prefix;
    @NotNull
    private final TraverseConfiguration configuration;
    @NotNull
    private final List<Pair<ColumnPath, BaseColumn<?>>> columns;

    public CreateDataFrameDslImpl(@NotNull Iterable<? extends T> source, @NotNull KType type, @NotNull ColumnPath prefix, @NotNull TraverseConfiguration configuration) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.source = source;
        this.type = type;
        this.prefix = prefix;
        this.configuration = configuration;
        this.columns = new ArrayList();
    }

    public /* synthetic */ CreateDataFrameDslImpl(Iterable iterable, KType kType, ColumnPath columnPath, TraverseConfiguration traverseConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            columnPath = UtilsKt.emptyPath();
        }
        if ((n & 8) != 0) {
            traverseConfiguration = new TraverseConfiguration();
        }
        this(iterable, kType, columnPath, traverseConfiguration);
    }

    @Override
    @NotNull
    public Iterable<T> getSource() {
        return this.source;
    }

    @NotNull
    public final List<Pair<ColumnPath, BaseColumn<?>>> getColumns$core() {
        return this.columns;
    }

    @Override
    public void add(@NotNull BaseColumn<?> column2, @Nullable ColumnPath path) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnPath columnPath = path;
        BaseColumn<?> col = columnPath != null ? column2.rename((String)CollectionsKt.last((List)columnPath)) : column2;
        ColumnPath targetPath = path != null ? this.prefix.plus(path) : this.prefix.plus(column2.name());
        this.columns.add(TuplesKt.to((Object)targetPath, col));
    }

    @Override
    public void invoke(@NotNull String $this$invoke, @NotNull Function1<? super CreateDataFrameDsl<T>, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        CreateDataFrameDslImpl<T> child = new CreateDataFrameDslImpl<T>(this.getSource(), this.type, this.prefix.plus($this$invoke), null, 8, null);
        builder.invoke(child);
        this.columns.addAll((Collection)child.columns);
    }

    @Override
    public void properties(@NotNull KCallable<?>[] roots, int maxDepth, @Nullable Function1<? super TraversePropertiesDsl, Unit> body) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        int n = roots.length;
        for (int i = 0; i < n; ++i) {
            KCallable<?> prop = roots[i];
            if (UtilsKt.isGetterLike(prop)) continue;
            boolean bl = false;
            String string = prop.getName() + " is not a property or getter-like function. Only those are traversed and can be added as roots.";
            throw new IllegalArgumentException(string.toString());
        }
        TraverseConfiguration dsl = this.configuration.clone();
        if (body != null) {
            body.invoke((Object)dsl);
        }
        DataFrame<?> df = ToDataFrameKt.convertToDataFrame(this.getSource(), this.type, ArraysKt.toList((Object[])roots), dsl.getExcludeProperties(), dsl.getPreserveClasses(), dsl.getPreserveProperties(), dsl.getExcludeClasses(), maxDepth);
        Iterable $this$forEach$iv = df.columns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataColumn it = (DataColumn)element$iv;
            boolean bl = false;
            CreateDataFrameDsl.add$default(this, it, null, 2, null);
        }
    }

    @Override
    @Interpretable(interpreter="Exclude0")
    public void exclude(KClass<?> ... classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.configuration.exclude(classes);
    }

    @Override
    @Interpretable(interpreter="Exclude1")
    public void exclude(KCallable<?> ... properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.configuration.exclude(properties);
    }

    @Override
    @Interpretable(interpreter="Preserve0")
    public void preserve(KClass<?> ... classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.configuration.preserve(classes);
    }

    @Override
    @Interpretable(interpreter="Preserve1")
    public void preserve(KCallable<?> ... properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.configuration.preserve(properties);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0000J)\u0010\u0011\u001a\u00020\u00122\u001a\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0014\"\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0002\u0010\u0015J)\u0010\u0011\u001a\u00020\u00122\u001a\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\u0014\"\u0006\u0012\u0002\b\u00030\nH\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u00020\u00122\u001a\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\u0014\"\u0006\u0012\u0002\b\u00030\nH\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u00020\u00122\u001a\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0014\"\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0002\u0010\u0015R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001b\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u001b\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/api/CreateDataFrameDslImpl$TraverseConfiguration;", "Lorg/jetbrains/kotlinx/dataframe/api/TraversePropertiesDsl;", "<init>", "()V", "excludeProperties", "", "Lkotlin/reflect/KCallable;", "getExcludeProperties", "()Ljava/util/Set;", "excludeClasses", "Lkotlin/reflect/KClass;", "getExcludeClasses", "preserveClasses", "getPreserveClasses", "preserveProperties", "getPreserveProperties", "clone", "exclude", "", "properties", "", "([Lkotlin/reflect/KCallable;)V", "classes", "([Lkotlin/reflect/KClass;)V", "preserve", "core"})
    public static final class TraverseConfiguration
    implements TraversePropertiesDsl {
        @NotNull
        private final Set<KCallable<?>> excludeProperties = new LinkedHashSet();
        @NotNull
        private final Set<KClass<?>> excludeClasses = new LinkedHashSet();
        @NotNull
        private final Set<KClass<?>> preserveClasses = new LinkedHashSet();
        @NotNull
        private final Set<KCallable<?>> preserveProperties = new LinkedHashSet();

        @NotNull
        public final Set<KCallable<?>> getExcludeProperties() {
            return this.excludeProperties;
        }

        @NotNull
        public final Set<KClass<?>> getExcludeClasses() {
            return this.excludeClasses;
        }

        @NotNull
        public final Set<KClass<?>> getPreserveClasses() {
            return this.preserveClasses;
        }

        @NotNull
        public final Set<KCallable<?>> getPreserveProperties() {
            return this.preserveProperties;
        }

        @NotNull
        public final TraverseConfiguration clone() {
            TraverseConfiguration traverseConfiguration;
            TraverseConfiguration it = traverseConfiguration = new TraverseConfiguration();
            boolean bl = false;
            it.excludeClasses.addAll((Collection)this.excludeClasses);
            it.excludeProperties.addAll((Collection)this.excludeProperties);
            it.preserveProperties.addAll((Collection)this.preserveProperties);
            it.preserveClasses.addAll((Collection)this.preserveClasses);
            return traverseConfiguration;
        }

        @Override
        public void exclude(KCallable<?> ... properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            int n = properties.length;
            for (int i = 0; i < n; ++i) {
                KCallable<?> prop = properties[i];
                if (UtilsKt.isGetterLike(prop)) continue;
                boolean bl = false;
                String string = prop.getName() + " is not a property or getter-like function. Only those are traversed and can be excluded.";
                throw new IllegalArgumentException(string.toString());
            }
            CollectionsKt.addAll((Collection)this.excludeProperties, (Object[])properties);
        }

        @Override
        public void exclude(KClass<?> ... classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            CollectionsKt.addAll((Collection)this.excludeClasses, (Object[])classes);
        }

        @Override
        public void preserve(KClass<?> ... classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            CollectionsKt.addAll((Collection)this.preserveClasses, (Object[])classes);
        }

        @Override
        public void preserve(KCallable<?> ... properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            int n = properties.length;
            for (int i = 0; i < n; ++i) {
                KCallable<?> prop = properties[i];
                if (UtilsKt.isGetterLike(prop)) continue;
                boolean bl = false;
                String string = prop.getName() + " is not a property or getter-like function. Only those are traversed and can be preserved.";
                throw new IllegalArgumentException(string.toString());
            }
            CollectionsKt.addAll((Collection)this.preserveProperties, (Object[])properties);
        }
    }
}

