/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ASTDelegatePsiElement
extends PsiElementBase {
    private static final Logger LOG = Logger.getInstance(ASTDelegatePsiElement.class);

    @Override
    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this.getNode());
        if (file == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file;
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        ASTDelegatePsiElement parent = this;
        while (parent instanceof ASTDelegatePsiElement) {
            parent = parent.getParent();
        }
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return (PsiManagerEx)parent.getManager();
    }

    public PsiElement @NotNull [] getChildren() {
        return ASTDelegatePsiElement.getChildrenSkippingLeaves((PsiElement)this);
    }

    @ApiStatus.Internal
    public static PsiElement @NotNull [] getChildrenSkippingLeaves(@NotNull PsiElement element) {
        PsiElement psiChild;
        if (element == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(0);
        }
        if ((psiChild = element.getFirstChild()) == null) {
            if (EMPTY_ARRAY == null) {
                ASTDelegatePsiElement.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = null;
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                if (result == null) {
                    result = new ArrayList<PsiElement>();
                }
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] psiElementArray = result == null ? EMPTY_ARRAY : PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this.getNode());
    }

    public PsiElement getParent() {
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this.getNode());
    }

    public TextRange getTextRange() {
        return this.getNode().getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.getNode().getStartOffset() - this.getNode().getTreeParent().getStartOffset();
    }

    public int getTextLength() {
        return this.getNode().getTextLength();
    }

    public PsiElement findElementAt(int offset) {
        ASTNode treeElement = this.getNode().findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(treeElement);
    }

    public int getTextOffset() {
        return this.getNode().getStartOffset();
    }

    public String getText() {
        return this.getNode().getText();
    }

    public char @NotNull [] textToCharArray() {
        char[] cArray = this.getNode().getText().toCharArray();
        if (cArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(3);
        }
        return cArray;
    }

    @Override
    public boolean textContains(char c) {
        return this.getNode().textContains(c);
    }

    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        if (key == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(4);
        }
        return (T)this.getNode().getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(5);
        }
        this.getNode().putCopyableUserData(key, value);
    }

    @NotNull
    public abstract ASTNode getNode();

    public void subtreeChanged() {
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getNode().getElementType().getLanguage();
        if (language == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(6);
        }
        return language;
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(@NotNull IElementType type) {
        ASTNode node;
        if (type == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(7);
        }
        return (T)((node = this.getNode().findChildByType(type)) == null ? null : node.getPsi());
    }

    @Nullable
    protected <T extends PsiElement> T findLastChildByType(@NotNull IElementType type) {
        if (type == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(8);
        }
        for (PsiElement child = this.getLastChild(); child != null; child = child.getPrevSibling()) {
            ASTNode node = child.getNode();
            if (node == null || node.getElementType() != type) continue;
            return (T)child;
        }
        return null;
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(@NotNull IElementType type) {
        if (type == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(9);
        }
        PsiElement psiElement = (PsiElement)this.notNullChild(this.findChildByType(type));
        if (psiElement == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(10);
        }
        return (T)psiElement;
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(@NotNull TokenSet type) {
        ASTNode node;
        if (type == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(11);
        }
        return (T)((node = this.getNode().findChildByType(type)) == null ? null : node.getPsi());
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(@NotNull TokenSet type) {
        if (type == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(12);
        }
        PsiElement psiElement = (PsiElement)this.notNullChild(this.findChildByType(type));
        if (psiElement == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(13);
        }
        return (T)psiElement;
    }

    protected <T extends PsiElement> T @NotNull [] findChildrenByType(@NotNull IElementType elementType, @NotNull Class<T> arrayClass) {
        if (elementType == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(14);
        }
        if (arrayClass == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(15);
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])SharedImplUtil.getChildrenOfType(this.getNode(), elementType), arrayClass, s -> s.getPsi());
        if (psiElementArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(16);
        }
        return psiElementArray;
    }

    protected <T extends PsiElement> @Unmodifiable @NotNull List<T> findChildrenByType(@NotNull TokenSet elementType) {
        if (elementType == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(17);
        }
        List result = Collections.emptyList();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!elementType.contains(tt)) continue;
            if (result == Collections.emptyList()) {
                result = new ArrayList();
            }
            result.add(child.getPsi());
        }
        List list = result;
        if (list == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(18);
        }
        return list;
    }

    protected <T extends PsiElement> @Unmodifiable @NotNull List<T> findChildrenByType(@NotNull IElementType elementType) {
        if (elementType == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(19);
        }
        List result = Collections.emptyList();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (elementType != child.getElementType()) continue;
            if (result == Collections.emptyList()) {
                result = new ArrayList();
            }
            result.add(child.getPsi());
        }
        List list = result;
        if (list == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(20);
        }
        return list;
    }

    protected <T extends PsiElement> T @NotNull [] findChildrenByType(@NotNull TokenSet elementType, @NotNull Class<T> arrayClass) {
        if (elementType == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(21);
        }
        if (arrayClass == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(22);
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])this.getNode().getChildren(elementType), arrayClass, s -> s.getPsi());
        if (psiElementArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(23);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement copy() {
        return this.getNode().copyElement().getPsi();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(24);
        }
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(25);
        }
        return this.addInnerBefore(element, anchor);
    }

    private PsiElement addInnerBefore(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(26);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            if (treeElement instanceof TreeElement) {
                return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
            }
            return treeElement.getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(27);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        if (treeElement instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
        }
        return treeElement.getPsi();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(28);
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    public ASTNode addInternal(@NotNull ASTNode first, @NotNull ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before) {
        if (first == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(29);
        }
        if (last == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(30);
        }
        return CodeEditUtil.addChildren(this.getNode(), first, last, this.getAnchorNode(anchor, before));
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(31);
        }
        if (last == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(32);
        }
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((ASTDelegatePsiElement)parent).deleteChildInternal(this.getNode());
        } else if (parent instanceof CompositeElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((CompositeElement)parent).deleteChildInternal(this.getNode());
        } else if (parent instanceof PsiFile) {
            CheckUtil.checkWritable((PsiElement)this);
            parent.deleteChildRange((PsiElement)this, (PsiElement)this);
        } else {
            throw new UnsupportedOperationException(this.getClass().getName() + " under " + (parent == null ? "null" : parent.getClass().getName()));
        }
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(33);
        }
        ((CompositeElement)this.getNode()).deleteChildInternal(child);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this.getNode());
        LOG.assertTrue(lastElement.getTreeParent() == this.getNode());
        CodeEditUtil.removeChildren(this.getNode(), firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(34);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            ASTDelegatePsiElement parentElement = (ASTDelegatePsiElement)this.getParent();
            parentElement.replaceChildInternal((PsiElement)this, elementCopy);
        } else {
            CodeEditUtil.replaceChild(this.getParent().getNode(), this.getNode(), elementCopy);
        }
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public void replaceChildInternal(PsiElement child, TreeElement newElement) {
        CodeEditUtil.replaceChild(this.getNode(), child.getNode(), newElement);
    }

    @Nullable
    private ASTNode getAnchorNode(@Nullable ASTNode anchor, @Nullable Boolean before) {
        assert (anchor == null || before != null);
        if (anchor != null) {
            return before != false ? anchor : anchor.getTreeNext();
        }
        if (before != null && !before.booleanValue()) {
            return this.getNode().getFirstChildNode();
        }
        return null;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        ASTNode node;
        if (text == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(35);
        }
        return (node = this.getNode()) instanceof TreeElement ? ((TreeElement)node).textMatches(text) : super.textMatches(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/extapi/psi/ASTDelegatePsiElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayClass";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/extapi/psi/ASTDelegatePsiElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenSkippingLeaves";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotNullChildByType";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSkippingLeaves";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLastChildByType";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNotNullChildByType";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenByType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addInnerBefore";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addInternal";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

