/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubBasedPsiElementBase<T extends StubElement>
extends ASTDelegatePsiElement {
    public static final Key<String> CREATION_TRACE = Key.create((String)"CREATION_TRACE");
    public static final boolean ourTraceStubAstBinding = "true".equals(System.getProperty("trace.stub.ast.binding", "false"));
    private volatile SubstrateRef mySubstrateRef;
    @NotNull
    private final IElementType myElementType;

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IStubElementType<?, ?> nodeType) {
        if (stub == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(1);
        }
        this.mySubstrateRef = new SubstrateRef.StubRef((StubElement<?>)stub);
        this.myElementType = nodeType;
    }

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IElementType nodeType) {
        if (stub == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(2);
        }
        if (nodeType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(3);
        }
        this.mySubstrateRef = new SubstrateRef.StubRef((StubElement<?>)stub);
        this.myElementType = nodeType;
    }

    public StubBasedPsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(4);
        }
        this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
        this.myElementType = node.getElementType();
    }

    public StubBasedPsiElementBase(T stub, IElementType nodeType, ASTNode node) {
        if (stub != null) {
            if (nodeType == null) {
                throw new IllegalArgumentException("null cannot be passed to 'nodeType' when 'stub' is non-null");
            }
            if (node != null) {
                throw new IllegalArgumentException("null must be passed to 'node' parameter when 'stub' is non-null");
            }
            this.mySubstrateRef = new SubstrateRef.StubRef((StubElement<?>)stub);
            this.myElementType = nodeType;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("'stub' and 'node' parameters cannot be null both");
            }
            if (nodeType != null) {
                throw new IllegalArgumentException("null must be passed to 'nodeType' parameter when 'node' is non-null");
            }
            this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
            this.myElementType = node.getElementType();
        }
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiFileImpl file = (PsiFileImpl)this.getContainingFile();
            if (!file.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)file);
            }
            FileElement treeElement = file.getTreeElement();
            if (treeElement != null && this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.notBoundInExistingAst(file, treeElement);
                if (aSTNode == null) {
                    StubBasedPsiElementBase.$$$reportNull$$$0(5);
                }
                return aSTNode;
            }
            treeElement = file.calcTreeElement();
            if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.failedToBindStubToAst(file, treeElement);
                if (aSTNode == null) {
                    StubBasedPsiElementBase.$$$reportNull$$$0(6);
                }
                return aSTNode;
            }
        }
        ASTNode aSTNode = this.mySubstrateRef.getNode();
        if (aSTNode == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(7);
        }
        return aSTNode;
    }

    private ASTNode failedToBindStubToAst(@NotNull PsiFileImpl file, @NotNull FileElement fileElement) {
        if (file == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(8);
        }
        if (fileElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(9);
        }
        VirtualFile vFile = file.getVirtualFile();
        StubTree stubTree = file.getStubTree();
        String stubString = stubTree != null ? ((PsiFileStubImpl)stubTree.getRoot()).printTree() : null;
        String astString = (String)RecursionManager.doPreventingRecursion((Object)"failedToBindStubToAst", (boolean)true, () -> DebugUtil.treeToString(fileElement, false));
        @NonNls String message = "Failed to bind stub to AST for element " + this.getClass() + " in " + (vFile == null ? "<unknown file>" : vFile.getPath()) + "\nFile:\n" + file + "@" + System.identityHashCode(file);
        String creationTraces = ourTraceStubAstBinding ? this.dumpCreationTraces(fileElement) : null;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (stubString != null) {
            attachments.add(new Attachment("stubTree.txt", stubString));
        }
        if (astString != null) {
            attachments.add(new Attachment("ast.txt", astString));
        }
        if (creationTraces != null) {
            attachments.add(new Attachment("creationTraces.txt", creationTraces));
        }
        throw new RuntimeExceptionWithAttachments(message, attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    @NotNull
    private String dumpCreationTraces(@NotNull FileElement fileElement) {
        if (fileElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(10);
        }
        final @NonNls StringBuilder traces = new StringBuilder("\nNow " + Thread.currentThread() + "\n");
        traces.append("My creation trace:\n").append((String)this.getUserData(CREATION_TRACE));
        traces.append("AST creation traces:\n");
        fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                PsiElement psi = composite.getPsi();
                if (psi != null) {
                    traces.append(psi).append("@").append(System.identityHashCode(psi)).append("\n");
                    String trace = (String)psi.getUserData(CREATION_TRACE);
                    if (trace != null) {
                        traces.append(trace).append("\n");
                    }
                }
                super.visitComposite(composite);
            }
        });
        String string = traces.toString();
        if (string == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    private ASTNode notBoundInExistingAst(@NotNull PsiFileImpl file, @NotNull FileElement treeElement) {
        if (file == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(12);
        }
        if (treeElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(13);
        }
        @NonNls String message = "file=" + file + "; tree=" + treeElement;
        for (StubBasedPsiElementBase each = this; each != null; each = each.getParentByStub()) {
            message = message + "\n each of class " + each.getClass() + "; valid=" + each.isValid();
            if (each instanceof StubBasedPsiElementBase) {
                message = message + "; ref=" + each.mySubstrateRef;
                continue;
            }
            if (!(each instanceof PsiFile)) break;
            message = message + "; same file=" + (each == file) + "; current tree= " + file.getTreeElement() + "; stubTree=" + file.getStubTree() + "; physical=" + file.isPhysical();
            break;
        }
        for (Object eachStub = this.getStub(); eachStub != null; eachStub = eachStub.getParentStub()) {
            message = message + "\n each stub " + (eachStub instanceof PsiFileStubImpl ? ((PsiFileStubImpl)((Object)eachStub)).getDiagnostics() : eachStub);
        }
        if (ourTraceStubAstBinding) {
            message = message + this.dumpCreationTraces(treeElement);
        }
        throw new AssertionError((Object)message);
    }

    @ApiStatus.Internal
    public final void setNode(@NotNull ASTNode node) {
        if (node == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(14);
        }
        this.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
    }

    @ApiStatus.Internal
    public final void setSubstrateRef(@NotNull SubstrateRef substrateRef) {
        if (substrateRef == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(15);
        }
        this.mySubstrateRef = substrateRef;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(16);
        }
        return language;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile;
        try {
            psiFile = this.mySubstrateRef.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            if (PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)this) != null) {
                throw new PsiInvalidElementAccessException((PsiElement)this, (Throwable)e);
            }
            throw e;
        }
        if (psiFile == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(17);
        }
        return psiFile;
    }

    @Override
    public boolean isWritable() {
        return this.getContainingFile().isWritable();
    }

    @Override
    public boolean isValid() {
        ProgressManager.checkCanceled();
        return this.mySubstrateRef.isValid();
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        return (PsiManagerEx)this.getContainingFile().getManager();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(18);
            }
            return project2;
        }
        Project project3 = this.getContainingFile().getProject();
        if (project3 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(19);
        }
        return project3;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    public PsiElement getContext() {
        T stub = this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getContext();
    }

    protected final PsiElement getParentByStub() {
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public PsiElement getParent() {
        T stub = this.getGreenStub();
        if (stub != null && !((ObjectStubBase)stub).isDangling()) {
            return stub.getParentStub().getPsi();
        }
        return SourceTreeToPsiMap.treeElementToPsi(this.getNode().getTreeParent());
    }

    @Deprecated
    @NotNull
    public IStubElementType getElementType() {
        if (!(this.myElementType instanceof IStubElementType)) {
            throw new ClassCastException("Don't use #getElementType method. It is deprecated.\nImplement and use #getIElementType with the help of #getElementTypeImpl.\nNot a stub type: " + this.myElementType + " in " + this.getClass());
        }
        IStubElementType iStubElementType = (IStubElementType)this.myElementType;
        if (iStubElementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(20);
        }
        return iStubElementType;
    }

    @NotNull
    protected final IElementType getElementTypeImpl() {
        IElementType iElementType = this.myElementType;
        if (iElementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(21);
        }
        return iElementType;
    }

    @Nullable
    public T getStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getStub());
    }

    @Nullable
    public final T getGreenStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getGreenStub());
    }

    @Nullable
    public final PsiElement getStubOrPsiChild(@NotNull IElementType elementType) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(22);
        }
        if ((stub = this.getGreenStub()) != null) {
            StubElement element = stub.findChildStubByElementType(elementType);
            if (element != null) {
                return element.getPsi();
            }
        } else {
            ASTNode childNode = this.getNode().findChildByType(elementType);
            if (childNode != null) {
                return childNode.getPsi();
            }
        }
        return null;
    }

    @NotNull
    public final PsiElement getRequiredStubOrPsiChild(@NotNull IElementType elementType) {
        PsiElement child;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(23);
        }
        if ((child = this.getStubOrPsiChild(elementType)) == null) {
            throw new IllegalStateException("Cannot find child of " + elementType + " in " + this);
        }
        PsiElement psiElement = child;
        if (psiElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    @Nullable
    public final <Psi extends PsiElement> Psi getStubOrPsiChild(@NotNull IElementType elementType, @NotNull Class<Psi> psiClass) {
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(25);
        }
        if (psiClass == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(26);
        }
        PsiElement child = this.getStubOrPsiChild(elementType);
        return (Psi)((PsiElement)psiClass.cast(child));
    }

    @NotNull
    public final <Psi extends PsiElement> Psi getRequiredStubOrPsiChild(@NotNull IElementType elementType, @NotNull Class<Psi> psiClass) {
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(27);
        }
        if (psiClass == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(28);
        }
        PsiElement child = this.getRequiredStubOrPsiChild(elementType);
        PsiElement psiElement = (PsiElement)psiClass.cast(child);
        if (psiElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(29);
        }
        return (Psi)psiElement;
    }

    public final <Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull IElementType elementType, @NotNull ArrayFactory<? extends Psi> f) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(30);
        }
        if (f == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(31);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, f);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(32);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(33);
        }
        return psiElements;
    }

    public final <Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull IElementType elementType, Psi @NotNull [] array) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(34);
        }
        if (array == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(35);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, array);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(36);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])array), (int)nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(37);
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull TokenSet filter, Psi @NotNull [] array) {
        T stub;
        if (filter == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(38);
        }
        if (array == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(39);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter, array);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(40);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])array), (int)nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(41);
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull TokenSet filter, @NotNull ArrayFactory<? extends Psi> f) {
        T stub;
        if (filter == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(42);
        }
        if (f == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(43);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter, f);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(44);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(45);
        }
        return psiElements;
    }

    @Nullable
    protected <E extends PsiElement> E getStubOrPsiParentOfType(@NotNull Class<E> parentClass) {
        T stub;
        if (parentClass == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(46);
        }
        if ((stub = this.getStub()) != null) {
            return (E)stub.getParentStubOfType(parentClass);
        }
        return (E)PsiTreeUtil.getParentOfType((PsiElement)this, parentClass);
    }

    protected Object clone() {
        StubBasedPsiElementBase copy = (StubBasedPsiElementBase)super.clone();
        copy.setSubstrateRef(SubstrateRef.createAstStrongRef(this.getNode()));
        return copy;
    }

    @Deprecated
    @Nullable
    public <Psi extends PsiElement> Psi getStubOrPsiChild(@NotNull IStubElementType<? extends StubElement, Psi> elementType) {
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(47);
        }
        return (Psi)this.getStubOrPsiChild((IElementType)elementType);
    }

    @Deprecated
    @NotNull
    public final <S extends StubElement<?>, Psi extends PsiElement> Psi getRequiredStubOrPsiChild(@NotNull IStubElementType<S, Psi> elementType) {
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(48);
        }
        return (Psi)this.getRequiredStubOrPsiChild((IElementType)elementType);
    }

    @Deprecated
    public final <S extends StubElement<?>, Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull ArrayFactory<? extends Psi> f) {
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(49);
        }
        if (f == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(50);
        }
        return this.getStubOrPsiChildren((IElementType)elementType, (ArrayFactory)f);
    }

    @Deprecated
    public final <S extends StubElement<?>, Psi extends PsiElement> Psi @NotNull [] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, Psi @NotNull [] array) {
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(51);
        }
        if (array == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(52);
        }
        return this.getStubOrPsiChildren((IElementType)elementType, (PsiElement[])array);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/extapi/psi/StubBasedPsiElementBase";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substrateRef";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 31: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 35: 
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/extapi/psi/StubBasedPsiElementBase";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpCreationTraces";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypeImpl";
                break;
            }
            case 24: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredStubOrPsiChild";
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "failedToBindStubToAst";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dumpCreationTraces";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notBoundInExistingAst";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSubstrateRef";
                break;
            }
            case 22: 
            case 25: 
            case 26: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChild";
                break;
            }
            case 23: 
            case 27: 
            case 28: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredStubOrPsiChild";
                break;
            }
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChildren";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiParentOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

