/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.ModuleLoadingRule;
import com.intellij.ide.plugins.PluginInitializationContext;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.Java11Shim;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u00020\bH\u0096\u0080\u0004R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/plugins/PluginContentDescriptor;", "", "modules", "", "Lcom/intellij/ide/plugins/PluginContentDescriptor$ModuleItem;", "<init>", "(Ljava/util/List;)V", "toString", "", "Companion", "ModuleItem", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginContentDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final List<ModuleItem> modules;
    @JvmField
    @NotNull
    public static final PluginContentDescriptor EMPTY = new PluginContentDescriptor(Java11Shim.INSTANCE.listOf());

    public PluginContentDescriptor(@NotNull List<ModuleItem> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
    }

    @NotNull
    public String toString() {
        return "PluginContentDescriptor(modules=" + this.modules + ')';
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/plugins/PluginContentDescriptor$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/ide/plugins/PluginContentDescriptor;", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0014J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0014H\u0007J\u0016\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\n\u0010$\u001a\u00020\u0005H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/intellij/ide/plugins/PluginContentDescriptor$ModuleItem;", "", "moduleId", "Lcom/intellij/ide/plugins/PluginModuleId;", "configFile", "", "descriptorContent", "", "loadingRule", "Lcom/intellij/ide/plugins/ModuleLoadingRule;", "requiredIfAvailable", "<init>", "(Lcom/intellij/ide/plugins/PluginModuleId;Ljava/lang/String;[CLcom/intellij/ide/plugins/ModuleLoadingRule;Lcom/intellij/ide/plugins/PluginModuleId;)V", "getModuleId", "()Lcom/intellij/ide/plugins/PluginModuleId;", "getConfigFile", "()Ljava/lang/String;", "getDescriptorContent$intellij_platform_core_impl", "()[C", "_descriptor", "Lcom/intellij/ide/plugins/ContentModuleDescriptor;", "assignDescriptor", "", "descriptor", "requireDescriptor", "getDescriptor", "()Lcom/intellij/ide/plugins/ContentModuleDescriptor;", "getDescriptorOrNull", "defaultLoadingRule", "getDefaultLoadingRule", "()Lcom/intellij/ide/plugins/ModuleLoadingRule;", "determineLoadingRule", "initContext", "Lcom/intellij/ide/plugins/PluginInitializationContext;", "diagnosticPluginId", "Lcom/intellij/openapi/extensions/PluginId;", "toString", "intellij.platform.core.impl"})
    @ApiStatus.Internal
    @SourceDebugExtension(value={"SMAP\nPluginContentDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginContentDescriptor.kt\ncom/intellij/ide/plugins/PluginContentDescriptor$ModuleItem\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n13#2:76\n*S KotlinDebug\n*F\n+ 1 PluginContentDescriptor.kt\ncom/intellij/ide/plugins/PluginContentDescriptor$ModuleItem\n*L\n61#1:76\n*E\n"})
    public static final class ModuleItem {
        @NotNull
        private final PluginModuleId moduleId;
        @Nullable
        private final String configFile;
        @Nullable
        private final char[] descriptorContent;
        @NotNull
        private final ModuleLoadingRule loadingRule;
        @Nullable
        private final PluginModuleId requiredIfAvailable;
        @Nullable
        private ContentModuleDescriptor _descriptor;

        public ModuleItem(@NotNull PluginModuleId moduleId, @Nullable String configFile, @Nullable char[] descriptorContent, @NotNull ModuleLoadingRule loadingRule, @Nullable PluginModuleId requiredIfAvailable) {
            Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
            Intrinsics.checkNotNullParameter((Object)((Object)loadingRule), (String)"loadingRule");
            this.moduleId = moduleId;
            this.configFile = configFile;
            this.descriptorContent = descriptorContent;
            this.loadingRule = loadingRule;
            this.requiredIfAvailable = requiredIfAvailable;
        }

        @NotNull
        public final PluginModuleId getModuleId() {
            return this.moduleId;
        }

        @Nullable
        public final String getConfigFile() {
            return this.configFile;
        }

        @Nullable
        public final char[] getDescriptorContent$intellij_platform_core_impl() {
            return this.descriptorContent;
        }

        public final void assignDescriptor(@NotNull ContentModuleDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this._descriptor = descriptor;
        }

        @NotNull
        public final ContentModuleDescriptor requireDescriptor() {
            ContentModuleDescriptor contentModuleDescriptor = this._descriptor;
            if (contentModuleDescriptor == null) {
                throw new IllegalStateException("Descriptor is not set for " + this);
            }
            return contentModuleDescriptor;
        }

        @NotNull
        public final ContentModuleDescriptor getDescriptor() {
            return this.requireDescriptor();
        }

        @TestOnly
        @Nullable
        public final ContentModuleDescriptor getDescriptorOrNull() {
            return this._descriptor;
        }

        @NotNull
        public final ModuleLoadingRule getDefaultLoadingRule() {
            return this.loadingRule;
        }

        @NotNull
        public final ModuleLoadingRule determineLoadingRule(@NotNull PluginInitializationContext initContext, @NotNull PluginId diagnosticPluginId) {
            Intrinsics.checkNotNullParameter((Object)initContext, (String)"initContext");
            Intrinsics.checkNotNullParameter((Object)diagnosticPluginId, (String)"diagnosticPluginId");
            if (this.requiredIfAvailable == null) {
                return this.loadingRule;
            }
            if (this.loadingRule == ModuleLoadingRule.EMBEDDED || this.loadingRule == ModuleLoadingRule.REQUIRED) {
                return this.loadingRule;
            }
            PluginInitializationContext.EnvironmentConfiguredModuleData targetModule = initContext.getEnvironmentConfiguredModules().get(this.requiredIfAvailable);
            if (targetModule == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(PluginManagerCore.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Plugin id='" + diagnosticPluginId + "' uses required-if-available statement in content module '" + this.moduleId.getName() + "' with a target module that is unknown or is not configured by the environment: " + this.requiredIfAvailable);
                return this.loadingRule;
            }
            if (targetModule.isAvailable()) {
                return ModuleLoadingRule.REQUIRED;
            }
            return this.loadingRule;
        }

        @NotNull
        public String toString() {
            return "ModuleItem(id=" + this.moduleId + ", descriptor=" + this._descriptor + ", configFile=" + this.configFile + ')';
        }
    }
}

