/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.NotNullList;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValueBase<T> {
    private static final Object[] PSI_MODIFICATION_DEPENDENCIES = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};

    protected abstract boolean isTrackValue();

    @Nullable
    protected abstract Data<T> getRawData();

    protected abstract void setData(@Nullable Data<T> var1);

    @NotNull
    private Data<T> computeData(@NotNull Computable<CachedValueProvider.Result<T>> doCompute) {
        CachedValueProfiler.ValueTracker tracker;
        CachedValueProvider.Result result;
        if (doCompute == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        if (CachedValueProfiler.isProfiling()) {
            try (CachedValueProfiler.Frame frame = CachedValueProfiler.newFrame();){
                result = (CachedValueProvider.Result)doCompute.compute();
                tracker = result == null ? null : frame.newValueTracker(result);
            }
        } else {
            result = (CachedValueProvider.Result)doCompute.compute();
            tracker = null;
        }
        if (result == null) {
            return new DefaultData<Object>(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY, ArrayUtil.EMPTY_LONG_ARRAY);
        }
        Object value = result.getValue();
        Object[] inferredDependencies = this.normalizeDependencies(value, result.getDependencyItems());
        long[] inferredTimeStamps = new long[inferredDependencies.length];
        for (int i = 0; i < inferredDependencies.length; ++i) {
            inferredTimeStamps[i] = this.getTimeStamp(inferredDependencies[i]);
        }
        if (tracker != null) {
            return new TrackedData<Object>(value, inferredDependencies, inferredTimeStamps, tracker);
        }
        if (inferredDependencies.length == 1 && inferredDependencies[0] == PsiModificationTracker.MODIFICATION_COUNT) {
            return new PsiDependentData<Object>(value, inferredTimeStamps[0]);
        }
        return new DefaultData<Object>(value, inferredDependencies, inferredTimeStamps);
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.setRawData(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setRawData(@Nullable Data<T> data) {
        this.setData(data);
    }

    protected Object @NotNull [] normalizeDependencies(@Nullable T value, Object @NotNull [] dependencyItems) {
        if (dependencyItems == null) {
            CachedValueBase.$$$reportNull$$$0(1);
        }
        NotNullList flattened = new NotNullList(dependencyItems.length + 1);
        CachedValueBase.collectDependencies(dependencyItems, (List<? super Object>)flattened);
        if (this.isTrackValue() && value != null) {
            if (value instanceof Object[]) {
                CachedValueBase.collectDependencies((Object[])value, (List<? super Object>)flattened);
            } else {
                flattened.add(value);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)flattened);
        if (objectArray == null) {
            CachedValueBase.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public void clear() {
        this.setRawData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data = this.getRawData();
        return data != null && this.checkUpToDate(data) ? data : null;
    }

    private boolean checkUpToDate(@NotNull Data<T> data) {
        CachedValueProfiler.ValueTracker trackingInfo;
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(3);
        }
        if (this.isUpToDate(data)) {
            return true;
        }
        if (data instanceof TrackedData && (trackingInfo = ((TrackedData)data).trackingInfo) != null) {
            trackingInfo.onValueInvalidated();
        }
        return false;
    }

    protected boolean isUpToDate(@NotNull Data<T> data) {
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(4);
        }
        if (data instanceof PsiDependentData) {
            return !this.isDependencyOutOfDate(PSI_MODIFICATION_DEPENDENCIES[0], ((PsiDependentData)data).getTimeStamp());
        }
        for (int i = 0; i < data.getDependencies().length; ++i) {
            Object dependency = data.getDependencies()[i];
            if (!this.isDependencyOutOfDate(dependency, data.getTimeStamps()[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(5);
        }
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private static void collectDependencies(Object @NotNull [] dependencies, @NotNull List<? super Object> resultingDeps) {
        if (resultingDeps == null) {
            CachedValueBase.$$$reportNull$$$0(6);
        }
        if (dependencies == null) {
            CachedValueBase.$$$reportNull$$$0(7);
        }
        for (Object dependency : dependencies) {
            if (dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                CachedValueBase.collectDependencies((Object[])dependency, resultingDeps);
                continue;
            }
            resultingDeps.add(dependency);
        }
    }

    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(8);
        }
        if (dependency instanceof VirtualFile) {
            return ((VirtualFile)dependency).getModificationStamp();
        }
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        Logger.getInstance(CachedValueBase.class).error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(@NotNull CachedValueProvider.Result<T> result) {
        if (result == null) {
            CachedValueBase.$$$reportNull$$$0(9);
        }
        Data<T> data = this.computeData(() -> result);
        this.setRawData(data);
        return data.getValue();
    }

    public abstract boolean isFromMyProject(@NotNull Project var1);

    @NotNull
    public abstract Object getValueProvider();

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data = this.getUpToDateOrNull();
        if (data != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(data, this.getValueProvider(), () -> this.computeData(() -> this.doCompute(param)));
            }
            return data.getValue();
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable calcData = () -> this.computeData(() -> this.doCompute(param));
        data = (Data)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, (Computable)calcData);
        if (data == null) {
            data = (Data)calcData.compute();
        } else if (stamp.mayCacheNow()) {
            CachedValueProfiler.ValueTracker trackingInfo;
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            do {
                boolean bl = reuse = (alreadyComputed = this.getRawData()) != null && this.checkUpToDate(alreadyComputed);
                if (!reuse) continue;
                IdempotenceChecker.checkEquivalence(alreadyComputed, data, this.getValueProvider().getClass(), calcData, this::getIdempotenceFailureContext);
            } while ((toReturn = this.cacheOrGetData(alreadyComputed, reuse ? null : data)) == null);
            if (data != toReturn && data instanceof TrackedData && (trackingInfo = ((TrackedData)data).trackingInfo) != null) {
                trackingInfo.onValueRejected();
            }
            return toReturn.getValue();
        }
        return data.getValue();
    }

    @NotNull
    protected String getIdempotenceFailureContext() {
        return "";
    }

    protected abstract <P> // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CachedValueProvider.Result<T> doCompute(P var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getValueProvider() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doCompute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyItems";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CachedValueBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultingDeps";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CachedValueBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDependencies";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkUpToDate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOutOfDate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    protected static class DefaultData<T>
    extends Data<T>
    implements Getter<T> {
        private final Object @NotNull [] myDependencies;
        private final long @NotNull [] myTimeStamps;

        protected DefaultData(T value, Object @NotNull [] dependencies, long @NotNull [] timeStamps) {
            if (dependencies == null) {
                DefaultData.$$$reportNull$$$0(0);
            }
            if (timeStamps == null) {
                DefaultData.$$$reportNull$$$0(1);
            }
            super(value);
            this.myDependencies = dependencies;
            this.myTimeStamps = timeStamps;
        }

        @Override
        public Object @NotNull [] getDependencies() {
            if (this.myDependencies == null) {
                DefaultData.$$$reportNull$$$0(2);
            }
            return this.myDependencies;
        }

        @Override
        public long @NotNull [] getTimeStamps() {
            if (this.myTimeStamps == null) {
                DefaultData.$$$reportNull$$$0(3);
            }
            return this.myTimeStamps;
        }

        @Override
        public T get() {
            return this.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeStamps";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/CachedValueBase$DefaultData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/CachedValueBase$DefaultData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeStamps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TrackedData<T>
    extends DefaultData<T> {
        @Nullable
        final CachedValueProfiler.ValueTracker trackingInfo;

        TrackedData(T value, Object @NotNull [] dependencies, long @NotNull [] timeStamps, @Nullable CachedValueProfiler.ValueTracker trackingInfo) {
            if (dependencies == null) {
                TrackedData.$$$reportNull$$$0(0);
            }
            if (timeStamps == null) {
                TrackedData.$$$reportNull$$$0(1);
            }
            super(value, dependencies, timeStamps);
            this.trackingInfo = trackingInfo;
        }

        @Override
        public T getValue() {
            if (this.trackingInfo != null) {
                this.trackingInfo.onValueUsed();
            }
            return super.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeStamps";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/CachedValueBase$TrackedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PsiDependentData<T>
    extends Data<T> {
        private final long myPsiTimeStamp;

        PsiDependentData(T value, long psiTimeStamp) {
            super(value);
            this.myPsiTimeStamp = psiTimeStamp;
        }

        private long getTimeStamp() {
            return this.myPsiTimeStamp;
        }

        @Override
        public Object @NotNull [] getDependencies() {
            Object[] objectArray = PSI_MODIFICATION_DEPENDENCIES;
            if (objectArray == null) {
                PsiDependentData.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @Override
        public long @NotNull [] getTimeStamps() {
            long[] lArray = new long[]{this.myPsiTimeStamp};
            if (lArray == null) {
                PsiDependentData.$$$reportNull$$$0(1);
            }
            return lArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/CachedValueBase$PsiDependentData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeStamps";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    @ApiStatus.NonExtendable
    public static abstract class Data<T>
    implements Getter<T> {
        private final T myValue;

        protected Data(T value) {
            this.myValue = value;
        }

        public abstract Object @NotNull [] getDependencies();

        public abstract long @NotNull [] getTimeStamps();

        public T get() {
            return this.getValue();
        }

        public T getValue() {
            return this.myValue;
        }
    }
}

