/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.util.HashSet;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"illegalChars", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "sanitizeFileName", "", "name", "replacement", "truncateIfNeeded", "", "extraIllegalChars", "Ljava/util/function/Predicate;", "intellij.platform.util"})
public final class Sanitize_nameKt {
    @NotNull
    private static final HashSet<Character> illegalChars;

    @NotNull
    public static final String sanitizeFileName(@NotNull String name, @Nullable String replacement, boolean truncateIfNeeded, @Nullable Predicate<Character> extraIllegalChars) {
        Intrinsics.checkNotNullParameter(name, "name");
        StringBuilder result = null;
        int last = 0;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (!illegalChars.contains(Character.valueOf(c)) && !Character.isISOControl(c) && (extraIllegalChars == null || !extraIllegalChars.test(Character.valueOf(c)))) continue;
            if (result == null) {
                result = new StringBuilder();
            }
            if (last < i) {
                result.append(name, last, i);
            }
            if (replacement != null) {
                result.append(replacement);
            }
            last = i + 1;
        }
        if (result == null) {
            return Sanitize_nameKt.sanitizeFileName$truncateFileName(truncateIfNeeded, length, name);
        }
        if (last < length) {
            result.append(name, last, length);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return Sanitize_nameKt.sanitizeFileName$truncateFileName(truncateIfNeeded, length, string);
    }

    public static /* synthetic */ String sanitizeFileName$default(String string, String string2, boolean bl, Predicate predicate, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "_";
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            predicate = null;
        }
        return Sanitize_nameKt.sanitizeFileName(string, string2, bl, predicate);
    }

    private static final String sanitizeFileName$truncateFileName(boolean $truncateIfNeeded, int length, String s) {
        String string;
        if ($truncateIfNeeded) {
            String string2 = s.substring(0, Math.min(length, 255));
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = s;
        }
        return string;
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('*'), Character.valueOf('|'), Character.valueOf('\"')};
        illegalChars = SetsKt.hashSetOf(characterArray);
    }
}

