/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.spring.boot.run.lifecycle.SpringBootJmxConnector;
import com.intellij.util.ArrayUtilRt;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectInstance;

class SpringBootActuatorConnector
extends SpringBootJmxConnector {
    static final String DEFAULT_DOMAIN = "org.springframework.boot";
    private static final String SPRING_BOOT_ENDPOINT_OBJECT_NAME = "%s:type=Endpoint,name=%s,*";
    private static final String CONTEXT_KEY_PROPERTY = "context";
    private static final String DATA_ATTR = "Data";

    SpringBootActuatorConnector(String serviceUrl, String domain, String beanName) {
        super(serviceUrl, String.format(SPRING_BOOT_ENDPOINT_OBJECT_NAME, domain, beanName));
    }

    Object getData(String operationName) throws Exception {
        Set<ObjectInstance> objectInstances = this.getJmxConnection().queryMBeans(this.getObjectName(), null);
        ObjectInstance objectInstance = objectInstances.stream().filter(o -> o.getObjectName().getKeyProperty(CONTEXT_KEY_PROPERTY) == null).findFirst().orElse(null);
        if (objectInstance == null) {
            throw new InstanceNotFoundException(this.getObjectName().toString());
        }
        if (operationName != null) {
            return this.getJmxConnection().invoke(objectInstance.getObjectName(), operationName, ArrayUtilRt.EMPTY_STRING_ARRAY, ArrayUtilRt.EMPTY_STRING_ARRAY);
        }
        return this.getJmxConnection().getAttribute(objectInstance.getObjectName(), DATA_ATTR);
    }
}

