/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootApplicationUrlPathProviderFactory;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootApplicationUrlUtilImpl
implements SpringBootApplicationUrlUtil {
    SpringBootApplicationUrlUtilImpl() {
    }

    @Nullable
    public String getServletPath(@NotNull SpringBootApplicationInfo info, @Nullable String path) {
        SpringBootApplicationServerConfiguration applicationServerConfiguration;
        String servletPath;
        if (info == null) {
            SpringBootApplicationUrlUtilImpl.$$$reportNull$$$0(0);
        }
        String string = servletPath = (applicationServerConfiguration = (SpringBootApplicationServerConfiguration)info.getServerConfiguration().getValue()) == null ? null : applicationServerConfiguration.getServletPath();
        if (StringUtil.isEmpty((String)path)) {
            return servletPath;
        }
        return Arrays.stream((SpringBootApplicationUrlPathProviderFactory[])SpringBootApplicationUrlPathProviderFactory.EP_NAME.getExtensions()).findFirst().map(factory -> factory.getServletPath(info, path)).orElse(servletPath);
    }

    @NotNull
    public String getMappingUrl(@NotNull String applicationUrl, @Nullable String servletPath, @Nullable String mappingPath) {
        if (applicationUrl == null) {
            SpringBootApplicationUrlUtilImpl.$$$reportNull$$$0(1);
        }
        return SpringBootApplicationUrlUtilImpl.appendPath(SpringBootApplicationUrlUtilImpl.appendPath(applicationUrl, servletPath), mappingPath);
    }

    @NotNull
    private static String appendPath(@NotNull String applicationUrl, @Nullable String path) {
        if (applicationUrl == null) {
            SpringBootApplicationUrlUtilImpl.$$$reportNull$$$0(2);
        }
        boolean endsWithSlash = StringUtil.endsWith((CharSequence)applicationUrl, (CharSequence)"/");
        if (path == null) {
            path = endsWithSlash ? "" : "/";
        } else if (endsWithSlash) {
            path = StringUtil.trimStart((String)path, (String)"/");
        } else if (!StringUtil.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = "/" + (String)path;
        }
        String string = applicationUrl + (String)path;
        if (string == null) {
            SpringBootApplicationUrlUtilImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void updatePath(@NotNull Project project, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, String path) {
        RunManagerImpl runManager;
        RunnerAndConfigurationSettings configurationSettings;
        if (project == null) {
            SpringBootApplicationUrlUtilImpl.$$$reportNull$$$0(4);
        }
        if (runConfiguration == null) {
            SpringBootApplicationUrlUtilImpl.$$$reportNull$$$0(5);
        }
        if ((configurationSettings = (runManager = (RunManagerImpl)RunManager.getInstance((Project)project)).findSettings((RunConfiguration)runConfiguration)) == null) {
            return;
        }
        if (configurationSettings.getConfiguration() instanceof SpringBootApplicationRunConfigurationBase) {
            ((SpringBootApplicationRunConfigurationBase)configurationSettings.getConfiguration()).setUrlPath(path);
            runConfiguration.setUrlPath(path);
            runManager.fireRunConfigurationChanged(configurationSettings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationUrlUtilImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationUrlUtilImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getServletPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMappingUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendPath";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updatePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

