/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.gutter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.run.icons.SpringBootRunIcons;
import com.intellij.spring.boot.run.lifecycle.beans.gutter.LiveBeansNavigationHandler;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.runtime.SpringRuntimeBean;
import com.intellij.spring.runtime.SpringRuntimeResource;
import com.intellij.spring.runtime.SpringRuntimeResourceContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.util.XmlTagUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class LiveBeansDomLineMarkerProvider
extends LineMarkerProviderDescriptor {
    LiveBeansDomLineMarkerProvider() {
    }

    public String getId() {
        return "LiveBeansDomLineMarkerProvider";
    }

    public String getName() {
        return SpringBootApiBundle.message((String)"runtime.beans.xml.gutter.icon.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return SpringBootRunIcons.Gutter.LiveBean;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        PsiElement psiElement;
        if (elements == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (!LiveBeansDomLineMarkerProvider.isSpringXml(file)) {
            return;
        }
        if (!LiveBeansNavigationHandler.hasLiveBeansModels(psiElement)) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            LiveBeansDomLineMarkerProvider.annotate(elements.get(i), result);
        }
    }

    private static void annotate(@NotNull PsiElement psiElement, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (psiElement == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            LiveBeansDomLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (!(psiElement instanceof XmlToken)) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof XmlTag)) {
            return;
        }
        XmlTag tag = (XmlTag)parent;
        if (XmlTagUtil.getStartTagNameElement((XmlTag)tag) != psiElement) {
            return;
        }
        DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(tag);
        if (!(element instanceof SpringBean)) {
            return;
        }
        SpringBean springBean = (SpringBean)element;
        BiPredicate<SpringRuntimeBean, SpringRuntimeResourceContext> beanMatcher = (liveBean, context) -> {
            SpringRuntimeResource liveResource = liveBean.getResource();
            PsiFile containingResource = psiElement.getContainingFile();
            assert (containingResource instanceof XmlFile);
            return liveResource != null && liveResource.matchesXmlConfig(containingResource, context);
        };
        LiveBeansNavigationHandler.addLiveBeansGutterIcon(List.of(springBean), beanMatcher, psiElement, false, result);
    }

    private static boolean isSpringXml(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        return SpringDomUtils.isSpringXml((XmlFile)xmlFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansDomLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

