/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.env;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.env.model.RuntimeEnvironmentModel;
import com.intellij.spring.boot.run.lifecycle.env.model.RuntimeEnvironmentParser;
import com.intellij.spring.boot.run.lifecycle.env.tab.EnvironmentTab;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J \u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/boot/run/lifecycle/env/EnvironmentEndpoint;", "Lcom/intellij/spring/boot/run/lifecycle/Endpoint;", "Lcom/intellij/spring/boot/run/lifecycle/env/model/RuntimeEnvironmentModel;", "<init>", "()V", "parseData", "data", "", "createEndpointTab", "Lcom/intellij/spring/boot/run/lifecycle/tabs/EndpointTab;", "runConfiguration", "Lcom/intellij/spring/boot/run/SpringBootApplicationRunConfigurationBase;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "isAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "intellij.spring.boot.run"})
public final class EnvironmentEndpoint
extends Endpoint<RuntimeEnvironmentModel> {
    public EnvironmentEndpoint() {
        super("env", "environmentEndpoint", "environment");
    }

    @Nullable
    public RuntimeEnvironmentModel parseData(@Nullable Object data) {
        if (data == null) {
            return null;
        }
        RuntimeEnvironmentParser parser = new RuntimeEnvironmentParser();
        return parser.parse(data);
    }

    @Nullable
    public EndpointTab<RuntimeEnvironmentModel> createEndpointTab(@NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Module module = runConfiguration.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        if (!this.isAvailable(module)) {
            return null;
        }
        return new EnvironmentTab((Endpoint<RuntimeEnvironmentModel>)((Endpoint)this), runConfiguration, processHandler);
    }

    public boolean isAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0);
    }
}

