/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.starters;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.ide.starters.remote.WebStarterDependency;
import com.intellij.microservices.jvm.dependencies.FrameworkDependenciesModificationContext;
import com.intellij.microservices.jvm.dependencies.FrameworkDependencyCoordinates;
import com.intellij.microservices.jvm.dependencies.Version;
import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.run.starters.SpringBootBomBean;
import com.intellij.spring.boot.run.starters.SpringBootCoordinates;
import com.intellij.spring.boot.run.starters.SpringBootStarterDependency;
import com.intellij.spring.boot.run.starters.SpringBootStarterModificationContext;
import com.intellij.spring.boot.run.starters.SpringBootStarterModificationContextKt;
import com.intellij.spring.boot.run.starters.customizers.SpringBootStarterCustomizer;
import com.intellij.spring.boot.run.starters.customizers.SpringBootStarterCustomizerKt;
import com.intellij.spring.boot.starters.SpringBootStarterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spring/boot/run/starters/SpringBootStarterModifier;", "", "module", "Lcom/intellij/openapi/module/Module;", "dependencies", "", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "selectedDependencies", "boms", "", "", "Lcom/intellij/spring/boot/run/starters/SpringBootBomBean;", "springBootVersion", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Map;Ljava/lang/String;)V", "launchModification", "", "modifyStarters", "doModifyStarters", "", "addDependencies", "context", "Lcom/intellij/microservices/jvm/dependencies/FrameworkDependenciesModificationContext;", "mapBomIdToManagedDependency", "Lcom/intellij/spring/boot/starters/SpringBootStarterManager$ManagedDependency;", "bomId", "intellij.spring.boot.run"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSpringBootStarterModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootStarterModifier.kt\ncom/intellij/spring/boot/run/starters/SpringBootStarterModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1642#2,10:69\n1915#2:79\n1916#2:83\n1652#2:84\n1642#2,10:85\n1915#2:95\n1916#2:97\n1652#2:98\n18#3:80\n1#4:81\n1#4:82\n1#4:96\n*S KotlinDebug\n*F\n+ 1 SpringBootStarterModifier.kt\ncom/intellij/spring/boot/run/starters/SpringBootStarterModifier\n*L\n43#1:69,10\n43#1:79\n43#1:83\n43#1:84\n53#1:85,10\n53#1:95\n53#1:97\n53#1:98\n46#1:80\n43#1:82\n53#1:96\n*E\n"})
public final class SpringBootStarterModifier {
    @NotNull
    private final Module module;
    @NotNull
    private final Collection<WebStarterDependency> dependencies;
    @NotNull
    private final Collection<WebStarterDependency> selectedDependencies;
    @NotNull
    private final Map<String, SpringBootBomBean> boms;
    @NotNull
    private final String springBootVersion;

    public SpringBootStarterModifier(@NotNull Module module, @NotNull Collection<? extends WebStarterDependency> dependencies, @NotNull Collection<? extends WebStarterDependency> selectedDependencies, @NotNull Map<String, SpringBootBomBean> boms, @NotNull String springBootVersion) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(selectedDependencies, (String)"selectedDependencies");
        Intrinsics.checkNotNullParameter(boms, (String)"boms");
        Intrinsics.checkNotNullParameter((Object)springBootVersion, (String)"springBootVersion");
        this.module = module;
        this.dependencies = dependencies;
        this.selectedDependencies = selectedDependencies;
        this.boms = boms;
        this.springBootVersion = springBootVersion;
    }

    public final void launchModification() {
        block0: {
            SpringBootStarterManager springBootStarterManager = SpringBootStarterManager.Companion.getInstanceFast(this.module);
            if (springBootStarterManager == null) break block0;
            springBootStarterManager.modifyAndRefresh(this.module, this::doModifyStarters);
        }
    }

    public final void modifyStarters() {
        block1: {
            if (!this.doModifyStarters()) break block1;
            SpringBootStarterManager springBootStarterManager = SpringBootStarterManager.Companion.getInstanceFast(this.module);
            if (springBootStarterManager != null) {
                springBootStarterManager.refresh(this.module);
            }
        }
    }

    private final boolean doModifyStarters() {
        Version version = Version.parse((String)this.springBootVersion);
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"parse(...)");
        SpringBootStarterModificationContext context = SpringBootStarterModificationContextKt.prepareModificationContext(this.dependencies, this.selectedDependencies, version);
        for (SpringBootStarterCustomizer customizer : SpringBootStarterCustomizerKt.getCUSTOMIZERS().values()) {
            customizer.customize(context);
        }
        return this.addDependencies(context);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addDependencies(FrameworkDependenciesModificationContext context) {
        List addedDependencies;
        block11: {
            SpringBootStarterManager manager;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv;
            HashSet<SpringBootCoordinates> addedBomIds = new HashSet<SpringBootCoordinates>();
            Iterable iterable = context.getAddedDependencies();
            boolean $i$f$mapNotNull = false;
            void var6_6 = $this$mapNotNull$iv;
            Iterable<UnifiedDependency> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UnifiedDependency unifiedDependency;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                WebStarterDependency it = (WebStarterDependency)element$iv$iv;
                boolean bl2 = false;
                SpringBootStarterDependency springBootStarterDependency = it instanceof SpringBootStarterDependency ? (SpringBootStarterDependency)it : null;
                if (springBootStarterDependency == null) {
                    unifiedDependency = null;
                } else {
                    SpringBootStarterDependency dependency = springBootStarterDependency;
                    if (dependency.getCoordinates() == null) {
                        unifiedDependency = null;
                    } else {
                        String string;
                        Object object;
                        FrameworkDependencyCoordinates coordinates;
                        FrameworkDependencyCoordinates $this$asSafely$iv = coordinates;
                        boolean $i$f$asSafely = false;
                        FrameworkDependencyCoordinates frameworkDependencyCoordinates = $this$asSafely$iv;
                        if (!(frameworkDependencyCoordinates instanceof SpringBootCoordinates)) {
                            frameworkDependencyCoordinates = null;
                        }
                        if ((object = (SpringBootCoordinates)frameworkDependencyCoordinates) != null && (object = object.getBom()) != null) {
                            Object bomId = object;
                            boolean bl3 = false;
                            addedBomIds.add((SpringBootCoordinates)((Object)bomId));
                        }
                        String string2 = coordinates.getGroupId();
                        String string3 = coordinates.getArtifactId();
                        String string4 = coordinates.getVersion();
                        if (string4 == null) {
                            string4 = "";
                        }
                        if ((string = coordinates.getScope()) == null) {
                            string = "compile";
                        }
                        unifiedDependency = new UnifiedDependency(string2, string3, string4, string);
                    }
                }
                if (unifiedDependency == null) continue;
                UnifiedDependency it$iv$iv = unifiedDependency;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            addedDependencies = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv2 = addedBomIds;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                SpringBootStarterManager.ManagedDependency it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String p0 = (String)element$iv$iv;
                boolean bl5 = false;
                if (this.mapBomIdToManagedDependency(p0) == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List addedBoms = (List)destination$iv$iv2;
            SpringBootStarterManager springBootStarterManager = manager = SpringBootStarterManager.Companion.getInstanceFast(this.module);
            if (springBootStarterManager != null) {
                springBootStarterManager.addManagedDependencies(this.module, (Collection)addedBoms);
            }
            SpringBootStarterManager springBootStarterManager2 = manager;
            if (springBootStarterManager2 == null) break block11;
            springBootStarterManager2.addDependencies(this.module, (Collection)addedDependencies);
        }
        return !((Collection)addedDependencies).isEmpty();
    }

    private final SpringBootStarterManager.ManagedDependency mapBomIdToManagedDependency(String bomId) {
        SpringBootStarterManager.ManagedDependency managedDependency;
        SpringBootBomBean springBootBomBean = this.boms.get(bomId);
        if (springBootBomBean != null) {
            SpringBootBomBean it = springBootBomBean;
            boolean bl = false;
            String string = it.getGroupId();
            if (string == null) {
                managedDependency = null;
            } else {
                String bomGroupId = string;
                String string2 = it.getArtifactId();
                if (string2 == null) {
                    managedDependency = null;
                } else {
                    String bomArtifactId = string2;
                    managedDependency = new SpringBootStarterManager.ManagedDependency(new UnifiedDependency(bomGroupId, bomArtifactId, it.getVersion(), "compile"), it.getVersionProperty());
                }
            }
        } else {
            managedDependency = null;
        }
        return managedDependency;
    }
}

