/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WslCommandLineConfigurator
extends NodeCommandLineConfigurator {
    private static final Key<Boolean> WSL_FLAG = Key.create((String)"WSL_FLAG");
    private final WslNodeInterpreter myInterpreter;
    public static final String NODE_OPTIONS = "NODE_OPTIONS";
    public static final String JB_INTERPRETER = "JB_INTERPRETER";
    public static final String JB_IDE_HOST = "JB_IDE_HOST";
    public static final String JB_WSL_MSG = "JB_WSL_MSG";
    private static final String NODE_OPTIONS_START_TEXT = "--require ";

    public WslCommandLineConfigurator(@NotNull WslNodeInterpreter interpreter2) {
        if (interpreter2 == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(0);
        }
        this.myInterpreter = interpreter2;
    }

    @Override
    public void configure(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        File cwd;
        String prependNodeOptionsCommand;
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(1);
        }
        if (!WslNodeInterpreterType.getInstance().isAvailable()) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.wsl.unavailable.dialog.message", (Object[])new Object[0]));
        }
        if (!NodeCommandLineConfigurator.isExePathSet(commandLine)) {
            commandLine.setExePath(this.myInterpreter.getWslInterpreterPath());
        }
        WSLDistribution distribution = this.myInterpreter.getDistribution();
        List parameters2 = commandLine.getParametersList().getParameters();
        for (int i = 0; i < parameters2.size(); ++i) {
            String wslPath = WslCommandLineConfigurator.convertPathToWsl((String)parameters2.get(i), distribution);
            if (wslPath == null) continue;
            commandLine.getParametersList().set(i, wslPath);
        }
        WSLCommandLineOptions options = new WSLCommandLineOptions().setPassEnvVarsUsingInterop(true);
        String prependNodeDirToPathCommand = this.getPrependNodeDirToPathCommand();
        if (prependNodeDirToPathCommand != null) {
            options.addInitCommand(prependNodeDirToPathCommand);
        }
        if ((prependNodeOptionsCommand = WslCommandLineConfigurator.getPrependNodeOptionsCommand(commandLine, distribution)) != null) {
            options.addInitCommand(prependNodeOptionsCommand);
        }
        if ((cwd = commandLine.getWorkDirectory()) != null) {
            options.setRemoteWorkingDirectory(WslCommandLineConfigurator.convertPathToWsl(cwd.getAbsolutePath(), distribution));
        }
        commandLine = distribution.patchCommandLine(commandLine, null, options);
        commandLine.putUserData(WSL_FLAG, (Object)true);
    }

    @Nullable
    private static String convertPathToWsl(@NotNull String value, @NotNull WSLDistribution distribution) {
        if (value == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(2);
        }
        if (distribution == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(3);
        }
        if (WslCommandLineConfigurator.isWindowsAbsolutePath(value)) {
            return distribution.getWslPath(value);
        }
        String convertedFromUnc = WslCommandLineConfigurator.convertUncPathToWsl(value, distribution);
        if (convertedFromUnc != null) {
            return convertedFromUnc;
        }
        if (value.startsWith("/")) {
            return FileUtil.toSystemIndependentName((String)value);
        }
        return null;
    }

    @Nullable
    public static String convertUncPathToWsl(@NotNull String windowsPath, @NotNull WSLDistribution distribution) {
        WslPath wslPath;
        if (windowsPath == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(4);
        }
        if (distribution == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(5);
        }
        return (wslPath = WslPath.parseWindowsUncPath((String)windowsPath)) != null && wslPath.getDistributionId().equals(distribution.getMsId()) ? wslPath.getLinuxPath() : null;
    }

    @Override
    public String convertLocalPathToRemote(@NotNull String localPath) {
        if (localPath == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(6);
        }
        return NodeInterpreterUtil.convertLocalPathToRemote(localPath, this.myInterpreter);
    }

    @Override
    @NotNull
    protected NodeJsInterpreter getInterpreter() {
        WslNodeInterpreter wslNodeInterpreter = this.myInterpreter;
        if (wslNodeInterpreter == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(7);
        }
        return wslNodeInterpreter;
    }

    private static boolean isWindowsAbsolutePath(@NotNull String value) {
        if (value == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(8);
        }
        return FileUtil.isWindowsAbsolutePath((String)value) && value.length() >= 3;
    }

    @Nullable
    private String getPrependNodeDirToPathCommand() {
        String defaultPath = "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games:/usr/local/games";
        String binDir = PathUtil.getParentPath((String)this.myInterpreter.getWslInterpreterPath());
        if (StringUtil.split((String)defaultPath, (String)":").contains(binDir)) {
            return null;
        }
        return "export PATH=\"" + CommandLineUtil.posixQuote((String)binDir) + ":$PATH\"";
    }

    @Nullable
    private static String getPrependNodeOptionsCommand(@NotNull GeneralCommandLine commandLine, WSLDistribution distribution) {
        String s;
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(9);
        }
        if ((s = (String)commandLine.getEnvironment().get(NODE_OPTIONS)) == null) {
            return null;
        }
        Object nodeOptions = StringUtil.notNullize((String)((String)commandLine.getEnvironment().get(NODE_OPTIONS)));
        int ind = ((String)nodeOptions).lastIndexOf(NODE_OPTIONS_START_TEXT);
        if (ind < 0) {
            return null;
        }
        String debugConnectorPath = ((String)nodeOptions).substring(ind + NODE_OPTIONS_START_TEXT.length());
        nodeOptions = ((String)nodeOptions).substring(0, ind + NODE_OPTIONS_START_TEXT.length()) + WslCommandLineConfigurator.convertPathToWsl(debugConnectorPath, distribution);
        commandLine.getEnvironment().put(NODE_OPTIONS, nodeOptions);
        String interpreter2 = (String)commandLine.getEnvironment().get(JB_INTERPRETER);
        if (interpreter2 != null) {
            commandLine.getEnvironment().put(JB_INTERPRETER, commandLine.getExePath());
        }
        if (distribution.getVersion() == 2) {
            String wslHost = WslCommandLineConfigurator.readHostIp(distribution);
            if (wslHost != null) {
                commandLine.getEnvironment().put(JB_IDE_HOST, wslHost);
            } else {
                WSLUtil.LOG.debug("Cannot compute WSL host");
            }
            commandLine.getEnvironment().put(JB_WSL_MSG, JavaScriptBundle.message((String)"node.wsl.network.connection.failure", (Object[])new Object[0]));
        }
        return null;
    }

    @Nullable
    private static String readHostIp(WSLDistribution distribution) {
        ProcessOutput output;
        String releaseInfo = "/etc/resolv.conf";
        try {
            output = distribution.executeOnWsl(10000, new String[]{"cat", "/etc/resolv.conf"});
        }
        catch (ExecutionException e) {
            return null;
        }
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug("Reading release info: " + distribution.getId());
        }
        if (!output.checkSuccess(WSLUtil.LOG)) {
            return null;
        }
        for (String line : output.getStdoutLines(true)) {
            if (!line.startsWith("nameserver")) continue;
            return line.substring("nameserver".length()).trim();
        }
        return null;
    }

    public static boolean isWslConfigured(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(10);
        }
        return commandLine.getUserData(WSL_FLAG) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslCommandLineConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslCommandLineConfigurator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertPathToWsl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertUncPathToWsl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertLocalPathToRemote";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsAbsolutePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrependNodeOptionsCommand";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWslConfigured";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

